/*
 * Decompiled with CFR 0.152.
 */
package com.nerjal.status_hider;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.nerjal.status_hider.StatusHider;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class CountryRangeHandler {
    private static final CountryRangeHandler INSTANCE = new CountryRangeHandler();
    private final Map<Integer, Map<Integer, Map<Integer, Map<Integer, Country>>>> map;

    private CountryRangeHandler() {
        HashMap<Integer, Map> map = new HashMap<Integer, Map>();
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            this.map = Map.copyOf(map);
            return;
        }
        try (InputStreamReader reader = new InputStreamReader(StatusHider.class.getResourceAsStream(((Path)((ModContainer)FabricLoader.getInstance().getModContainer("status_hider").get()).findPath("countries.json").get()).toString()));){
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            AtomicInteger count = new AtomicInteger(0);
            for (String code : json.keySet()) {
                JsonObject sub = json.getAsJsonObject(code);
                String name = (String)sub.keySet().iterator().next();
                JsonArray arr = sub.getAsJsonArray(name);
                String cName = name.equals("__") ? "unknown" : name;
                String cCode = code.equals("__") ? "unknown" : code;
                Country c = new Country(cName, cCode);
                for (JsonElement elem : arr) {
                    Entry e = Entry.of(elem.getAsString(), true);
                    if (e != null) {
                        while ((e.i4 & 1) == 0) {
                            e = e.shift((byte)1);
                        }
                        map.computeIfAbsent(e.i1, i -> new HashMap()).computeIfAbsent(e.i2, i -> new HashMap()).computeIfAbsent(e.i3, i -> new HashMap()).put(e.i4, c);
                        continue;
                    }
                    count.incrementAndGet();
                }
            }
            if (count.get() > 0) {
                StatusHider.LOGGER.warn("[Status Hider] Failed to parse {} IP range entries", (Object)count.get());
            }
            map.replaceAll((i1, m1) -> {
                m1.replaceAll((i2, m2) -> {
                    m2.replaceAll((i3, m3) -> Map.copyOf(m3));
                    return Map.copyOf(m2);
                });
                return Map.copyOf(m1);
            });
        }
        catch (Exception e) {
            StatusHider.LOGGER.error((Object)e);
            throw new IllegalStateException(e);
        }
        this.map = Map.copyOf(map);
    }

    @Nullable
    public Country getCountry(String ip) {
        Entry e = Entry.of(ip, false);
        if (e != null) {
            for (byte b = 0; b >= 0; b = (byte)(b + 1)) {
                Country c;
                Map<Integer, Country> map3;
                Map<Integer, Map<Integer, Country>> map2;
                Entry shifted = e.shift(b);
                Map<Integer, Map<Integer, Map<Integer, Country>>> map1 = this.map.get(shifted.i1);
                if (map1 == null || (map2 = map1.get(shifted.i2)) == null || (map3 = map2.get(shifted.i3)) == null || (c = map3.get(shifted.i4)) == null) continue;
                return c;
            }
        }
        return null;
    }

    public static CountryRangeHandler getInstance() {
        return INSTANCE;
    }

    public record Country(String name, String code) {
    }

    private record Entry(int i1, int i2, int i3, int i4, int size) {
        Entry shift(@Range(from=0L, to=127L) byte b) {
            int[] ints = Entry.shift(this.i1, this.i2, this.i3, this.i4, b);
            return new Entry(ints[0], ints[1], ints[2], ints[3], (this.size + b) % 128);
        }

        static Entry of(String s, boolean range) {
            try {
                String[] split;
                int size = 128;
                if (range) {
                    split = ((String)s).split("/");
                    size = Integer.parseInt(split[1]);
                    s = split[0];
                }
                if ((split = ((String)s).split(":")).length < 3) {
                    s = "::ffff:" + (String)s;
                    split = ((String)s).split(":");
                    size += 96;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                for (String sub : split) {
                    if (((String)s).isEmpty()) {
                        list.add(sub);
                        continue;
                    }
                    String[] subs = sub.split("\\.");
                    if (subs.length == 1) {
                        list.add("x" + sub);
                        continue;
                    }
                    for (String digit : subs) {
                        list.add(digit);
                    }
                }
                int[] ints = new int[]{0, 0, 0, 0};
                int f = -1;
                int i = 0;
                while (i < list.size()) {
                    int x;
                    String sub;
                    sub = (String)list.get(i);
                    if (sub.isEmpty()) {
                        if (i < list.size() - 1 && ((String)list.get(i + 1)).isEmpty()) {
                            list.remove(i + 1);
                        }
                        f = i + 1;
                        x = 0;
                    } else {
                        String parse;
                        x = sub.charAt(0) == 'x' ? ((parse = sub.substring(1)).isEmpty() ? 0 : Integer.parseInt(sub.substring(1), 16)) : Integer.parseInt(sub);
                    }
                    ints[i >>> 1] = ints[i >>> 1] << 16 | x;
                    if (++i >= 8) break;
                    if (f == -1) continue;
                    int n = 8 - list.size();
                    for (int j = 0; j <= n; ++j) {
                        list.add(f, "0");
                    }
                    f = -1;
                }
                ints = Entry.shift(ints[0], ints[1], ints[2], ints[3], (byte)(128 - size));
                return new Entry(ints[0], ints[1], ints[2], ints[3], size);
            }
            catch (Exception e) {
                return null;
            }
        }

        private static int[] shift(int i1, int i2, int i3, int i4, @Range(from=0L, to=127L) byte b) {
            while (b > 31) {
                i4 = i3;
                i3 = i2;
                i2 = i1;
                i1 = 0;
                b = (byte)(b - 32);
            }
            if (b > 0) {
                i4 = (i4 >>> b) + (i3 << 32 - b);
                i3 = (i3 >>> b) + (i2 << 32 - b);
                i2 = (i2 >>> b) + (i1 << 32 - b);
                i1 >>>= b;
            }
            return new int[]{i1, i2, i3, i4};
        }
    }
}

