/*
 * Decompiled with CFR 0.152.
 */
package com.nerjal.status_hider;

import com.nerjal.status_hider.FileBound;
import com.nerjal.status_hider.StatusHider;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class IpWhitelist
extends FileBound {
    private final Set<String> whitelist;

    private IpWhitelist(Set<String> set, Path path) {
        super(path);
        this.whitelist = new HashSet<String>(set);
    }

    public Collection<String> listPatterns() {
        return this.whitelist.stream().sorted().toList();
    }

    public boolean isWhitelisted(SocketAddress address) {
        String ip = StatusHider.cleanIp(address.toString());
        return this.isWhitelisted(ip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWhitelisted(String address) {
        Set<String> set = this.whitelist;
        synchronized (set) {
            return this.whitelist.stream().anyMatch(address::matches);
        }
    }

    public boolean whitelist(String regex) {
        if (this.whitelist.add(regex)) {
            this.save();
            return true;
        }
        return false;
    }

    public boolean unWhitelist(String regex) {
        if (this.whitelist.remove(regex)) {
            this.save();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        this.fileLock.lock();
        try (FileWriter writer = new FileWriter(this.path.toFile());){
            writer.write("");
            Set<String> set = this.whitelist;
            synchronized (set) {
                int i = this.whitelist.size();
                for (String s : this.whitelist) {
                    writer.append(s);
                    if (--i == 0) continue;
                    writer.append('\n');
                }
            }
            writer.flush();
        }
        catch (IOException iOException) {
        }
        finally {
            this.fileLock.unlock();
        }
    }

    public static IpWhitelist loadOrCreate(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            return IpWhitelist.loadFile(path).or(() -> Optional.of(IpWhitelist.createFile(path))).map(set -> new IpWhitelist((Set<String>)set, path)).get();
        }
        return new IpWhitelist(IpWhitelist.createFile(path), path);
    }

    private static Optional<Set<String>> loadFile(Path path) {
        Optional<Set<String>> optional;
        block9: {
            Stream<String> lines = Files.lines(path);
            try {
                optional = Optional.of(lines.collect(Collectors.toSet()));
                if (lines == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    return Optional.empty();
                }
                catch (IOException e) {
                    StatusHider.LOGGER.error((Object)e);
                    return Optional.empty();
                }
            }
            lines.close();
        }
        return optional;
    }

    private static Set<String> createFile(Path path) {
        try {
            Files.createFile(path, new FileAttribute[0]);
            return new HashSet<String>();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create IP whitelist file " + String.valueOf(path), e);
        }
    }
}

