/*
 * Decompiled with CFR 0.152.
 */
package com.nerjal.status_hider;

import com.nerjal.status_hider.FileBound;
import com.nerjal.status_hider.StatusHider;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class PlayerIpCache
extends FileBound {
    private static final Entry EMPTY = new Entry(null, null, null);
    private final Map<Integer, Entry> cache;
    private final Map<UUID, Entry> uuidMap;
    private final Map<String, Entry> nameMap;

    private PlayerIpCache(Map<Integer, Entry> map, Path path) {
        super(path);
        this.cache = new HashMap<Integer, Entry>(map);
        this.uuidMap = new HashMap<UUID, Entry>();
        this.nameMap = new HashMap<String, Entry>();
        map.forEach((i, e) -> {
            this.uuidMap.putIfAbsent(e.uuid, (Entry)e);
            this.nameMap.putIfAbsent(e.username, (Entry)e);
        });
    }

    public boolean isIpUnknown(int ipHash) {
        return !this.cache.containsKey(ipHash);
    }

    public String getUsernameForIpHash(int ipHash) {
        return this.cache.getOrDefault((Object)Integer.valueOf((int)ipHash), (Entry)PlayerIpCache.EMPTY).username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPlayer(int ipHash, class_3222 player) {
        boolean b;
        Map<Integer, Entry> map = this.cache;
        synchronized (map) {
            b = this.cache.containsKey(ipHash);
            if (!b) {
                UUID uuid = player.method_5667();
                if (!this.uuidMap.containsKey(uuid)) {
                    Entry e = new Entry(player.method_5477().getString(), uuid, new int[]{ipHash});
                    this.cache.put(ipHash, e);
                    this.uuidMap.put(uuid, e);
                    this.nameMap.put(e.username, e);
                } else {
                    Entry e = this.uuidMap.get(uuid);
                    if (!StatusHider.arrayContains(e.ipHashes, ipHash)) {
                        int[] arr = Arrays.copyOf(e.ipHashes, e.ipHashes.length + 1);
                        arr[e.ipHashes.length] = ipHash;
                        Entry e2 = new Entry(e.username, uuid, arr);
                        this.cache.put(ipHash, e2);
                        this.uuidMap.put(uuid, e2);
                        this.nameMap.put(e.username, e2);
                        for (int i : e.ipHashes) {
                            if (e != this.cache.get(i)) continue;
                            this.cache.put(i, e2);
                        }
                    } else {
                        this.uuidMap.put(uuid, e);
                        b = true;
                    }
                }
            }
        }
        if (!b) {
            this.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerVirtual(int ipHash, String name) {
        int r;
        boolean b;
        Map<Integer, Entry> map = this.cache;
        synchronized (map) {
            b = this.cache.containsKey(ipHash);
            boolean b2 = this.nameMap.containsKey(name);
            if (!b && !b2) {
                UUID uuid;
                while (this.uuidMap.containsKey(uuid = UUID.randomUUID())) {
                }
                Entry e = new Entry(name, uuid, new int[]{ipHash});
                this.cache.put(ipHash, e);
                this.uuidMap.put(uuid, e);
                this.nameMap.put(name, e);
                r = 2;
            } else if (b2) {
                Entry e = this.nameMap.get(name);
                int[] array = Arrays.copyOf(e.ipHashes, e.ipHashes.length + 1);
                array[e.ipHashes.length] = ipHash;
                Entry e2 = new Entry(e.username, e.uuid, array);
                for (int i : array) {
                    this.cache.put(i, e2);
                }
                this.uuidMap.put(e2.uuid, e2);
                this.nameMap.put(e2.username, e2);
                r = 1;
            } else {
                r = 0;
            }
        }
        if (!b) {
            this.save();
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int forgetPlayerOrIp(String s, @Nullable class_3222 player) {
        boolean b = false;
        int r = 0;
        if (player == null) {
            int ip = StatusHider.cleanIp(s).hashCode();
            Map<Integer, Entry> map = this.cache;
            synchronized (map) {
                Entry entry = this.cache.remove(ip);
                if (entry != null) {
                    ++r;
                    b = true;
                    for (int i : entry.ipHashes) {
                        this.cache.remove(i);
                    }
                    this.uuidMap.remove(entry.uuid);
                    this.nameMap.remove(entry.username);
                }
                if ((entry = this.nameMap.remove(s)) != null) {
                    ++r;
                    b = true;
                    for (int i : entry.ipHashes) {
                        this.cache.remove(i);
                    }
                    this.uuidMap.remove(entry.uuid);
                }
            }
        }
        Map<Integer, Entry> map = this.cache;
        synchronized (map) {
            Entry entry = this.uuidMap.remove(player.method_5667());
            if (entry != null) {
                ++r;
                b = true;
                for (int i : entry.ipHashes) {
                    this.cache.remove(i);
                }
                this.nameMap.remove(entry.username);
            }
        }
        if (b) {
            this.save();
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        this.fileLock.lock();
        try (FileWriter writer = new FileWriter(this.path.toFile());){
            HashSet<Entry> set;
            writer.write("");
            Map<Integer, Entry> map = this.cache;
            synchronized (map) {
                set = new HashSet<Entry>(this.cache.values());
            }
            int i = set.size();
            for (Entry e : set) {
                writer.append(e.username).append(';').append(e.uuid.toString()).append(';').append(String.join((CharSequence)",", (CharSequence[])Arrays.stream(e.ipHashes).mapToObj(String::valueOf).toArray(String[]::new)));
                if (--i == 0) continue;
                writer.append('\n');
            }
            writer.flush();
        }
        catch (IOException iOException) {
        }
        finally {
            this.fileLock.unlock();
        }
    }

    public static PlayerIpCache loadOrCreate(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            return PlayerIpCache.loadFile(path).or(() -> Optional.of(PlayerIpCache.createFile(path))).map(map -> new PlayerIpCache((Map<Integer, Entry>)map, path)).get();
        }
        return new PlayerIpCache(PlayerIpCache.createFile(path), path);
    }

    private static Optional<Map<Integer, Entry>> loadFile(Path path) {
        Optional<Map<Integer, Entry>> optional;
        block9: {
            Stream<String> lines = Files.lines(path);
            try {
                HashMap map = new HashMap();
                AtomicInteger lineCount = new AtomicInteger();
                lines.forEach(line -> {
                    UUID uuid;
                    int i = line.indexOf(59);
                    if (i < 0 || i >= line.length() - 23) {
                        StatusHider.LOGGER.warn("Unable to parse IP cache line {}: missing or invalid ';' position.\n{}", (Object)lineCount.getAndIncrement(), line);
                        return;
                    }
                    String username = line.substring(0, i);
                    String sub = line.substring(i + 1);
                    if ((i = sub.indexOf(59)) < 0 || i >= line.length() - 19) {
                        StatusHider.LOGGER.warn("Unable to parse IP cache line {}: missing or invalid second ';' position.\n{}", (Object)lineCount.getAndIncrement(), line);
                        return;
                    }
                    String uuidStr = sub.substring(0, i);
                    try {
                        uuid = UUID.fromString(uuidStr);
                    }
                    catch (IllegalArgumentException e) {
                        StatusHider.LOGGER.warn("Unable to parse IP cache line {}: non-conform UUID format {}.\n{}", (Object)lineCount.getAndIncrement(), (Object)uuidStr, line, (Object)e);
                        return;
                    }
                    sub = sub.substring(i + 1);
                    String[] hashesStr = sub.split(",");
                    Set hashesSet = Arrays.stream(hashesStr).map(s -> {
                        try {
                            return Integer.parseInt(s);
                        }
                        catch (NumberFormatException e) {
                            StatusHider.LOGGER.warn("Error parsing IP cache line {}: couldn't parse IP hash from {}.\n{}", (Object)lineCount.get(), s, line);
                            return null;
                        }
                    }).collect(Collectors.toSet());
                    if (hashesSet.isEmpty()) {
                        StatusHider.LOGGER.warn("Ignoring IP cache line {}: empty or none parsable IP hashes.\n{}", (Object)lineCount.getAndIncrement(), line);
                        return;
                    }
                    int[] array = new int[hashesSet.size()];
                    i = 0;
                    Iterator iterator = hashesSet.iterator();
                    while (iterator.hasNext()) {
                        int j = (Integer)iterator.next();
                        array[i++] = j;
                    }
                    Entry e = new Entry(username, uuid, array);
                    for (int j : array) {
                        map.putIfAbsent(j, e);
                    }
                    lineCount.incrementAndGet();
                });
                optional = Optional.of(map);
                if (lines == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    return Optional.empty();
                }
                catch (IOException e) {
                    StatusHider.LOGGER.error((Object)e);
                    return Optional.empty();
                }
            }
            lines.close();
        }
        return optional;
    }

    private static Map<Integer, Entry> createFile(Path path) {
        try {
            Files.createFile(path, new FileAttribute[0]);
            return new HashMap<Integer, Entry>();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create IP cache file " + String.valueOf(path), e);
        }
    }

    record Entry(String username, UUID uuid, int[] ipHashes) {
    }
}

