/*
 * Decompiled with CFR 0.152.
 */
package com.nerjal.status_hider;

import com.nerjal.status_hider.FileBound;
import com.nerjal.status_hider.StatusHider;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.minecraft.class_2535;
import org.jetbrains.annotations.NotNull;

public class RequestMetrics
extends FileBound {
    private final Map<Integer, Entry> metrics;

    private RequestMetrics(Map<Integer, Entry> map, Path path) {
        super(path);
        this.metrics = new HashMap<Integer, Entry>(map);
    }

    public int incrementPingAndGet(class_2535 connection) {
        return this.incrementPingAndGet(connection.method_10755());
    }

    public int incrementPingAndGet(SocketAddress address) {
        return this.incrementPingAndGet(address.toString());
    }

    public int incrementPingAndGet(String address) {
        return this.incrementPingAndGet(StatusHider.getHash(address));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int incrementPingAndGet(int ipHash) {
        int r;
        Map<Integer, Entry> map = this.metrics;
        synchronized (map) {
            r = this.metrics.compute((Integer)Integer.valueOf((int)ipHash), (BiFunction<Integer, Entry, Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$incrementPingAndGet$0(java.lang.Integer com.nerjal.status_hider.RequestMetrics$Entry ), (Ljava/lang/Integer;Lcom/nerjal/status_hider/RequestMetrics$Entry;)Lcom/nerjal/status_hider/RequestMetrics$Entry;)()).pingAttempts;
        }
        this.save();
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int incrementLoginAndGet(int ipHash) {
        int r;
        Map<Integer, Entry> map = this.metrics;
        synchronized (map) {
            r = this.metrics.compute((Integer)Integer.valueOf((int)ipHash), (BiFunction<Integer, Entry, Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$incrementLoginAndGet$1(java.lang.Integer com.nerjal.status_hider.RequestMetrics$Entry ), (Ljava/lang/Integer;Lcom/nerjal/status_hider/RequestMetrics$Entry;)Lcom/nerjal/status_hider/RequestMetrics$Entry;)()).loginAttempts;
        }
        this.save();
        return r;
    }

    public int incrementBannedAndGet(SocketAddress address) {
        return this.incrementBannedAndGet(StatusHider.cleanIp(address.toString()).hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int incrementBannedAndGet(int ipHash) {
        int r;
        Map<Integer, Entry> map = this.metrics;
        synchronized (map) {
            r = this.metrics.compute((Integer)Integer.valueOf((int)ipHash), (BiFunction<Integer, Entry, Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$incrementBannedAndGet$2(java.lang.Integer com.nerjal.status_hider.RequestMetrics$Entry ), (Ljava/lang/Integer;Lcom/nerjal/status_hider/RequestMetrics$Entry;)Lcom/nerjal/status_hider/RequestMetrics$Entry;)()).bannedAttempts;
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int clear(int ipHash) {
        int i = 0;
        Map<Integer, Entry> map = this.metrics;
        synchronized (map) {
            Entry e = this.metrics.remove(ipHash);
            if (e != null) {
                i = 1;
            }
        }
        if (i != 0) {
            this.save();
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        this.fileLock.lock();
        try (FileWriter writer = new FileWriter(this.path.toFile());){
            HashSet<Entry> set;
            writer.write("");
            Map<Integer, Entry> map = this.metrics;
            synchronized (map) {
                set = new HashSet<Entry>(this.metrics.values());
            }
            int i = set.size();
            for (Entry e : set) {
                writer.append(String.valueOf(e.ipHash)).append(';').append(String.valueOf(e.pingAttempts)).append(';').append(String.valueOf(e.loginAttempts)).append(';').append(String.valueOf(e.bannedAttempts));
                if (--i == 0) continue;
                writer.append('\n');
            }
            writer.flush();
        }
        catch (IOException iOException) {
        }
        finally {
            this.fileLock.unlock();
        }
    }

    public static RequestMetrics loadOrCreate(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            return RequestMetrics.loadFile(path).or(() -> Optional.of(RequestMetrics.createFile(path))).map(map -> new RequestMetrics((Map<Integer, Entry>)map, path)).get();
        }
        return new RequestMetrics(RequestMetrics.createFile(path), path);
    }

    private static Optional<Map<Integer, Entry>> loadFile(Path path) {
        Optional<Map<Integer, Entry>> optional;
        block9: {
            Stream<String> lines = Files.lines(path);
            try {
                HashMap map = new HashMap();
                AtomicInteger lineCount = new AtomicInteger();
                lines.forEach(line -> {
                    int banned;
                    int login;
                    int ping;
                    int ipHash;
                    int i = line.indexOf(59);
                    if (i < 0 || i >= line.length() - 5) {
                        StatusHider.LOGGER.warn("Unable to parse Request Metrics line {}: missing or invalid ';' position.\n{}", (Object)lineCount.getAndIncrement(), line);
                        return;
                    }
                    String current = line.substring(0, i);
                    try {
                        ipHash = Integer.parseInt(current);
                    }
                    catch (NumberFormatException e) {
                        StatusHider.LOGGER.warn("Unable to parse Request Metrics line {}: couldn't parse IP hash from {}.\n{}", (Object)lineCount.getAndIncrement(), (Object)current, line);
                        return;
                    }
                    String sub = line.substring(i + 1);
                    i = sub.indexOf(59);
                    if (i < 0 || i >= line.length() - 3) {
                        StatusHider.LOGGER.warn("Unable to parse Request Metrics line {}: missing or invalid ':' position.\n{}", (Object)lineCount.getAndIncrement(), line);
                        return;
                    }
                    current = sub.substring(0, i);
                    try {
                        ping = Integer.parseInt(current);
                    }
                    catch (NumberFormatException e) {
                        StatusHider.LOGGER.warn("Unable to parse Request Metrics line {}: couldn't parse ping attempts from {}.\n{}", (Object)lineCount.getAndIncrement(), (Object)current, line);
                        return;
                    }
                    sub = sub.substring(i + 1);
                    i = sub.indexOf(59);
                    if (i < 0 || i >= line.length() - 1) {
                        StatusHider.LOGGER.warn("Unable to parse Request Metrics line {}: missing or invalid ':' position.\n{}", (Object)lineCount.getAndIncrement(), line);
                        return;
                    }
                    current = sub.substring(0, i);
                    try {
                        login = Integer.parseInt(current);
                    }
                    catch (NumberFormatException e) {
                        StatusHider.LOGGER.warn("Unable to parse Request Metrics line {}: couldn't parse login attempts from {}.\n{}", (Object)lineCount.getAndIncrement(), (Object)current, line);
                        return;
                    }
                    sub = sub.substring(i + 1);
                    try {
                        banned = Integer.parseInt(sub);
                    }
                    catch (NumberFormatException e) {
                        StatusHider.LOGGER.warn("Unable to parse Request Metrics line {}: couldn't parse banned attempts from {}.\n{}", (Object)lineCount.getAndIncrement(), (Object)current, line);
                        return;
                    }
                    Entry e = new Entry(ipHash, ping, login, banned);
                    if (map.containsKey(ipHash)) {
                        StatusHider.LOGGER.warn("Duplicate Request Metrics entries for IP hash {} at line {}: {} and {}. Keeping the former.\n{}", (Object)ipHash, (Object)lineCount.getAndIncrement(), map.get(ipHash), (Object)e, line);
                    } else {
                        lineCount.getAndIncrement();
                        map.put(ipHash, e);
                    }
                });
                optional = Optional.of(map);
                if (lines == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    return Optional.empty();
                }
                catch (IOException e) {
                    StatusHider.LOGGER.error((Object)e);
                    return Optional.empty();
                }
            }
            lines.close();
        }
        return optional;
    }

    private static Map<Integer, Entry> createFile(Path path) {
        try {
            Files.createFile(path, new FileAttribute[0]);
            return new HashMap<Integer, Entry>();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create request metrics file " + String.valueOf(path), e);
        }
    }

    private static /* synthetic */ Entry lambda$incrementBannedAndGet$2(Integer i, Entry e) {
        if (e == null) {
            return new Entry(i, 0, 0, 1);
        }
        return new Entry(i, e.pingAttempts, e.loginAttempts, e.bannedAttempts + 1);
    }

    private static /* synthetic */ Entry lambda$incrementLoginAndGet$1(Integer i, Entry e) {
        if (e == null) {
            return new Entry(i, 0, 1, 0);
        }
        return new Entry(i, e.pingAttempts, e.loginAttempts + 1, e.bannedAttempts);
    }

    private static /* synthetic */ Entry lambda$incrementPingAndGet$0(Integer i, Entry e) {
        if (e == null) {
            return new Entry(i, 1, 0, 0);
        }
        return new Entry(i, e.pingAttempts + 1, e.loginAttempts, e.bannedAttempts);
    }

    record Entry(int ipHash, int pingAttempts, int loginAttempts, int bannedAttempts) {
        @Override
        @NotNull
        public String toString() {
            return "{ipHash=" + this.ipHash + ", pingAttempts=" + this.pingAttempts + ", loginAttempts=" + this.loginAttempts + ", bannedAttempts=" + this.bannedAttempts + "}";
        }
    }
}

