/*
 * Decompiled with CFR 0.152.
 */
package com.nerjal.status_hider;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.nerjal.status_hider.Cmd;
import com.nerjal.status_hider.CountryRangeHandler;
import com.nerjal.status_hider.IpCacheHolder;
import com.nerjal.status_hider.PlayerIpCache;
import com.nerjal.status_hider.RequestMetrics;
import com.nerjal.status_hider.StatusHider;
import java.time.LocalDateTime;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class StatusCommand {
    private static final String[] RELOADABLES = new String[]{"cache", "metrics", "whitelist", "limit_list"};
    private static final Cmd[] RELOADERS = new Cmd[]{StatusCommand::reloadCache, StatusCommand::reloadMetrics, StatusCommand::reloadWhitelist, StatusCommand::reloadLimitList};

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder reload = (LiteralArgumentBuilder)class_2170.method_9247((String)"reload").executes(StatusCommand::reloadAll);
        for (int i = 0; i < RELOADABLES.length; ++i) {
            reload.then(class_2170.method_9247((String)RELOADABLES[i]).executes((Command)RELOADERS[i]));
        }
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"status_hider").requires(src -> src.method_9259(4))).then(class_2170.method_9247((String)"forget").then(class_2170.method_9244((String)"profileOrIP", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> class_2172.method_9265((Iterable)((class_2168)ctx.getSource()).method_9262(), (SuggestionsBuilder)builder)).executes(StatusCommand::forget)))).then(class_2170.method_9247((String)"clearMetrics").then(class_2170.method_9244((String)"ip", (ArgumentType)StringArgumentType.string()).executes(StatusCommand::clearMetrics)))).then(class_2170.method_9247((String)"registerIP").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"ip", (ArgumentType)StringArgumentType.string()).executes(StatusCommand::register)).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(StatusCommand::register))))).then((ArgumentBuilder)reload)).then(class_2170.method_9247((String)"whitelist").then(class_2170.method_9244((String)"pattern", (ArgumentType)StringArgumentType.string()).executes(StatusCommand::whitelist)))).then(class_2170.method_9247((String)"unwhitelist").then(class_2170.method_9244((String)"pattern", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> class_2172.method_9265(((IpCacheHolder)((class_2168)ctx.getSource()).method_9211()).getIpWhitelist().listPatterns(), (SuggestionsBuilder)builder)).executes(StatusCommand::unWhitelist)))).then(class_2170.method_9247((String)"test").then(class_2170.method_9244((String)"ip", (ArgumentType)StringArgumentType.string()).executes(StatusCommand::test))));
    }

    private static int forget(CommandContext<class_2168> context) {
        class_3222 player;
        String s = StringArgumentType.getString(context, (String)"profileOrIP");
        PlayerIpCache cache = ((IpCacheHolder)((class_2168)context.getSource()).method_9211()).getPlayerIpCache();
        int i = cache.forgetPlayerOrIp(s, player = ((class_2168)context.getSource()).method_9211().method_3760().method_14566(s));
        if (i > 0) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_48322((String)"status_hider.command.forget.success", (String)"Forgot %s entries for player or IP %s", (Object[])new Object[]{i, s}), true);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_48322((String)"status_hider.command.forget.fail", (String)"No matching entry for player or IP %s", (Object[])new Object[]{s}), false);
        }
        return i;
    }

    private static int clearMetrics(CommandContext<class_2168> context) {
        String s = StatusHider.cleanIp(StringArgumentType.getString(context, (String)"ip"));
        RequestMetrics metrics = ((IpCacheHolder)((class_2168)context.getSource()).method_9211()).getRequestMetrics();
        int i = metrics.clear(s.hashCode());
        if (i > 0) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_48322((String)"status_hider.command.clear_metrics.success", (String)"Cleared metrics for IP %s", (Object[])new Object[]{s}), true);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_48322((String)"status_hider.command.clear_metrics.fail", (String)"No metrics entry for IP %s", (Object[])new Object[]{s}), false);
        }
        return i;
    }

    private static int register(CommandContext<class_2168> context) {
        String s;
        String ip = StringArgumentType.getString(context, (String)"ip");
        try {
            s = StringArgumentType.getString(context, (String)"name");
        }
        catch (IllegalArgumentException e) {
            LocalDateTime now = LocalDateTime.now();
            s = String.format("auto_generated_%d-%d-%d_%d-%d", now.getYear(), now.getMonthValue(), now.getDayOfMonth(), now.getHour(), now.getSecond());
        }
        String name = s;
        PlayerIpCache cache = ((IpCacheHolder)((class_2168)context.getSource()).method_9211()).getPlayerIpCache();
        int ipHash = StatusHider.cleanIp(ip).hashCode();
        int i = cache.registerVirtual(ipHash, name);
        if (i == 2) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_48322((String)"status_hider.command.register.new", (String)"New virtual IP cache entry created under the name %s", (Object[])new Object[]{name}), true);
        } else if (i == 1) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_48322((String)"status_hider.command.register.add", (String)"IP %s added to the cache entry %s", (Object[])new Object[]{ip, name}), true);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_48322((String)"status_hider.command.register.fail", (String)"Unable to cache IP %s as it is already registered", (Object[])new Object[]{ip}), false);
        }
        return i;
    }

    private static void reload(final CommandContext<class_2168> context, final boolean cache, final boolean metrics, final boolean whitelist, final boolean limitList) {
        final IpCacheHolder holder = (IpCacheHolder)((class_2168)context.getSource()).method_9211();
        int i = (cache ? 1 : 0) + (metrics ? 1 : 0) + (whitelist ? 1 : 0) + (limitList ? 1 : 0);
        if (i == 0) {
            return;
        }
        ((class_2168)context.getSource()).method_9226(() -> {
            boolean[] b = new boolean[]{cache, metrics, whitelist, limitList};
            class_5250[] texts = new class_5250[i];
            int j = 0;
            for (int k = 0; k < i; ++k) {
                while (!b[j]) {
                    ++j;
                }
                String ls = RELOADABLES[j++];
                texts[k] = class_2561.method_48321((String)("status_hider.command.reload." + ls), (String)ls);
            }
            class_5250 t = class_2561.method_43473();
            for (int k = i; k > 0; --k) {
                t = i == 1 || k == i ? texts[k - 1] : (k == 1 ? class_2561.method_48322((String)"status_hider.command.reload.and", (String)"%s and %s", (Object[])new Object[]{t, texts[k - 1]}) : class_2561.method_48322((String)"status_hider.command.reload.acc", (String)"%s, %s", (Object[])new Object[]{t, texts[k - 1]}));
            }
            return class_2561.method_48322((String)"status_hider.command.reload", (String)"Reloading Status Hider %s...", (Object[])new Object[]{t});
        }, true);
        new Thread(){

            @Override
            public void run() {
                if (cache) {
                    holder.reloadPlayerIpCache();
                }
                if (metrics) {
                    holder.reloadRequestMetrics();
                }
                if (whitelist) {
                    holder.reloadIpWhitelist();
                }
                if (limitList) {
                    holder.reloadIpLimitList();
                }
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_48321((String)"status_hider.command.reload.finished", (String)"Status Hider reloading done!"), true);
            }
        }.start();
    }

    private static int reloadAll(CommandContext<class_2168> context) {
        StatusCommand.reload(context, true, true, true, true);
        return 0;
    }

    private static int reloadCache(CommandContext<class_2168> context) {
        StatusCommand.reload(context, true, false, false, false);
        return 0;
    }

    private static int reloadMetrics(CommandContext<class_2168> context) {
        StatusCommand.reload(context, false, true, false, false);
        return 0;
    }

    private static int reloadWhitelist(CommandContext<class_2168> context) {
        StatusCommand.reload(context, false, false, true, false);
        return 0;
    }

    private static int reloadLimitList(CommandContext<class_2168> context) {
        StatusCommand.reload(context, false, false, false, true);
        return 0;
    }

    private static int whitelist(CommandContext<class_2168> context) {
        String pattern = StringArgumentType.getString(context, (String)"pattern");
        if (((IpCacheHolder)((class_2168)context.getSource()).method_9211()).getIpWhitelist().whitelist(pattern)) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_48322((String)"status_hider.command.whitelist.add.success", (String)"Added pattern '%s' to the IP whitelist", (Object[])new Object[]{pattern}), true);
            return 1;
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_48322((String)"status_hider.command.whitelist.add.fail", (String)"Pattern '%s' already in the IP whitelist", (Object[])new Object[]{pattern}), false);
        return 0;
    }

    private static int unWhitelist(CommandContext<class_2168> context) {
        String pattern = StringArgumentType.getString(context, (String)"pattern");
        if (((IpCacheHolder)((class_2168)context.getSource()).method_9211()).getIpWhitelist().unWhitelist(pattern)) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_48322((String)"status_hider.command.whitelist.remove.success", (String)"Removed pattern '%s' from the IP whitelist", (Object[])new Object[]{pattern}), true);
            return 1;
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_48322((String)"status_hider.command.whitelist.remove.fail", (String)"Pattern '%s' is not in the IP whitelist", (Object[])new Object[]{pattern}), false);
        return 0;
    }

    private static int allowIp(CommandContext<class_2168> context) {
        String pattern = StringArgumentType.getString(context, (String)"pattern");
        if (((IpCacheHolder)((class_2168)context.getSource()).method_9211()).getIpLimitList().whitelist(pattern)) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_48322((String)"status_hider.command.limitlist.add.success", (String)"Added pattern '%s' to the allowed IP list", (Object[])new Object[]{pattern}), true);
            return 1;
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_48322((String)"status_hider.command.limitlist.add.fail", (String)"Pattern '%s' already in the allowed IP list", (Object[])new Object[]{pattern}), false);
        return 0;
    }

    private static int disallowIp(CommandContext<class_2168> context) {
        String pattern = StringArgumentType.getString(context, (String)"pattern");
        if (((IpCacheHolder)((class_2168)context.getSource()).method_9211()).getIpLimitList().unWhitelist(pattern)) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_48322((String)"status_hider.command.limitlist.remove.success", (String)"Removed pattern '%s' from the allowed IP list", (Object[])new Object[]{pattern}), true);
            return 1;
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_48322((String)"status_hider.command.limitlist.remove.fail", (String)"Pattern '%s' is not in the allowed IP list", (Object[])new Object[]{pattern}), false);
        return 0;
    }

    private static int test(CommandContext<class_2168> context) {
        String ip = StringArgumentType.getString(context, (String)"ip");
        String clean = StatusHider.cleanIp(ip);
        int hash = clean.hashCode();
        CountryRangeHandler.Country country = CountryRangeHandler.getInstance().getCountry(clean);
        String cName = country == null ? "unknown" : country.name();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("[%s] (%S) > %d (from %s)", ip, clean, hash, cName)), false);
        return 0;
    }
}

