/*
 * Decompiled with CFR 0.152.
 */
package com.nerjal.status_hider;

import com.nerjal.status_hider.CountryRangeHandler;
import com.nerjal.status_hider.IpCacheHolder;
import com.nerjal.status_hider.PingDataRestriction;
import java.net.SocketAddress;
import java.util.Arrays;
import mc.recraftors.unruled_api.UnruledApi;
import mc.recraftors.unruled_api.impl.BoundedIntRuleValidatorAdapter;
import mc.recraftors.unruled_api.impl.GameruleValidatorAdapter;
import mc.recraftors.unruled_api.rules.EnumRule;
import net.minecraft.class_1928;
import net.minecraft.class_2535;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StatusHider {
    public static final String MOD_ID = "status_hider";
    public static final Logger LOGGER = LogManager.getLogger((String)"Status Hider");
    public static final class_1928.class_5198 CATEGORY = class_1928.class_5198.valueOf((String)"SERVER");
    public static final class_1928.class_4313<EnumRule<PingDataRestriction>> REDUCE_PING_DATA = UnruledApi.enumRuleBuilder(PingDataRestriction.class, (Enum)PingDataRestriction.UNKNOWN_OR_BANNED_IP).setServerBound(true).register("status_hider:reduced_ping_data", CATEGORY);
    public static final class_1928.class_4313<class_1928.class_4310> RESTRICT_PING = UnruledApi.registerBoolean((String)"status_hider:restrict_ping", (class_1928.class_5198)CATEGORY, (boolean)true, (boolean)true);
    public static final class_1928.class_4313<class_1928.class_4310> ENABLE_FANCY_MOTD = UnruledApi.registerBoolean((String)"status_hider:enable_fancy_motd", (class_1928.class_5198)CATEGORY, (boolean)true, (boolean)true);
    public static final class_1928.class_4313<class_1928.class_4310> ENFORCE_IP_BAN = UnruledApi.registerBoolean((String)"status_hider:enforce_ip_ban", (class_1928.class_5198)CATEGORY, (boolean)true, (boolean)true);
    public static final class_1928.class_4313<class_1928.class_4312> AUTO_BAN_IP = UnruledApi.intRuleBuilder((int)10).setValidatorAdapter((GameruleValidatorAdapter)new BoundedIntRuleValidatorAdapter(0, 100)).setServerBound(true).register("status_hider:auto_ban_unknown_ip_after_requests", CATEGORY);
    public static final class_1928.class_4313<class_1928.class_4312> LOG_BANNED_MOD = UnruledApi.intRuleBuilder((int)10).setValidatorAdapter((GameruleValidatorAdapter)new BoundedIntRuleValidatorAdapter(0, 100)).setServerBound(true).register("status_hider:log_banned_ip_requests", CATEGORY);
    public static final class_1928.class_4313<class_1928.class_4310> LOG_RESTRICTED_PING = UnruledApi.registerBoolean((String)"status_hider:log_restricted_requests", (class_1928.class_5198)CATEGORY, (boolean)true, (boolean)true);
    public static final class_1928.class_4313<class_1928.class_4310> LIMIT_ALLOWED_IP = UnruledApi.registerBoolean((String)"status_hider:limit_allowed_ip", (class_1928.class_5198)CATEGORY, (boolean)false, (boolean)true);

    public static void bootstrap() {
    }

    public static String cleanIp(String address) {
        String[] split;
        if (address == null || address.isBlank()) {
            throw new UnsupportedOperationException();
        }
        int i = address.indexOf(47);
        String s = address;
        while (i == 0) {
            s = s.substring(1);
            i = s.indexOf(47);
        }
        if (i > 0) {
            s = s.substring(0, i);
        }
        if ((split = s.split(":")).length < 3) {
            return split[0];
        }
        return String.join((CharSequence)":", Arrays.copyOf(split, split.length - 1));
    }

    public static boolean arrayContains(int[] array, int value) {
        for (int i : array) {
            if (i != value) continue;
            return true;
        }
        return false;
    }

    public static String fancyMotd(MinecraftServer server, IpCacheHolder holder, String ip) {
        CountryRangeHandler.Country country;
        String s = server.method_3818();
        if (s == null || !server.method_3767().method_8355(ENABLE_FANCY_MOTD)) {
            return s;
        }
        String name = holder.getPlayerIpCache().getUsernameForIpHash(ip.hashCode());
        if (name != null) {
            s = s.replace("{username}", name);
        }
        s = s.replace("{country}", (country = CountryRangeHandler.getInstance().getCountry(ip)) == null ? "unknown" : country.name());
        return s;
    }

    public static String getRemoteAddress(class_2535 connection) {
        return StatusHider.getRemoteAddress(connection.method_10755());
    }

    public static String getRemoteAddress(SocketAddress address) {
        return StatusHider.cleanIp(address.toString());
    }

    public static int getHash(class_2535 connection) {
        return StatusHider.getHash(connection.method_10755());
    }

    public static int getHash(SocketAddress address) {
        return StatusHider.getRemoteAddress(address).hashCode();
    }

    public static int getHash(String remoteAddress) {
        return StatusHider.cleanIp(remoteAddress).hashCode();
    }

    public static boolean isLocal(class_2535 connection) {
        return StatusHider.isLocal(connection.method_10755()) || connection.method_10756();
    }

    public static boolean isLocal(SocketAddress address) {
        return StatusHider.isLocal(address.toString());
    }

    public static boolean isLocal(String s) {
        return "local".equals(s);
    }

    public static boolean isUnknown(IpCacheHolder holder, class_2535 connection) {
        return StatusHider.isUnknown(holder, connection.method_10755());
    }

    public static boolean isUnknown(IpCacheHolder holder, SocketAddress address) {
        return StatusHider.isUnknown(holder, StatusHider.cleanIp(address.toString()));
    }

    public static boolean isUnknown(IpCacheHolder holder, String address) {
        if (StatusHider.isLocal(address)) {
            return false;
        }
        return !holder.getIpWhitelist().isWhitelisted(address) && holder.getPlayerIpCache().isIpUnknown(address.hashCode());
    }
}

