/*
 * Decompiled with CFR 0.152.
 */
package com.nerjal.status_hider.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.nerjal.status_hider.CountryRangeHandler;
import com.nerjal.status_hider.IpCacheHolder;
import com.nerjal.status_hider.PingDataRestriction;
import com.nerjal.status_hider.StatusHider;
import com.nerjal.status_hider.mixin.ServerQueryNetworkHandlerAccessor;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import mc.recraftors.unruled_api.UnruledApi;
import net.minecraft.class_11560;
import net.minecraft.class_1928;
import net.minecraft.class_2535;
import net.minecraft.class_2547;
import net.minecraft.class_2561;
import net.minecraft.class_2889;
import net.minecraft.class_2926;
import net.minecraft.class_3246;
import net.minecraft.class_3251;
import net.minecraft.class_3320;
import net.minecraft.class_9127;
import net.minecraft.class_9812;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3246.class})
public abstract class ServerHandshakeNetworkHandlerMixin {
    @Shadow
    @Final
    private MinecraftServer field_14154;
    @Shadow
    @Final
    private class_2535 field_14153;

    @WrapOperation(method={"onHandshake"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/ClientConnection;transitionOutbound(Lnet/minecraft/network/state/NetworkState;)V")})
    public void onStatusHandshakeHandler(class_2535 instance, class_9127<?> newState, Operation<Void> original) {
        IpCacheHolder holder = (IpCacheHolder)this.field_14154;
        String log = "";
        boolean b = false;
        if (this.field_14154.method_3767().method_8355(StatusHider.LIMIT_ALLOWED_IP) && !StatusHider.isLocal(instance) && !holder.getIpLimitList().isWhitelisted(this.field_14153.method_10755())) {
            log = "[Status Hider] Force-disconnecting ping request from non-allowed IP {} - {}. [{}]";
            b = true;
        }
        if (StatusHider.isUnknown(holder, instance) && this.field_14154.method_3767().method_8355(StatusHider.RESTRICT_PING)) {
            log = "[Status Hider] Force-disconnecting ping request from unknown IP {} - {}. [{}]";
            b = true;
        }
        if (b) {
            String c;
            int i = holder.getRequestMetrics().incrementPingAndGet(instance);
            String s = StatusHider.getRemoteAddress(instance);
            CountryRangeHandler.Country country = CountryRangeHandler.getInstance().getCountry(s);
            String string = c = country == null ? "unknown" : country.name();
            if (this.field_14154.method_3767().method_8355(StatusHider.LOG_RESTRICTED_PING)) {
                StatusHider.LOGGER.info(log, this.field_14154.method_52344() ? s + " (" + s.hashCode() + ")" : Integer.valueOf(s.hashCode()), (Object)c, (Object)i);
            }
            instance.method_60924(new class_9812((class_2561)class_2561.method_48321((String)"status_hider.force_disconnect", (String)"Force-disconnected by the Server")));
            int j = this.field_14154.method_3767().method_8356(StatusHider.AUTO_BAN_IP);
            this.checkForAutoIpBan(s, i, j, country);
            return;
        }
        original.call(new Object[]{instance, newState});
    }

    @WrapOperation(method={"onHandshake"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/ClientConnection;transitionInbound(Lnet/minecraft/network/state/NetworkState;Lnet/minecraft/network/listener/PacketListener;)V")})
    private <T extends class_2547> void onStatusHandshakeHandler(class_2535 instance, class_9127<T> state, T packetListener, Operation<Void> original) {
        boolean doLimit;
        boolean securedChat;
        class_2926.class_2930 version;
        class_2926.class_2927 players;
        String motd;
        class_2926 data;
        block15: {
            boolean bl;
            block14: {
                String s = StatusHider.cleanIp(instance.method_52909(true));
                IpCacheHolder holder = (IpCacheHolder)this.field_14154;
                if (this.field_14154.method_3767().method_8355(StatusHider.LIMIT_ALLOWED_IP) && !Objects.equals(this.field_14153.method_10755().toString(), "local") && !holder.getIpLimitList().isWhitelisted(this.field_14153.method_10755())) {
                    instance.method_60924(new class_9812((class_2561)class_2561.method_48321((String)"status_hider.force_disconnect", (String)"Force-disconnected by the Server")));
                    return;
                }
                boolean unknown = StatusHider.isUnknown(holder, this.field_14153);
                boolean whitelisted = holder.getIpWhitelist().isWhitelisted(instance.method_10755());
                if (this.field_14154.method_3767().method_8355(StatusHider.RESTRICT_PING) && unknown) {
                    instance.method_60924(new class_9812((class_2561)class_2561.method_48321((String)"status_hider.force_disconnect", (String)"Force-disconnected by the Server")));
                    return;
                }
                data = ((ServerQueryNetworkHandlerAccessor)packetListener).getMetadata();
                motd = this.field_14154.method_3818();
                players = data.comp_1274().orElse(null);
                version = data.comp_1275().orElse(null);
                securedChat = data.comp_1277();
                if (this.field_14154.method_3767().method_8355(StatusHider.ENABLE_FANCY_MOTD)) {
                    motd = StatusHider.fancyMotd(this.field_14154, holder, s);
                }
                if (whitelisted) break block14;
                switch ((PingDataRestriction)UnruledApi.getEnum((class_1928)this.field_14154.method_3767(), StatusHider.REDUCE_PING_DATA)) {
                    case ALL: {
                        break;
                    }
                    case UNKNOWN_IP: {
                        if (unknown) {
                            break;
                        }
                        break block14;
                    }
                    case BANNED_IP: {
                        if (this.field_14154.method_3760().method_14585().method_14527(instance.method_10755())) {
                            break;
                        }
                        break block14;
                    }
                    case UNKNOWN_OR_BANNED_IP: {
                        if (this.field_14154.method_3760().method_14585().method_14527(instance.method_10755()) || unknown) {
                            break;
                        }
                        break block14;
                    }
                    default: {
                        break block14;
                    }
                }
                bl = true;
                break block15;
            }
            bl = doLimit = false;
        }
        if (doLimit) {
            ArrayList<class_11560> obfuscatedList = new ArrayList<class_11560>();
            for (int i = 0; i < 5; ++i) {
                obfuscatedList.add(new class_11560(UUID.randomUUID(), "\u00a74\u00a7kaaaaaaaa"));
            }
            players = new class_2926.class_2927(0, 0, obfuscatedList);
            motd = null;
            version = null;
            securedChat = true;
        }
        data = new class_2926(class_2561.method_30163((String)motd), Optional.ofNullable(players), Optional.ofNullable(version), data.comp_1276(), securedChat);
        original.call(new Object[]{instance, state, new class_3251(data, this.field_14153)});
    }

    @Inject(method={"login"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/ClientConnection;transitionInbound(Lnet/minecraft/network/state/NetworkState;Lnet/minecraft/network/listener/PacketListener;)V")})
    private void onLoginMetrics(class_2889 packet, boolean transfer, CallbackInfo ci) {
        IpCacheHolder holder = (IpCacheHolder)this.field_14154;
        if (holder.getIpWhitelist().isWhitelisted(this.field_14153.method_10755())) {
            return;
        }
        String s = StatusHider.cleanIp(this.field_14153.method_52909(true));
        int hash = s.hashCode();
        if (s.equals("local") || !holder.getPlayerIpCache().isIpUnknown(hash)) {
            return;
        }
        int i = holder.getRequestMetrics().incrementLoginAndGet(s.hashCode());
        int j = this.field_14154.method_3767().method_8356(StatusHider.AUTO_BAN_IP);
        CountryRangeHandler.Country country = CountryRangeHandler.getInstance().getCountry(s);
        this.checkForAutoIpBan(s, i, j, country);
    }

    @Unique
    private void checkForAutoIpBan(String s, int i, int j, CountryRangeHandler.Country country) {
        if (j > 0 && i >= j) {
            class_3320 entry = new class_3320(s, new Date(), "Status Hider", null, "[Status Hider] auto-banned after " + i + " requests");
            String c = country == null ? "unknown" : country.code();
            this.field_14154.method_3760().method_14585().method_73999(entry);
            this.field_14154.method_3739().method_9226(() -> class_2561.method_48322((String)"status_hider.auto_banned_ip", (String)"[Status Hider] auto-banned unknown IP %s from %s after %s requests", (Object[])new Object[]{s, c, i}), true);
        }
    }
}

