package com.nerjal.status_hider;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.time.LocalDateTime;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

import static net.minecraft.class_2170.*;

public class StatusCommand {
    private static final String[] RELOADABLES;
    private static final Cmd[] RELOADERS;

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder<class_2168> reload = method_9247("reload")
                .executes(StatusCommand::reloadAll);
        for (int i = 0; i < RELOADABLES.length; i++) {
            reload.then(method_9247(RELOADABLES[i]).executes(RELOADERS[i]));
        }
        dispatcher.register(method_9247("status_hider")
                .requires(src -> src.method_9259(4))
                .then(method_9247("forget")
                        .then(method_9244("profileOrIP", StringArgumentType.string())
                                .suggests((ctx, builder) ->
                                        class_2172.method_9265(ctx.getSource().method_9262(), builder))
                                .executes(StatusCommand::forget)
                        )
                )
                .then(method_9247("clearMetrics")
                        .then(method_9244("ip", StringArgumentType.string()).executes(StatusCommand::clearMetrics))
                )
                .then(method_9247("registerIP")
                        .then(method_9244("ip", StringArgumentType.string())
                                .executes(StatusCommand::register)
                                .then(method_9244("name", StringArgumentType.string())
                                        .executes(StatusCommand::register)))
                )
                .then(reload)
                .then(method_9247("whitelist")
                        .then(method_9244("pattern", StringArgumentType.string())
                                .executes(StatusCommand::whitelist))
                )
                .then(method_9247("unwhitelist")
                        .then(method_9244("pattern", StringArgumentType.string())
                                .suggests((ctx, builder) ->
                                        class_2172.method_9265(((IpCacheHolder)ctx.getSource().method_9211())
                                                .getIpWhitelist().listPatterns(), builder))
                                .executes(StatusCommand::unWhitelist))
                )
                .then(method_9247("test")
                        .then(method_9244("ip", StringArgumentType.string())
                                .executes(StatusCommand::test))
                )
        );
    }

    private static int forget(CommandContext<class_2168> context) {
        String s = StringArgumentType.getString(context, "profileOrIP");
        PlayerIpCache cache = ((IpCacheHolder) context.getSource().method_9211()).getPlayerIpCache();
        class_3222 player = context.getSource().method_9211().method_3760().method_14566(s);
        int i = cache.forgetPlayerOrIp(s, player);
        if (i > 0) {
            context.getSource().method_9226(() -> class_2561.method_48322(
                    "status_hider.command.forget.success",
                    "Forgot %s entries for player or IP %s",
                    i, s
            ), true);
        } else {
            context.getSource().method_9226(() -> class_2561.method_48322(
                    "status_hider.command.forget.fail",
                    "No matching entry for player or IP %s",
                    s
            ), false);
        }
        return i;
    }

    private static int clearMetrics(CommandContext<class_2168> context) {
        String s = StatusHider.cleanIp(StringArgumentType.getString(context, "ip"));
        RequestMetrics metrics = ((IpCacheHolder) context.getSource().method_9211()).getRequestMetrics();
        int i = metrics.clear(s.hashCode());
        if (i > 0) {
            context.getSource().method_9226(() -> class_2561.method_48322(
                    "status_hider.command.clear_metrics.success",
                    "Cleared metrics for IP %s",
                    s
            ), true);
        } else {
            context.getSource().method_9226(() -> class_2561.method_48322(
                    "status_hider.command.clear_metrics.fail",
                    "No metrics entry for IP %s",
                    s
            ), false);
        }
        return i;
    }

    private static int register(CommandContext<class_2168> context) {
        String ip = StringArgumentType.getString(context, "ip");
        String s;
        try {
            s = StringArgumentType.getString(context, "name");
        } catch (IllegalArgumentException e) {
            LocalDateTime now = LocalDateTime.now();
            s = String.format("auto_generated_%d-%d-%d_%d-%d", now.getYear(), now.getMonthValue(),now.getDayOfMonth(), now.getHour(), now.getSecond());
        }
        String name = s;
        PlayerIpCache cache = ((IpCacheHolder)context.getSource().method_9211()).getPlayerIpCache();
        int ipHash = StatusHider.cleanIp(ip).hashCode();
        int i = cache.registerVirtual(ipHash, name);
        if (i == 2) {
            context.getSource().method_9226(() -> class_2561.method_48322(
                    "status_hider.command.register.new",
                    "New virtual IP cache entry created under the name %s",
                    name
            ), true);
        } else if (i == 1) {
            context.getSource().method_9226(() -> class_2561.method_48322(
                    "status_hider.command.register.add",
                    "IP %s added to the cache entry %s",
                    ip, name
            ), true);
        } else {
            context.getSource().method_9226(() -> class_2561.method_48322(
                    "status_hider.command.register.fail",
                    "Unable to cache IP %s as it is already registered",
                    ip
            ), false);
        }
        return i;
    }

    @SuppressWarnings("StringConcatenationInLoop")
    private static void reload(CommandContext<class_2168> context, boolean cache, boolean metrics, boolean whitelist, boolean limitList) {
        final IpCacheHolder holder = (IpCacheHolder) context.getSource().method_9211();
        int i = (cache ? 1 : 0) + (metrics ? 1 : 0 ) + (whitelist ? 1 : 0) + (limitList ? 1 : 0);
        if (i == 0) return;
        context.getSource().method_9226(() -> {
            boolean[] b = {cache, metrics, whitelist, limitList};
            class_5250[] texts = new class_5250[i];
            int j = 0;
            for (int k = 0; k < i; k++) {
                while (!b[j]) j++;
                String ls = RELOADABLES[j++];
                texts[k] = class_2561.method_48321("status_hider.command.reload." + ls, ls);
            }
            class_5250 t = class_2561.method_43473();
            for (int k = i; k > 0; k--) {
                t = (i == 1 || k == i) ? texts[k-1] : k == 1 ? class_2561.method_48322(
                        "status_hider.command.reload.and", "%s and %s",
                        t, texts[k-1]
                ) : class_2561.method_48322(
                        "status_hider.command.reload.acc", "%s, %s",
                        t, texts[k-1]
                );
            }
            return class_2561.method_48322(
                    "status_hider.command.reload",
                    "Reloading Status Hider %s...",
                    t
            );
        }, true);
        /*context.getSource().sendFeedback(() -> Text.translatableWithFallback(
                "status_hider.command.reload." + (cache ? metrics ? "both" : "cache" : "metrics"),
                "Reloading Status Hider " + (cache ? metrics ? "cache and metrics" : "cache" : "metrics") + "..."
        ), true);*/
        new Thread() {
            @Override
            public void run() {
                if (cache) {
                    holder.reloadPlayerIpCache();
                }
                if (metrics) {
                    holder.reloadRequestMetrics();
                }
                if (whitelist) {
                    holder.reloadIpWhitelist();
                }
                if (limitList) {
                    holder.reloadIpLimitList();
                }
                context.getSource().method_9226(() -> class_2561.method_48321(
                        "status_hider.command.reload.finished",
                        "Status Hider reloading done!"
                ), true);
            }
        }.start();
    }

    private static int reloadAll(CommandContext<class_2168> context) {
        reload(context, true, true, true, true);
        return 0;
    }

    private static int reloadCache(CommandContext<class_2168> context) {
        reload(context, true, false, false, false);
        return 0;
    }

    private static int reloadMetrics(CommandContext<class_2168> context) {
        reload(context, false, true, false, false);
        return 0;
    }

    private static int reloadWhitelist(CommandContext<class_2168> context) {
        reload(context, false, false, true, false);
        return 0;
    }

    private static int reloadLimitList(CommandContext<class_2168> context) {
        reload(context, false, false, false, true);
        return 0;
    }

    private static int whitelist(CommandContext<class_2168> context) {
        String pattern = StringArgumentType.getString(context, "pattern");
        if (((IpCacheHolder)context.getSource().method_9211()).getIpWhitelist()
                .whitelist(pattern)) {
            context.getSource().method_9226(() -> class_2561.method_48322(
                    "status_hider.command.whitelist.add.success",
                    "Added pattern '%s' to the IP whitelist",
                    pattern
            ), true);
            return 1;
        }
        context.getSource().method_9226(() -> class_2561.method_48322(
                "status_hider.command.whitelist.add.fail",
                "Pattern '%s' already in the IP whitelist",
                pattern
        ), false);
        return 0;
    }

    private static int unWhitelist(CommandContext<class_2168> context) {
        String pattern = StringArgumentType.getString(context, "pattern");
        if (((IpCacheHolder)context.getSource().method_9211()).getIpWhitelist()
                .unWhitelist(pattern)) {
            context.getSource().method_9226(() -> class_2561.method_48322(
                    "status_hider.command.whitelist.remove.success",
                    "Removed pattern '%s' from the IP whitelist",
                    pattern
            ), true);
            return 1;
        }
        context.getSource().method_9226(() -> class_2561.method_48322(
                "status_hider.command.whitelist.remove.fail",
                "Pattern '%s' is not in the IP whitelist",
                pattern
        ), false);
        return 0;
    }

    private static int allowIp(CommandContext<class_2168> context) {
        String pattern = StringArgumentType.getString(context, "pattern");
        if (((IpCacheHolder)context.getSource().method_9211()).getIpLimitList()
                .whitelist(pattern)) {
            context.getSource().method_9226(() -> class_2561.method_48322(
                    "status_hider.command.limitlist.add.success",
                    "Added pattern '%s' to the allowed IP list",
                    pattern
            ), true);
            return 1;
        }
        context.getSource().method_9226(() -> class_2561.method_48322(
                "status_hider.command.limitlist.add.fail",
                "Pattern '%s' already in the allowed IP list",
                pattern
        ), false);
        return 0;
    }

    private static int disallowIp(CommandContext<class_2168> context) {
        String pattern = StringArgumentType.getString(context, "pattern");
        if (((IpCacheHolder)context.getSource().method_9211()).getIpLimitList()
                .unWhitelist(pattern)) {
            context.getSource().method_9226(() -> class_2561.method_48322(
                    "status_hider.command.limitlist.remove.success",
                    "Removed pattern '%s' from the allowed IP list",
                    pattern
            ), true);
            return 1;
        }
        context.getSource().method_9226(() -> class_2561.method_48322(
                "status_hider.command.limitlist.remove.fail",
                "Pattern '%s' is not in the allowed IP list",
                pattern
        ), false);
        return 0;
    }

    private static int test(CommandContext<class_2168> context) {
        String ip = StringArgumentType.getString(context, "ip");
        String clean = StatusHider.cleanIp(ip);
        int hash = clean.hashCode();
        CountryRangeHandler.Country country = CountryRangeHandler.getInstance().getCountry(clean);
        String cName = country == null ? "unknown" : country.name();
        context.getSource().method_9226(
                () -> class_2561.method_43470(String.format("[%s] (%S) > %d (from %s)", ip, clean, hash, cName)),
                false);
        return 0;
    }

    static {
        RELOADABLES = new String[]{"cache", "metrics", "whitelist", "limit_list"};
        RELOADERS = new Cmd[]{
                StatusCommand::reloadCache, StatusCommand::reloadMetrics, StatusCommand::reloadWhitelist, StatusCommand::reloadLimitList
        };
    }
}
