package com.nerjal.status_hider;

import mc.recraftors.unruled_api.UnruledApi;
import mc.recraftors.unruled_api.impl.BoundedIntRuleValidatorAdapter;
import mc.recraftors.unruled_api.rules.EnumRule;
import net.minecraft.class_1928;
import net.minecraft.class_2535;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.net.SocketAddress;
import java.util.Arrays;

public class StatusHider {
    public static final String MOD_ID = "status_hider";
    public static final Logger LOGGER = LogManager.getLogger("Status Hider");
    public static final class_1928.class_5198 CATEGORY = class_1928.class_5198.valueOf("SERVER");
    public static final class_1928.class_4313<EnumRule<PingDataRestriction>> REDUCE_PING_DATA = UnruledApi
            .enumRuleBuilder(PingDataRestriction.class, PingDataRestriction.UNKNOWN_OR_BANNED_IP)
            .setServerBound(true)
            .register(MOD_ID+":reduced_ping_data", CATEGORY);
    public static final class_1928.class_4313<class_1928.class_4310> RESTRICT_PING = UnruledApi.registerBoolean(
            MOD_ID+":restrict_ping", CATEGORY, true, true);
    public static final class_1928.class_4313<class_1928.class_4310> ENABLE_FANCY_MOTD = UnruledApi.registerBoolean(
            MOD_ID+":enable_fancy_motd", CATEGORY, true, true);
    public static final class_1928.class_4313<class_1928.class_4310> ENFORCE_IP_BAN = UnruledApi.registerBoolean(
            MOD_ID+":enforce_ip_ban", CATEGORY, true, true);
    public static final class_1928.class_4313<class_1928.class_4312> AUTO_BAN_IP = UnruledApi.intRuleBuilder(10)
            .setValidatorAdapter(new BoundedIntRuleValidatorAdapter(0, 100))
            .setServerBound(true)
            .register(MOD_ID+":auto_ban_unknown_ip_after_requests", CATEGORY);
    public static final class_1928.class_4313<class_1928.class_4312> LOG_BANNED_MOD = UnruledApi.intRuleBuilder(10)
            .setValidatorAdapter(new BoundedIntRuleValidatorAdapter(0, 100))
            .setServerBound(true)
            .register(MOD_ID+":log_banned_ip_requests", CATEGORY);
    public static final class_1928.class_4313<class_1928.class_4310> LOG_RESTRICTED_PING = UnruledApi.registerBoolean(
            MOD_ID+":log_restricted_requests", CATEGORY, true, true);

    public static final class_1928.class_4313<class_1928.class_4310> LIMIT_ALLOWED_IP = UnruledApi.registerBoolean(
            MOD_ID+":limit_allowed_ip", CATEGORY, false, true);

    public static void bootstrap() {}

    public static String cleanIp(String address) {
        if (address == null || address.isBlank()) {
            throw new UnsupportedOperationException();
        }
        int i = address.indexOf('/');
        String s = address;
        while (i == 0) {
            s = s.substring(1);
            i = s.indexOf('/');
        }
        if (i > 0) {
            s = s.substring(0, i);
        }
        String[] split = s.split(":");
        if (split.length < 3) return split[0]; // IPv4
        return String.join(":", Arrays.copyOf(split, split.length-1)); // IPv6
    }

    public static boolean arrayContains(int[] array, int value) {
        for (int i : array) {
            if (i == value) return true;
        }
        return false;
    }

    public static String fancyMotd(MinecraftServer server, IpCacheHolder holder, String ip) {
        String s = server.method_3818();
        if (s == null || !server.method_3767().method_8355(ENABLE_FANCY_MOTD)) return s;
        String name = holder.getPlayerIpCache().getUsernameForIpHash(ip.hashCode());
        if (name != null) {
            s = s.replace("{username}", name);
        }
        CountryRangeHandler.Country country = CountryRangeHandler.getInstance().getCountry(ip);
        s = s.replace("{country}", country == null ? "unknown" : country.name());
        return s;
    }

    public static String getRemoteAddress(class_2535 connection) {
        return getRemoteAddress(connection.method_10755());
    }

    public static String getRemoteAddress(SocketAddress address) {
        return cleanIp(address.toString());
    }

    public static int getHash(class_2535 connection) {
        return getHash(connection.method_10755());
    }

    public static int getHash(SocketAddress address) {
        return getRemoteAddress(address).hashCode();
    }

    public static int getHash(String remoteAddress) {
        return cleanIp(remoteAddress).hashCode();
    }

    public static boolean isLocal(class_2535 connection) {
        return isLocal(connection.method_10755()) || connection.method_10756();
    }

    public static boolean isLocal(SocketAddress address) {
        return isLocal(address.toString());
    }

    public static boolean isLocal(String s) {
        return "local".equals(s);
    }

    public static boolean isUnknown(IpCacheHolder holder, class_2535 connection) {
        return isUnknown(holder, connection.method_10755());
    }

    public static boolean isUnknown(IpCacheHolder holder, SocketAddress address) {
        return isUnknown(holder, cleanIp(address.toString()));
    }

    public static boolean isUnknown(IpCacheHolder holder, String address) {
        if (isLocal(address)) return false;
        return !holder.getIpWhitelist().isWhitelisted(address) &&
                holder.getPlayerIpCache().isIpUnknown(address.hashCode());
    }
}
