package com.nerjal.status_hider.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.authlib.GameProfile;
import com.nerjal.status_hider.CountryRangeHandler;
import com.nerjal.status_hider.IpCacheHolder;
import com.nerjal.status_hider.StatusHider;
import mc.recraftors.unruled_api.UnruledApi;
import net.minecraft.class_2535;
import net.minecraft.class_2547;
import net.minecraft.class_2561;
import net.minecraft.class_2889;
import net.minecraft.class_2926;
import net.minecraft.class_3246;
import net.minecraft.class_3251;
import net.minecraft.class_3320;
import net.minecraft.class_9127;
import net.minecraft.class_9812;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.*;

@Mixin(class_3246.class)
public abstract class ServerHandshakeNetworkHandlerMixin {
    @Shadow @Final private MinecraftServer server;

    @Shadow @Final private class_2535 connection;

    @WrapOperation(method = "onHandshake", at = @At(value = "INVOKE", target = "Lnet/minecraft/network/ClientConnection;transitionOutbound(Lnet/minecraft/network/NetworkState;)V"))
    public void onStatusHandshakeHandler(
            class_2535 instance, class_9127<?> newState, Operation<Void> original
    ) {
        IpCacheHolder holder = (IpCacheHolder) this.server;
        String log = "";
        boolean b = false;
        if (this.server.method_3767().method_8355(StatusHider.LIMIT_ALLOWED_IP) && !StatusHider.isLocal(instance) &&
                !holder.getIpLimitList().isWhitelisted(connection.method_10755())) {
            log = "[Status Hider] Force-disconnecting ping request from non-allowed IP {} - {}. [{}]";
            b = true;
        }
        if (StatusHider.isUnknown(holder, instance) && this.server.method_3767().method_8355(StatusHider.RESTRICT_PING)) {
            log = "[Status Hider] Force-disconnecting ping request from unknown IP {} - {}. [{}]";
            b = true;
        }
        if (b) {
            int i = holder.getRequestMetrics().incrementPingAndGet(instance);
            String s = StatusHider.getRemoteAddress(instance);
            CountryRangeHandler.Country country = CountryRangeHandler.getInstance().getCountry(s);
            String c = country == null ? "unknown" : country.name();
            if (this.server.method_3767().method_8355(StatusHider.LOG_RESTRICTED_PING)) {
                StatusHider.LOGGER.info(log, this.server.method_52344() ? s + " (" + s.hashCode() + ")" : s.hashCode(), c, i);
            }
            instance.method_60924(new class_9812(class_2561.method_48321("status_hider.force_disconnect", "Force-disconnected by the Server")));
            int j = this.server.method_3767().method_8356(StatusHider.AUTO_BAN_IP);
            checkForAutoIpBan(s, i, j, country);
            return;
        }
        original.call(instance, newState);
    }

    @WrapOperation(method = "onHandshake", at = @At(value = "INVOKE", target = "Lnet/minecraft/network/ClientConnection;transitionInbound(Lnet/minecraft/network/NetworkState;Lnet/minecraft/network/listener/PacketListener;)V"))
    private <T extends class_2547> void onStatusHandshakeHandler(
            class_2535 instance, class_9127<T> state, T packetListener, Operation<Void> original
    ) {
        String s = StatusHider.cleanIp(instance.method_52909(true));
        IpCacheHolder holder = (IpCacheHolder) this.server;
        if (this.server.method_3767().method_8355(StatusHider.LIMIT_ALLOWED_IP) && !Objects.equals(connection.method_10755().toString(), "local") && !holder.getIpLimitList().isWhitelisted(connection.method_10755())) {
            instance.method_60924(new class_9812(class_2561.method_48321("status_hider.force_disconnect", "Force-disconnected by the Server")));
            return;
        }
        boolean unknown = StatusHider.isUnknown(holder, connection);
        boolean whitelisted = holder.getIpWhitelist().isWhitelisted(instance.method_10755());
        if (this.server.method_3767().method_8355(StatusHider.RESTRICT_PING) && unknown) {
            instance.method_60924(new class_9812(class_2561.method_48321("status_hider.force_disconnect", "Force-disconnected by the Server")));
            return;
        }
        class_2926 data = ((ServerQueryNetworkHandlerAccessor)packetListener).getMetadata();
        String motd = this.server.method_3818();
        class_2926.class_2927 players = data.comp_1274().orElse(null);
        class_2926.class_2930 version = data.comp_1275().orElse(null);
        boolean securedChat = data.comp_1277();
        if (this.server.method_3767().method_8355(StatusHider.ENABLE_FANCY_MOTD)) {
            motd = StatusHider.fancyMotd(this.server, holder, s);
        }
        boolean doLimit = !whitelisted && switch (UnruledApi.getEnum(this.server.method_3767(), StatusHider.REDUCE_PING_DATA)) {
            case ALL -> true;
            case UNKNOWN_IP -> unknown;
            case BANNED_IP -> this.server.method_3760().method_14585().method_14527(instance.method_10755());
            case UNKNOWN_OR_BANNED_IP -> this.server.method_3760().method_14585().method_14527(instance.method_10755()) || unknown;
            default -> false;
        };
        if (doLimit) {
            List<GameProfile> obfuscatedList = new ArrayList<>();
            for (int i = 0; i < 5; i++) obfuscatedList.add(new GameProfile(UUID.randomUUID(), "§4§kaaaaaaaa"));
            players = new class_2926.class_2927(0, 0, obfuscatedList);
            motd = null;
            version = null;
            securedChat = true;
        }
        data = new class_2926(class_2561.method_30163(motd), Optional.ofNullable(players), Optional.ofNullable(version),
                data.comp_1276(), securedChat);
        original.call(instance, state, new class_3251(data, this.connection));
    }

    @Inject(method = "login", at = @At(value = "INVOKE", target = "Lnet/minecraft/network/ClientConnection;transitionInbound(Lnet/minecraft/network/NetworkState;Lnet/minecraft/network/listener/PacketListener;)V"))
    private void onLoginMetrics(class_2889 packet, boolean transfer, CallbackInfo ci) {
        IpCacheHolder holder = (IpCacheHolder) this.server;
        if (holder.getIpWhitelist().isWhitelisted(this.connection.method_10755())) return;
        String s = StatusHider.cleanIp(this.connection.method_52909(true));
        int hash = s.hashCode();
        if (s.equals("local") || !holder.getPlayerIpCache().isIpUnknown(hash)) return;
        int i = holder.getRequestMetrics().incrementLoginAndGet(s.hashCode());
        int j = this.server.method_3767().method_8356(StatusHider.AUTO_BAN_IP);
        CountryRangeHandler.Country country = CountryRangeHandler.getInstance().getCountry(s);
        checkForAutoIpBan(s, i, j, country);
    }

    @Unique
    private void checkForAutoIpBan(String s, int i, int j, CountryRangeHandler.Country country) {
        if (j > 0 && i >= j) {
            class_3320 entry = new class_3320(s, new Date(), "Status Hider", null,
                    "[Status Hider] auto-banned after " + i + " requests");
            String c = country == null ? "unknown" : country.code();
            this.server.method_3760().method_14585().method_14633(entry);
            this.server.method_3739().method_9226(() -> class_2561.method_48322(
                    "status_hider.auto_banned_ip",
                            "[Status Hider] auto-banned unknown IP %s from %s after %s requests", s, c, i),
                    true);
        }
    }
}
