package com.nerjal.status_hider.mixin;

import com.nerjal.status_hider.CountryRangeHandler;
import com.nerjal.status_hider.IpCacheHolder;
import com.nerjal.status_hider.StatusHider;
import io.netty.channel.Channel;
import net.minecraft.class_3242;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(targets = "net/minecraft/server/ServerNetworkIo$1")
public abstract class ServerNetworkIOChannelInitializerMixin {
    @Shadow @Final class_3242 field_14112;

    @Inject(method = "initChannel",
            at = @At(value = "INVOKE",
                    target = "Lnet/minecraft/network/ClientConnection;addHandlers(Lio/netty/channel/ChannelPipeline;Lnet/minecraft/network/NetworkSide;ZLnet/minecraft/network/handler/PacketSizeLogger;)V",
                    shift = At.Shift.BEFORE
            ),
            cancellable = true
    )
    private void sh_enforceStrictIpBan(Channel channel, CallbackInfo ci) {
        MinecraftServer server = this.field_14112.method_14351();
        IpCacheHolder holder = (IpCacheHolder) server;
        if (server.method_3767().method_8355(StatusHider.LIMIT_ALLOWED_IP) &&
                !StatusHider.isLocal(channel.remoteAddress()) &&
                !holder.getIpLimitList().isWhitelisted(channel.remoteAddress())) {
            holder.getRequestMetrics().incrementBannedAndGet(channel.remoteAddress());
            channel.disconnect();
            ci.cancel();
        }
        if (
                server.method_3767().method_8355(StatusHider.ENFORCE_IP_BAN) &&
                server.method_3760().method_14585().method_14527(channel.remoteAddress()) &&
                !holder.getIpWhitelist().isWhitelisted(channel.remoteAddress())
        ) {
            int i = holder.getRequestMetrics().incrementBannedAndGet(channel.remoteAddress());
            int j = server.method_3767().method_8356(StatusHider.LOG_BANNED_MOD);
            if (j > 0 && i % j == 0) {
                String clean = StatusHider.cleanIp(channel.remoteAddress().toString());
                CountryRangeHandler.Country country = CountryRangeHandler.getInstance().getCountry(clean);
                String c = country == null ? "unknown" : country.name();
                StatusHider.LOGGER.info("[Status Hider] Enforced ban for IP {}. [{}] (from {})",
                        StatusHider.cleanIp(channel.remoteAddress().toString()), i, c);
            }
            channel.disconnect();
            ci.cancel();
        }
    }
}
