/*
 * Decompiled with CFR 0.152.
 */
package com.seristic.lagx.commands;

import com.seristic.lagx.commands.LagXCommand;
import com.seristic.lagx.inf.Help;
import com.seristic.lagx.main.LagX;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;

public class EntitiesCommand
extends LagXCommand {
    public EntitiesCommand(LagX plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        String subCommand;
        if (args.length < 2) {
            Help.sendMsg(sender, "\u00a7cUsage: " + this.getUsage(), true);
            return true;
        }
        switch (subCommand = args[1].toLowerCase()) {
            case "info": 
            case "i": {
                this.showInfo(sender);
                break;
            }
            case "count": 
            case "c": {
                this.showCount(sender);
                break;
            }
            case "stats": 
            case "s": {
                this.showStats(sender);
                break;
            }
            default: {
                Help.sendMsg(sender, "\u00a7cUnknown subcommand. Available options: info, count, stats", true);
            }
        }
        return true;
    }

    private void showInfo(CommandSender sender) {
        if (this.plugin.getEntityLimiter() != null && this.plugin.getEntityLimiter().isEnabled()) {
            Help.sendMsg(sender, "\u00a76Entity Limiter Configuration:", true);
            Help.sendMsg(sender, this.plugin.getEntityLimiter().getStatus(), false);
        } else {
            Help.sendMsg(sender, "\u00a7cEntity Limiter is not enabled on this server.", true);
        }
    }

    private void showCount(CommandSender sender) {
        HashMap<String, Integer> entityCounts = new HashMap<String, Integer>();
        int totalEntities = 0;
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                String type = entity.getType().toString();
                entityCounts.put(type, entityCounts.getOrDefault(type, 0) + 1);
                ++totalEntities;
            }
        }
        Help.sendMsg(sender, "\u00a76Entity Count by Type:", true);
        Help.sendMsg(sender, "\u00a7eTotal Entities: \u00a7b" + totalEntities, false);
        ArrayList sortedEntities = new ArrayList(entityCounts.entrySet());
        sortedEntities.sort(Map.Entry.comparingByValue().reversed());
        int shown = 0;
        for (Map.Entry entry : sortedEntities) {
            if (shown >= 10) break;
            Help.sendMsg(sender, "\u00a7e" + (String)entry.getKey() + ": \u00a7b" + String.valueOf(entry.getValue()), false);
            ++shown;
        }
    }

    private void showStats(CommandSender sender) {
        Help.sendMsg(sender, "\u00a76Entity Statistics by World:", true);
        for (World world : Bukkit.getWorlds()) {
            int entityCount = world.getEntities().size();
            int chunkCount = world.getLoadedChunks().length;
            double avgPerChunk = chunkCount > 0 ? (double)entityCount / (double)chunkCount : 0.0;
            Help.sendMsg(sender, "\u00a7e" + world.getName() + ": \u00a7b" + entityCount + " \u00a7eentities in \u00a7b" + chunkCount + " \u00a7echunks (avg: \u00a7b" + String.format("%.2f", avgPerChunk) + " \u00a7eper chunk)", false);
        }
    }

    @Override
    public String getPermission() {
        return "lagx.entities";
    }

    @Override
    public String getUsage() {
        return "/lagx entities [info|count|stats]";
    }

    @Override
    public String getDescription() {
        return "Entity limiter overview and stats";
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 2) {
            completions.addAll(Arrays.asList("info", "i", "count", "c", "stats", "s"));
        }
        return completions;
    }
}

