/*
 * Decompiled with CFR 0.152.
 */
package com.seristic.lagx.commands;

import com.seristic.lagx.commands.LagXCommand;
import com.seristic.lagx.inf.Help;
import com.seristic.lagx.main.LagX;
import com.seristic.lagx.utils.MapArtManager;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;

public class MapArtCommand
extends LagXCommand {
    public MapArtCommand(LagX plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        String subCommand;
        if (!(sender instanceof Player)) {
            Help.sendMsg(sender, "\u00a7cThis command can only be used by players.", true);
            return true;
        }
        Player player = (Player)sender;
        if (args.length < 2) {
            Help.sendMsg(player, "\u00a7eMap Art Protection Commands:", true);
            Help.sendMsg(player, "\u00a7b/lagx mapart protect \u00a77- Protect held map from changes", true);
            Help.sendMsg(player, "\u00a7b/lagx mapart unprotect \u00a77- Remove protection from held map", true);
            Help.sendMsg(player, "\u00a7b/lagx mapart lock \u00a77- Lock held map (prevents updates)", true);
            Help.sendMsg(player, "\u00a7b/lagx mapart info \u00a77- Show map information", true);
            Help.sendMsg(player, "\u00a7b/lagx mapart list \u00a77- List protected maps", true);
            Help.sendMsg(player, "\u00a76Admin Commands:", true);
            Help.sendMsg(player, "\u00a7b/lagx mapart auto \u00a77- Toggle automatic protection", true);
            Help.sendMsg(player, "\u00a7b/lagx mapart interval <minutes> \u00a77- Set scan interval", true);
            Help.sendMsg(player, "\u00a7b/lagx mapart status \u00a77- Show auto-protection status", true);
            return true;
        }
        switch (subCommand = args[1].toLowerCase()) {
            case "protect": {
                return this.protectMap(player);
            }
            case "unprotect": {
                return this.unprotectMap(player);
            }
            case "lock": {
                return this.lockMap(player);
            }
            case "unlock": {
                return this.unlockMap(player);
            }
            case "info": {
                return this.showMapInfo(player);
            }
            case "list": {
                return this.listProtectedMaps(player);
            }
            case "auto": {
                return this.toggleAutoProtection(player);
            }
            case "interval": {
                return this.setInterval(player, args);
            }
            case "status": {
                return this.showStatus(player);
            }
        }
        Help.sendMsg(player, "\u00a7cUnknown subcommand. Use \u00a7e/lagx mapart \u00a7cfor help.", true);
        return true;
    }

    private boolean protectMap(Player player) {
        if (!this.hasPermission((CommandSender)player, "lagx.mapart.protect")) {
            Help.sendMsg(player, "\u00a7cYou don't have permission to protect maps.", true);
            return true;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType() != Material.FILLED_MAP) {
            Help.sendMsg(player, "\u00a7cYou must be holding a filled map to protect it.", true);
            return true;
        }
        MapMeta meta = (MapMeta)item.getItemMeta();
        if (meta == null || !meta.hasMapView()) {
            Help.sendMsg(player, "\u00a7cInvalid map item.", true);
            return true;
        }
        int mapId = meta.getMapView().getId();
        this.plugin.getMapArtManager().protectMap(mapId, player.getName());
        Help.sendMsg(player, "\u00a7aMap ID \u00a7b" + mapId + "\u00a7a has been protected from changes!", true);
        return true;
    }

    private boolean unprotectMap(Player player) {
        if (!this.hasPermission((CommandSender)player, "lagx.mapart.unprotect")) {
            Help.sendMsg(player, "\u00a7cYou don't have permission to unprotect maps.", true);
            return true;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType() != Material.FILLED_MAP) {
            Help.sendMsg(player, "\u00a7cYou must be holding a filled map to unprotect it.", true);
            return true;
        }
        MapMeta meta = (MapMeta)item.getItemMeta();
        if (meta == null || !meta.hasMapView()) {
            Help.sendMsg(player, "\u00a7cInvalid map item.", true);
            return true;
        }
        int mapId = meta.getMapView().getId();
        if (!this.plugin.getMapArtManager().isMapProtected(mapId)) {
            Help.sendMsg(player, "\u00a7cThis map is not protected.", true);
            return true;
        }
        String owner = this.plugin.getMapArtManager().getMapOwner(mapId);
        if (!player.getName().equals(owner) && !this.hasPermission((CommandSender)player, "lagx.mapart.admin")) {
            Help.sendMsg(player, "\u00a7cYou can only unprotect maps that you own.", true);
            return true;
        }
        this.plugin.getMapArtManager().unprotectMap(mapId);
        Help.sendMsg(player, "\u00a7aMap ID \u00a7b" + mapId + "\u00a7a has been unprotected.", true);
        return true;
    }

    private boolean lockMap(Player player) {
        if (!this.hasPermission((CommandSender)player, "lagx.mapart.lock")) {
            Help.sendMsg(player, "\u00a7cYou don't have permission to lock maps.", true);
            return true;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType() != Material.FILLED_MAP) {
            Help.sendMsg(player, "\u00a7cYou must be holding a filled map to lock it.", true);
            return true;
        }
        MapMeta meta = (MapMeta)item.getItemMeta();
        if (meta == null || !meta.hasMapView()) {
            Help.sendMsg(player, "\u00a7cInvalid map item.", true);
            return true;
        }
        meta.getMapView().setLocked(true);
        item.setItemMeta((ItemMeta)meta);
        Help.sendMsg(player, "\u00a7aMap has been locked and will no longer update!", true);
        return true;
    }

    private boolean unlockMap(Player player) {
        if (!this.hasPermission((CommandSender)player, "lagx.mapart.unlock")) {
            Help.sendMsg(player, "\u00a7cYou don't have permission to unlock maps.", true);
            return true;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType() != Material.FILLED_MAP) {
            Help.sendMsg(player, "\u00a7cYou must be holding a filled map to unlock it.", true);
            return true;
        }
        MapMeta meta = (MapMeta)item.getItemMeta();
        if (meta == null || !meta.hasMapView()) {
            Help.sendMsg(player, "\u00a7cInvalid map item.", true);
            return true;
        }
        meta.getMapView().setLocked(false);
        item.setItemMeta((ItemMeta)meta);
        Help.sendMsg(player, "\u00a7aMap has been unlocked and will now update normally.", true);
        return true;
    }

    private boolean showMapInfo(Player player) {
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType() != Material.FILLED_MAP) {
            Help.sendMsg(player, "\u00a7cYou must be holding a filled map to view its info.", true);
            return true;
        }
        MapMeta meta = (MapMeta)item.getItemMeta();
        if (meta == null || !meta.hasMapView()) {
            Help.sendMsg(player, "\u00a7cInvalid map item.", true);
            return true;
        }
        int mapId = meta.getMapView().getId();
        boolean isLocked = meta.getMapView().isLocked();
        boolean isProtected = this.plugin.getMapArtManager().isMapProtected(mapId);
        String owner = this.plugin.getMapArtManager().getMapOwner(mapId);
        Help.sendMsg(player, "\u00a7eMap Information:", true);
        Help.sendMsg(player, "\u00a77Map ID: \u00a7b" + mapId, true);
        Help.sendMsg(player, "\u00a77Locked: " + (isLocked ? "\u00a7aYes" : "\u00a7cNo"), true);
        Help.sendMsg(player, "\u00a77Protected: " + (isProtected ? "\u00a7aYes" : "\u00a7cNo"), true);
        if (isProtected && owner != null) {
            Help.sendMsg(player, "\u00a77Owner: \u00a7b" + owner, true);
        }
        return true;
    }

    private boolean listProtectedMaps(Player player) {
        if (!this.hasPermission((CommandSender)player, "lagx.mapart.list")) {
            Help.sendMsg(player, "\u00a7cYou don't have permission to list protected maps.", true);
            return true;
        }
        Map<Integer, String> protectedMaps = this.plugin.getMapArtManager().getProtectedMaps();
        if (protectedMaps.isEmpty()) {
            Help.sendMsg(player, "\u00a7eThere are no protected maps.", true);
            return true;
        }
        Help.sendMsg(player, "\u00a7eProtected Maps:", true);
        for (Map.Entry<Integer, String> entry : protectedMaps.entrySet()) {
            int mapId = entry.getKey();
            String owner = entry.getValue();
            Help.sendMsg(player, "\u00a77- Map ID \u00a7b" + mapId + "\u00a77 owned by \u00a7b" + owner, true);
        }
        return true;
    }

    @Override
    public String getPermission() {
        return "lagx.mapart";
    }

    @Override
    public String getUsage() {
        return "/lagx mapart <protect|unprotect|lock|unlock|info|list|auto|interval|status>";
    }

    @Override
    public String getDescription() {
        return "Manage map art protection";
    }

    private boolean toggleAutoProtection(Player player) {
        if (!this.hasPermission((CommandSender)player, "lagx.mapart.admin")) {
            Help.sendMsg(player, "\u00a7cYou don't have permission to manage auto-protection.", true);
            return true;
        }
        boolean currentState = this.plugin.getMapArtManager().isAutoProtectionEnabled();
        this.plugin.getMapArtManager().setAutoProtectionEnabled(!currentState);
        String status = !currentState ? "\u00a7aenabled" : "\u00a7cdisabled";
        Help.sendMsg(player, "\u00a7eAutomatic map protection has been " + status + "\u00a7e!", true);
        return true;
    }

    private boolean setInterval(Player player, String[] args) {
        if (!this.hasPermission((CommandSender)player, "lagx.mapart.admin")) {
            Help.sendMsg(player, "\u00a7cYou don't have permission to manage auto-protection.", true);
            return true;
        }
        if (args.length < 3) {
            Help.sendMsg(player, "\u00a7cUsage: /lagx mapart interval <minutes>", true);
            return true;
        }
        try {
            int minutes = Integer.parseInt(args[2]);
            if (minutes < 1) {
                Help.sendMsg(player, "\u00a7cInterval must be at least 1 minute.", true);
                return true;
            }
            this.plugin.getMapArtManager().setScanInterval(minutes);
            Help.sendMsg(player, "\u00a7eScan interval set to \u00a7b" + minutes + " minutes\u00a7e!", true);
        }
        catch (NumberFormatException e) {
            Help.sendMsg(player, "\u00a7cInvalid number: " + args[2], true);
        }
        return true;
    }

    private boolean showStatus(Player player) {
        if (!this.hasPermission((CommandSender)player, "lagx.mapart.admin")) {
            Help.sendMsg(player, "\u00a7cYou don't have permission to view auto-protection status.", true);
            return true;
        }
        MapArtManager manager = this.plugin.getMapArtManager();
        Help.sendMsg(player, "\u00a7eMap Art Auto-Protection Status:", true);
        Help.sendMsg(player, "\u00a77Status: " + (manager.isAutoProtectionEnabled() ? "\u00a7aEnabled" : "\u00a7cDisabled"), true);
        Help.sendMsg(player, "\u00a77Scan Interval: \u00a7b" + manager.getScanInterval() + " minutes", true);
        Help.sendMsg(player, "\u00a77Protect All Maps: " + (manager.isProtectingAllMaps() ? "\u00a7aYes" : "\u00a7cNo"), true);
        Help.sendMsg(player, "\u00a77Protected Maps: \u00a7b" + manager.getProtectedMapIds().size(), true);
        return true;
    }
}

