/*
 * Decompiled with CFR 0.152.
 */
package com.seristic.lagx.commands;

import com.seristic.lagx.commands.LagXCommand;
import com.seristic.lagx.inf.Help;
import com.seristic.lagx.main.LagX;
import com.seristic.lagx.util.TownyIntegration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TownyCommand
extends LagXCommand {
    public TownyCommand(LagX plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        String subCommand;
        TownyIntegration towny = LagX.getTownyIntegration();
        if (towny == null || !towny.isEnabled()) {
            Help.sendMsg(sender, "\u00a7cTowny integration is not enabled on this server.", true);
            return true;
        }
        if (args.length < 2) {
            Help.sendMsg(sender, "\u00a7cUsage: " + this.getUsage(), true);
            return true;
        }
        switch (subCommand = args[1].toLowerCase()) {
            case "status": 
            case "s": {
                this.showStatus(sender, towny);
                break;
            }
            case "info": 
            case "i": {
                this.showInfo(sender, towny);
                break;
            }
            default: {
                Help.sendMsg(sender, "\u00a7cUnknown subcommand. Available options: status, info", true);
            }
        }
        return true;
    }

    private void showStatus(CommandSender sender, TownyIntegration towny) {
        Help.sendMsg(sender, "\u00a76Towny Integration Status:", true);
        Help.sendMsg(sender, "\u00a7eEnabled: \u00a7a" + towny.isEnabled(), false);
        Help.sendMsg(sender, "\u00a7eVersion: \u00a7a" + towny.getVersion(), false);
    }

    private void showInfo(CommandSender sender, TownyIntegration towny) {
        if (!(sender instanceof Player)) {
            Help.sendMsg(sender, "\u00a7cThis command can only be used by players.", true);
            return;
        }
        Player player = (Player)sender;
        Location loc = player.getLocation();
        boolean isProtected = towny.isLocationProtected(loc);
        String townName = towny.getTownAtLocation(loc);
        Help.sendMsg(sender, "\u00a76Towny Information for your location:", true);
        Help.sendMsg(sender, "\u00a7eProtected: \u00a7" + (isProtected ? "a" : "c") + isProtected, false);
        Help.sendMsg(sender, "\u00a7eTown: \u00a7a" + (townName != null ? townName : "None"), false);
    }

    @Override
    public String getPermission() {
        return "lagx.towny";
    }

    @Override
    public String getUsage() {
        return "/lagx towny [status|info]";
    }

    @Override
    public String getDescription() {
        return "Towny integration information";
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        if (args.length == 2) {
            return Arrays.asList("status", "s", "info", "i");
        }
        return new ArrayList<String>();
    }
}

