/*
 * Decompiled with CFR 0.152.
 */
package com.seristic.lagx.commands;

import com.seristic.lagx.commands.LagXCommand;
import com.seristic.lagx.inf.Help;
import com.seristic.lagx.main.LagX;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.generator.WorldInfo;

public class WorldCommand
extends LagXCommand {
    public WorldCommand(LagX plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        String action;
        if (args.length < 2) {
            this.listWorlds(sender);
            return true;
        }
        switch (action = args[1].toLowerCase()) {
            case "list": {
                this.listWorlds(sender);
                break;
            }
            case "info": {
                if (args.length < 3) {
                    Help.sendMsg(sender, "\u00a7cUsage: /lagx world info <world>", true);
                    return true;
                }
                this.showWorldInfo(sender, args[2]);
                break;
            }
            case "tp": {
                if (!(sender instanceof Player)) {
                    Help.sendMsg(sender, "\u00a7cOnly players can use this command.", true);
                    return true;
                }
                if (args.length < 3) {
                    Help.sendMsg(sender, "\u00a7cUsage: /lagx world tp <world>", true);
                    return true;
                }
                this.teleportToWorld((Player)sender, args[2]);
                break;
            }
            default: {
                Help.sendMsg(sender, "\u00a7cUsage: " + this.getUsage(), true);
            }
        }
        return true;
    }

    private void listWorlds(CommandSender sender) {
        List worlds = Bukkit.getWorlds();
        StringBuilder msg = new StringBuilder("\u00a76Available Worlds:\n");
        for (World world : worlds) {
            int entities = world.getEntities().size();
            int chunks = world.getLoadedChunks().length;
            int players = world.getPlayers().size();
            msg.append("\u00a77- \u00a7e").append(world.getName()).append(" \u00a77(").append(world.getEnvironment().toString().toLowerCase()).append(")\n").append("  \u00a77Players: \u00a7f").append(players).append(" \u00a77| Entities: \u00a7f").append(entities).append(" \u00a77| Chunks: \u00a7f").append(chunks).append("\n");
        }
        Help.sendMsg(sender, msg.toString(), true);
    }

    private void showWorldInfo(CommandSender sender, String worldName) {
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            Help.sendMsg(sender, "\u00a7cWorld '" + worldName + "' not found!", true);
            return;
        }
        StringBuilder info = new StringBuilder("\u00a76World Information - \u00a7e").append(world.getName()).append("\n");
        info.append("\u00a77Environment: \u00a7f").append(world.getEnvironment().toString().toLowerCase()).append("\n");
        info.append("\u00a77Seed: \u00a7f").append(world.getSeed()).append("\n");
        info.append("\u00a77Players: \u00a7f").append(world.getPlayers().size()).append("\n");
        info.append("\u00a77Entities: \u00a7f").append(world.getEntities().size()).append("\n");
        info.append("\u00a77Loaded Chunks: \u00a7f").append(world.getLoadedChunks().length).append("\n");
        info.append("\u00a77Spawn Location: \u00a7f").append(world.getSpawnLocation().getBlockX()).append(", ").append(world.getSpawnLocation().getBlockY()).append(", ").append(world.getSpawnLocation().getBlockZ()).append("\n");
        info.append("\u00a77Difficulty: \u00a7f").append(world.getDifficulty().toString().toLowerCase()).append("\n");
        info.append("\u00a77PvP: \u00a7f").append(world.getPVP() ? "Enabled" : "Disabled").append("\n");
        info.append("\u00a77Game Rules:\n");
        info.append("  \u00a77- Keep Inventory: \u00a7f").append(world.getGameRuleValue("keepInventory")).append("\n");
        info.append("  \u00a77- Mob Spawning: \u00a7f").append(world.getGameRuleValue("doMobSpawning")).append("\n");
        info.append("  \u00a77- Day/Night Cycle: \u00a7f").append(world.getGameRuleValue("doDaylightCycle"));
        Help.sendMsg(sender, info.toString(), true);
    }

    private void teleportToWorld(Player player, String worldName) {
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            Help.sendMsg(player, "\u00a7cWorld '" + worldName + "' not found!", true);
            return;
        }
        player.teleport(world.getSpawnLocation());
        Help.sendMsg(player, "\u00a7aTeleported to world: \u00a7e" + world.getName(), true);
    }

    @Override
    public String getPermission() {
        return "lagx.world";
    }

    @Override
    public String getUsage() {
        return "/lagx world [list|info|tp] [world]";
    }

    @Override
    public String getDescription() {
        return "Manage and view world information";
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 2) {
            completions.add("list");
            completions.add("info");
            if (sender instanceof Player) {
                completions.add("tp");
            }
        } else if (args.length == 3 && (args[1].equalsIgnoreCase("info") || args[1].equalsIgnoreCase("tp"))) {
            completions.addAll(Bukkit.getWorlds().stream().map(WorldInfo::getName).collect(Collectors.toList()));
        }
        return completions;
    }
}

