/*
 * Decompiled with CFR 0.152.
 */
package com.seristic.lagx.listeners;

import com.seristic.lagx.main.LagX;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.server.MapInitializeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.map.MapView;

public class MapProtectionListener
implements Listener {
    private final LagX plugin;

    public MapProtectionListener(LagX plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onMapUse(PlayerInteractEvent event) {
        ItemStack item = event.getItem();
        if (item == null || item.getType() != Material.FILLED_MAP) {
            return;
        }
        MapMeta meta = (MapMeta)item.getItemMeta();
        if (meta == null || !meta.hasMapView()) {
            return;
        }
        int mapId = meta.getMapView().getId();
        if (this.plugin.getMapArtManager().isMapProtected(mapId)) {
            if (!LagX.hasPermission(event.getPlayer(), "lagx.mapart.bypass")) {
                String owner = this.plugin.getMapArtManager().getMapOwner(mapId);
                if (!event.getPlayer().getName().equals(owner)) {
                    event.setCancelled(true);
                    event.getPlayer().sendMessage("\u00a7cThis map art is protected by " + owner + "!");
                    return;
                }
            }
        }
        if (!meta.getMapView().isLocked() && this.plugin.getMapArtManager().isMapProtected(mapId)) {
            meta.getMapView().setLocked(true);
            item.setItemMeta((ItemMeta)meta);
        }
    }

    @EventHandler
    public void onMapClone(PrepareItemCraftEvent event) {
        ItemStack result = event.getInventory().getResult();
        if (result == null || result.getType() != Material.FILLED_MAP) {
            return;
        }
        ItemStack sourceMap = null;
        for (ItemStack ingredient : event.getInventory().getMatrix()) {
            if (ingredient == null || ingredient.getType() != Material.FILLED_MAP) continue;
            sourceMap = ingredient;
            break;
        }
        if (sourceMap == null) {
            return;
        }
        MapMeta sourceMeta = (MapMeta)sourceMap.getItemMeta();
        MapMeta resultMeta = (MapMeta)result.getItemMeta();
        if (sourceMeta == null || resultMeta == null || !sourceMeta.hasMapView()) {
            return;
        }
        int sourceMapId = sourceMeta.getMapView().getId();
        if (this.plugin.getMapArtManager().isMapProtected(sourceMapId)) {
            if (event.getView().getPlayer().hasPermission("lagx.mapart.clone")) {
                view = sourceMeta.getMapView();
                resultMeta.setMapView(view);
                result.setItemMeta((ItemMeta)resultMeta);
                this.plugin.getLogger().info("Player " + event.getView().getPlayer().getName() + " cloned protected map ID " + sourceMapId);
            } else {
                event.getInventory().setResult(null);
                event.getView().getPlayer().sendMessage("\u00a7cYou don't have permission to clone protected map art!");
            }
        } else {
            view = sourceMeta.getMapView();
            resultMeta.setMapView(view);
            result.setItemMeta((ItemMeta)resultMeta);
        }
    }

    @EventHandler
    public void onMapInitialize(MapInitializeEvent event) {
        MapView view = event.getMap();
        if (view.getWorld() == null && !this.plugin.getServer().getWorlds().isEmpty()) {
            view.setWorld((World)this.plugin.getServer().getWorlds().get(0));
        }
        this.plugin.getLogger().fine("Map " + view.getId() + " initialized in world " + (view.getWorld() != null ? view.getWorld().getName() : "null"));
    }
}

