/*
 * Decompiled with CFR 0.152.
 */
package com.seristic.lagx.main;

import com.seristic.lagx.util.BitString;
import com.seristic.lagx.util.DrewMath;
import org.bukkit.scheduler.BukkitRunnable;

public class TickPerSecond
extends BukkitRunnable {
    public static int TICK_COUNT = 0;
    public static long[] TICKS = new long[600];

    public static double getTPS() {
        return TickPerSecond.getTPS(100);
    }

    public static double getTPS(int ticks) {
        if (TICK_COUNT < ticks) {
            return 20.0;
        }
        int target = (TICK_COUNT - 1 - ticks) % TICKS.length;
        long elapsed = System.currentTimeMillis() - TICKS[target];
        return (double)ticks / ((double)elapsed / 1000.0);
    }

    public void run() {
        TickPerSecond.TICKS[TickPerSecond.TICK_COUNT % TickPerSecond.TICKS.length] = System.currentTimeMillis();
        ++TICK_COUNT;
    }

    public static String format() {
        double tps = DrewMath.round(TickPerSecond.getTPS(), 2);
        int tps_whole = (int)DrewMath.round(TickPerSecond.getTPS(), 0);
        String bf = BitString.BLOCK_FULL.getComp();
        String bl = BitString.BLOCK_FULL_LIGHT.getComp();
        StringBuilder sb = new StringBuilder();
        sb.append("\u00a7b").append(tps).append("\n\u00a7e<");
        if (tps_whole > 15) {
            sb.append("\u00a7a");
        } else if (tps_whole > 5) {
            sb.append("\u00a7e");
        } else {
            sb.append("\u00a7c");
        }
        boolean hasTricked = false;
        for (int i = 1; i < 21; ++i) {
            if (i > tps_whole) {
                if (!hasTricked) {
                    sb.append("\u00a77");
                    hasTricked = true;
                }
                sb.append(bl);
                continue;
            }
            sb.append(bf);
        }
        sb.append("\u00a7e>");
        return sb.toString();
    }
}

