/*
 * Decompiled with CFR 0.152.
 */
package com.seristic.lagx.managers;

import com.seristic.lagx.main.LagX;
import com.seristic.lagx.managers.IntegrationManager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.server.MapInitializeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.map.MapView;

public class CopyrightOverrideListener
implements Listener {
    private final LagX plugin;
    private final IntegrationManager.CopyrightPluginIntegration copyrightIntegration;

    public CopyrightOverrideListener(LagX plugin, IntegrationManager.CopyrightPluginIntegration copyrightIntegration) {
        this.plugin = plugin;
        this.copyrightIntegration = copyrightIntegration;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onMapInitialize(MapInitializeEvent event) {
        MapView mapView = event.getMap();
        int mapId = mapView.getId();
        if (this.copyrightIntegration.shouldOverrideProtection(mapId)) {
            this.plugin.getLogger().info("Overriding copyright protection for map ID " + mapId);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerHoldMap(PlayerItemHeldEvent event) {
        int mapId;
        MapMeta mapMeta;
        MapView mapView;
        ItemStack item = event.getPlayer().getInventory().getItem(event.getNewSlot());
        if (item == null || !item.hasItemMeta() || !(item.getItemMeta() instanceof MapMeta) || (mapView = (mapMeta = (MapMeta)item.getItemMeta()).getMapView()) == null || this.copyrightIntegration.shouldOverrideProtection(mapId = mapView.getId())) {
            // empty if block
        }
    }
}

