/*
 * Decompiled with CFR 0.152.
 */
package com.seristic.lagx.managers;

import com.seristic.lagx.main.LagX;
import com.seristic.lagx.managers.ConfigurationManager;
import com.seristic.lagx.managers.EventManager;
import com.seristic.lagx.managers.FeatureManager;
import com.seristic.lagx.managers.IntegrationManager;
import com.seristic.lagx.managers.ModuleLoader;
import com.seristic.lagx.managers.TaskManager;

public class LagXPluginManager {
    private final LagX plugin;
    private final FeatureManager featureManager;
    private final TaskManager taskManager;
    private final EventManager eventManager;
    private final ConfigurationManager configManager;
    private final IntegrationManager integrationManager;
    private final ModuleLoader moduleLoader;
    private boolean initialized = false;

    public LagXPluginManager(LagX plugin) {
        this.plugin = plugin;
        this.configManager = new ConfigurationManager(plugin);
        this.featureManager = new FeatureManager(plugin, this.configManager);
        this.taskManager = new TaskManager(plugin, this.configManager);
        this.eventManager = new EventManager(plugin);
        this.integrationManager = new IntegrationManager(plugin, this.configManager);
        this.moduleLoader = new ModuleLoader(plugin);
    }

    public void initialize() {
        if (this.initialized) {
            throw new IllegalStateException("LagXPluginManager is already initialized");
        }
        try {
            this.plugin.getLogger().info("Initializing LagX v" + this.plugin.getPluginMeta().getVersion());
            this.configManager.initialize();
            this.moduleLoader.initialize();
            this.integrationManager.initialize();
            this.featureManager.initialize();
            this.eventManager.initialize();
            this.taskManager.initialize();
            this.initialized = true;
            this.plugin.getLogger().info("LagX initialization completed successfully");
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to initialize LagX: " + e.getMessage());
            e.printStackTrace();
            throw new RuntimeException("Plugin initialization failed", e);
        }
    }

    public void shutdown() {
        if (!this.initialized) {
            return;
        }
        try {
            this.plugin.getLogger().info("Shutting down LagX...");
            this.taskManager.shutdown();
            this.eventManager.shutdown();
            this.featureManager.shutdown();
            this.integrationManager.shutdown();
            this.moduleLoader.shutdown();
            this.configManager.shutdown();
            this.initialized = false;
            this.plugin.getLogger().info("LagX shutdown completed");
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error during LagX shutdown: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void reload() {
        this.plugin.getLogger().info("Reloading LagX...");
        this.taskManager.shutdown();
        this.featureManager.shutdown();
        this.configManager.reload();
        this.integrationManager.reload();
        this.featureManager.initialize();
        this.taskManager.initialize();
        this.plugin.getLogger().info("LagX reload completed");
    }

    public FeatureManager getFeatureManager() {
        return this.featureManager;
    }

    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public ConfigurationManager getConfigManager() {
        return this.configManager;
    }

    public IntegrationManager getIntegrationManager() {
        return this.integrationManager;
    }

    public ModuleLoader getModuleLoader() {
        return this.moduleLoader;
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

