/*
 * Decompiled with CFR 0.152.
 */
package com.seristic.lagx.managers;

import com.seristic.lagx.main.LagX;
import com.seristic.lagx.managers.ConfigurationManager;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.plugin.Plugin;

public class TaskManager {
    private final LagX plugin;
    private final ConfigurationManager configManager;
    private final Map<String, ScheduledTask> tasks = new HashMap<String, ScheduledTask>();

    public TaskManager(LagX plugin, ConfigurationManager configManager) {
        this.plugin = plugin;
        this.configManager = configManager;
    }

    public void initialize() {
        this.plugin.getLogger().info("Starting scheduled tasks...");
        this.startChunkUnloadTask();
        this.startLagRemovalTask();
        this.startEntityCleanupTask();
        this.plugin.getLogger().info("Started " + this.tasks.size() + " scheduled tasks");
    }

    private void startChunkUnloadTask() {
        if (!this.configManager.isTaskEnabled("chunk-unload")) {
            return;
        }
        int interval = this.configManager.getTaskInterval("chunk-unload");
        long intervalSeconds = (long)interval * 60L;
        ScheduledTask task = Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)this.plugin, scheduledTask -> this.performChunkUnload(), intervalSeconds * 20L, intervalSeconds * 20L);
        this.tasks.put("chunk-unload", task);
        this.plugin.getLogger().info("Chunk unload task started (interval: " + interval + " minutes)");
    }

    private void startLagRemovalTask() {
        if (!this.configManager.isTaskEnabled("lag-removal")) {
            return;
        }
        int interval = this.configManager.getTaskInterval("lag-removal");
        long intervalSeconds = (long)interval * 60L;
        ScheduledTask task = Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)this.plugin, scheduledTask -> this.performLagRemoval(), intervalSeconds * 20L, intervalSeconds * 20L);
        this.tasks.put("lag-removal", task);
        this.plugin.getLogger().info("Lag removal task started (interval: " + interval + " minutes)");
    }

    private void startEntityCleanupTask() {
        if (!this.configManager.isTaskEnabled("entity-cleanup")) {
            return;
        }
        int interval = this.configManager.getTaskInterval("entity-cleanup");
        long intervalSeconds = (long)interval * 60L;
        ScheduledTask task = Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)this.plugin, scheduledTask -> this.performEntityCleanup(), intervalSeconds * 20L, intervalSeconds * 20L);
        this.tasks.put("entity-cleanup", task);
        this.plugin.getLogger().info("Entity cleanup task started (interval: " + interval + " minutes)");
    }

    private void performChunkUnload() {
        try {
            int unloaded = 0;
            for (World world : Bukkit.getWorlds()) {
                Chunk[] chunks;
                for (Chunk chunk : chunks = world.getLoadedChunks()) {
                    if (!chunk.getPluginChunkTickets().isEmpty() || chunk.isForceLoaded() || !world.unloadChunk(chunk)) continue;
                    ++unloaded;
                }
            }
            if (unloaded > 0) {
                this.plugin.getLogger().info("Unloaded " + unloaded + " unused chunks");
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error during chunk unload: " + e.getMessage());
        }
    }

    private void performLagRemoval() {
        try {
            int removed = 0;
            for (World world : Bukkit.getWorlds()) {
                for (Entity entity : world.getEntities()) {
                    Item item;
                    if (!(entity instanceof Item) || (item = (Item)entity).getTicksLived() <= 6000) continue;
                    item.remove();
                    ++removed;
                }
            }
            if (removed > 0) {
                this.plugin.getLogger().info("Removed " + removed + " old items for lag reduction");
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error during lag removal: " + e.getMessage());
        }
    }

    private void performEntityCleanup() {
        try {
            int cleaned = 0;
            for (World world : Bukkit.getWorlds()) {
                for (Entity entity : world.getEntities()) {
                    if (!this.shouldCleanupEntity(entity)) continue;
                    entity.remove();
                    ++cleaned;
                }
            }
            if (cleaned > 0) {
                this.plugin.getLogger().info("Cleaned up " + cleaned + " entities");
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error during entity cleanup: " + e.getMessage());
        }
    }

    private boolean shouldCleanupEntity(Entity entity) {
        if (entity instanceof ExperienceOrb) {
            return entity.getTicksLived() > 2400;
        }
        if (entity instanceof Arrow) {
            return entity.getTicksLived() > 1200;
        }
        return false;
    }

    public void shutdown() {
        this.plugin.getLogger().info("Shutting down scheduled tasks...");
        for (Map.Entry<String, ScheduledTask> entry : this.tasks.entrySet()) {
            try {
                entry.getValue().cancel();
                this.plugin.getLogger().info("Cancelled task: " + entry.getKey());
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error cancelling task " + entry.getKey() + ": " + e.getMessage());
            }
        }
        this.tasks.clear();
    }

    public void cancelTask(String taskName) {
        ScheduledTask task = this.tasks.get(taskName);
        if (task != null) {
            task.cancel();
            this.tasks.remove(taskName);
            this.plugin.getLogger().info("Cancelled task: " + taskName);
        }
    }

    public boolean isTaskRunning(String taskName) {
        ScheduledTask task = this.tasks.get(taskName);
        return task != null && !task.isCancelled();
    }

    public Map<String, ScheduledTask> getAllTasks() {
        return new HashMap<String, ScheduledTask>(this.tasks);
    }
}

