/*
 * Decompiled with CFR 0.152.
 */
package com.seristic.lagx.proto.bin;

import com.seristic.lagx.api.aparser.ProtoParse;
import com.seristic.lagx.api.proto.LRProtocol;
import com.seristic.lagx.api.proto.LRProtocolResult;
import com.seristic.lagx.api.proto.Protocol;
import com.seristic.lagx.api.proto.ProtocolCategory;
import com.seristic.lagx.api.proto.help.HelpFormatter;
import com.seristic.lagx.util.Counter;
import java.util.HashMap;

public class LRGC
implements LRProtocol {
    public static Counter counter;
    private static String help;

    @Override
    public void init() {
        counter = Protocol.getCounter(this);
    }

    @Override
    public String id() {
        return "lr_gc";
    }

    @Override
    public String help() {
        return help;
    }

    @Override
    public ProtocolCategory[] category() {
        return new ProtocolCategory[]{ProtocolCategory.RAM};
    }

    @Override
    public LRProtocolResult run(Object[] args) {
        Runtime r = Runtime.getRuntime();
        long Lused = (r.totalMemory() - r.freeMemory()) / 1024L / 1024L;
        System.gc();
        final long used = Lused - (r.totalMemory() - r.freeMemory()) / 1024L / 1024L;
        return new LRProtocolResult(this, this){

            @Override
            public Object[] getData() {
                return new Object[]{used};
            }
        };
    }

    @Override
    public ProtoParse getProtocolParser() {
        return new ProtoParse(this){

            @Override
            public HashMap<String, ProtoParse.ProtoParseData> getKeysToClass() {
                return new HashMap<String, ProtoParse.ProtoParseData>();
            }
        };
    }

    static {
        help = new HelpFormatter().set(HelpFormatter.HelpFormatterType.DESCRIPTION, "\u00a7eReduces RAM usage by removing unneeded items stored in RAM.").set(HelpFormatter.HelpFormatterType.CATEGORIES, "\u00a7eRAM").set(HelpFormatter.HelpFormatterType.ARGUMENTS, HelpFormatter.generateArgs(new LRGC().getProtocolParser())).set(HelpFormatter.HelpFormatterType.RETURNS, "\u00a7e{0: <(long)ramMB>}").make();
    }
}

