/*
 * Decompiled with CFR 0.152.
 */
package com.seristic.lagx.util;

import com.seristic.lagx.main.LagX;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class EntityStacker
implements Listener {
    private final LagX plugin;
    private boolean enabled;
    private boolean debugMode;
    private double stackingRange;
    private int maxItemStackSize;
    private int maxMobStackSize;
    private int maxSpawnerStackSize;
    private int maxStacksPerChunk;
    private String displayFormat;
    private boolean singleKill;
    private boolean preventUpwardStacking;
    private final Map<UUID, Long> recentDeaths = new ConcurrentHashMap<UUID, Long>();
    private final Set<EntityType> stackableEntities = new HashSet<EntityType>();
    private final Set<Material> stackableItems = new HashSet<Material>();
    private final NamespacedKey stackSizeKey;
    private final NamespacedKey spawnTimeKey;
    private final NamespacedKey masterKey;

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isSingleKillEnabled() {
        return this.singleKill;
    }

    public void reloadConfig() {
        boolean wasEnabled = this.enabled;
        this.stackableEntities.clear();
        this.stackableItems.clear();
        this.plugin.reloadConfig();
        this.loadConfig();
        if (!wasEnabled && this.enabled) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
            Bukkit.getAsyncScheduler().runAtFixedRate((Plugin)this.plugin, task -> this.attemptStackAllEntities(), 5L, 5L, TimeUnit.SECONDS);
            if (this.debugMode) {
                this.plugin.getLogger().info("Entity Stacker enabled - Max stack sizes: Items=" + this.maxItemStackSize + ", Mobs=" + this.maxMobStackSize + ", Spawners=" + this.maxSpawnerStackSize);
            }
        } else if (wasEnabled && !this.enabled) {
            if (this.debugMode) {
                this.plugin.getLogger().info("Entity Stacker disabled - restart required for full effect");
            }
        } else if (this.enabled && this.debugMode) {
            this.plugin.getLogger().info("Entity Stacker reloaded - Max stack sizes: Items=" + this.maxItemStackSize + ", Mobs=" + this.maxMobStackSize + ", Spawners=" + this.maxSpawnerStackSize);
        }
    }

    public EntityStacker(LagX plugin) {
        this.plugin = plugin;
        this.stackSizeKey = new NamespacedKey((Plugin)plugin, "stack_size");
        this.spawnTimeKey = new NamespacedKey((Plugin)plugin, "spawn_time");
        this.masterKey = new NamespacedKey((Plugin)plugin, "stack_master");
        this.loadConfig();
        if (this.enabled) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
            Bukkit.getAsyncScheduler().runAtFixedRate((Plugin)plugin, task -> this.attemptStackAllEntities(), 5L, 5L, TimeUnit.SECONDS);
            if (this.debugMode) {
                plugin.getLogger().info("Entity Stacker enabled - Max stack sizes: Items=" + this.maxItemStackSize + ", Mobs=" + this.maxMobStackSize + ", Spawners=" + this.maxSpawnerStackSize);
            }
        }
    }

    private void loadConfig() {
        ConfigurationSection config = this.plugin.getConfig().getConfigurationSection("stacker");
        if (config == null) {
            this.enabled = false;
            if (this.debugMode) {
                this.plugin.getLogger().info("EntityStacker: No stacker config section found, disabled");
            }
        } else {
            this.enabled = config.getBoolean("enabled", true);
            this.debugMode = config.getBoolean("debug", false);
            this.stackingRange = config.getDouble("stacking_range", 5.0);
            this.maxItemStackSize = config.getInt("max_stack_size.items", 128);
            this.maxMobStackSize = config.getInt("max_stack_size.mobs", 32);
            this.maxSpawnerStackSize = config.getInt("max_stack_size.spawners", 5);
            this.maxStacksPerChunk = config.getInt("max_stacks_per_chunk", 4);
            this.displayFormat = config.getString("display_format", "<white>[x%amount%] <reset>");
            this.preventUpwardStacking = config.getBoolean("prevent_upward_stacking", true);
            ConfigurationSection killConfig = config.getConfigurationSection("kill_behavior");
            this.singleKill = killConfig != null ? killConfig.getBoolean("single_kill", true) : true;
            List entityList = config.getStringList("stackable_entities");
            if (this.debugMode) {
                this.plugin.getLogger().info("EntityStacker: Loading " + entityList.size() + " stackable entity types: " + String.valueOf(entityList));
            }
            for (String entityName : entityList) {
                try {
                    EntityType entityType = EntityType.valueOf((String)entityName.toUpperCase());
                    this.stackableEntities.add(entityType);
                    if (!this.debugMode) continue;
                    this.plugin.getLogger().info("EntityStacker: Added stackable entity: " + String.valueOf(entityType));
                }
                catch (IllegalArgumentException var9) {
                    if (!this.debugMode) continue;
                    this.plugin.getLogger().warning("Invalid entity type in stacker config: " + entityName);
                }
            }
            for (String itemName : config.getStringList("stackable_items")) {
                try {
                    Material material = Material.valueOf((String)itemName.toUpperCase());
                    this.stackableItems.add(material);
                }
                catch (IllegalArgumentException var8) {
                    if (!this.debugMode) continue;
                    this.plugin.getLogger().warning("Invalid material type in stacker config: " + itemName);
                }
            }
        }
    }

    private void attemptStackAllEntities() {
        if (this.enabled) {
            for (World world : Bukkit.getWorlds()) {
                for (Chunk chunk : world.getLoadedChunks()) {
                    Bukkit.getRegionScheduler().run((Plugin)this.plugin, world, chunk.getX(), chunk.getZ(), task -> {
                        HashMap<EntityType, List> entityGroups = new HashMap<EntityType, List>();
                        for (Entity entity : chunk.getEntities()) {
                            if (!this.isStackable(entity)) continue;
                            entityGroups.computeIfAbsent(entity.getType(), k -> new ArrayList()).add(entity);
                        }
                        for (List entities : entityGroups.values()) {
                            if (entities.size() < 2) continue;
                            block2: for (int i = 0; i < entities.size(); ++i) {
                                Entity entity1 = (Entity)entities.get(i);
                                if (entity1.isDead()) continue;
                                for (int j = i + 1; j < entities.size(); ++j) {
                                    Entity entity2 = (Entity)entities.get(j);
                                    if (entity2.isDead() || !(entity1.getLocation().distance(entity2.getLocation()) <= this.stackingRange)) continue;
                                    this.stack(entity1, entity2);
                                    continue block2;
                                }
                            }
                        }
                    });
                }
            }
        }
    }

    public boolean isStackable(Entity entity) {
        if (entity == null || entity.isDead()) {
            return false;
        }
        if (entity instanceof Item) {
            Item item = (Item)entity;
            return this.stackableItems.contains(item.getItemStack().getType());
        }
        return entity instanceof LivingEntity ? this.stackableEntities.contains(entity.getType()) : false;
    }

    private boolean stack(Entity entity1, Entity entity2) {
        if (this.isStackable(entity1) && this.isStackable(entity2)) {
            int maxStackSize;
            if (entity1.getType() != entity2.getType()) {
                return false;
            }
            Entity master = null;
            Entity slave = null;
            if (this.isStackMaster(entity1)) {
                master = entity1;
                slave = entity2;
            } else if (this.isStackMaster(entity2)) {
                master = entity2;
                slave = entity1;
            } else {
                long entity2SpawnTime;
                long entity1SpawnTime = this.getEntitySpawnTime(entity1);
                if (entity1SpawnTime <= (entity2SpawnTime = this.getEntitySpawnTime(entity2))) {
                    master = entity1;
                    slave = entity2;
                } else {
                    master = entity2;
                    slave = entity1;
                }
                this.setStackMaster(master);
            }
            if (this.preventUpwardStacking) {
                double masterY = master.getLocation().getY();
                double slaveY = slave.getLocation().getY();
                if (slaveY < masterY - 0.5) {
                    if (this.debugMode) {
                        this.plugin.getLogger().info("Blocked upward stacking: " + String.valueOf(slave.getType()) + " at Y=" + slaveY + " would teleport up to Y=" + masterY);
                    }
                    return false;
                }
            }
            int masterStackSize = this.getStackSize(master);
            int slaveStackSize = this.getStackSize(slave);
            if (master instanceof Item && slave instanceof Item) {
                int combinedStackSize2;
                Item masterItem = (Item)master;
                Item slaveItem = (Item)slave;
                if (masterStackSize <= 0) {
                    masterStackSize = 1;
                    this.setStackSize(master, 1);
                }
                if (slaveStackSize <= 0) {
                    slaveStackSize = 1;
                    this.setStackSize(slave, 1);
                }
                if ((combinedStackSize2 = masterStackSize + slaveStackSize) > this.maxItemStackSize) {
                    if (this.debugMode) {
                        this.plugin.getLogger().info("Item stack would exceed max size (" + this.maxItemStackSize + "), using split stacking");
                    }
                    this.setStackSize(master, this.maxItemStackSize);
                    int remainder = Math.min(combinedStackSize2 - this.maxItemStackSize, this.maxItemStackSize);
                    this.setStackSize(slave, remainder);
                    this.setStackMaster(slave);
                    return true;
                }
                this.setStackSize(master, combinedStackSize2);
                if (this.debugMode) {
                    this.plugin.getLogger().info("Stacked ITEM with " + slaveStackSize + " stacks into master with " + masterStackSize + " stacks = " + combinedStackSize2 + " total stacks");
                }
                try {
                    slave.teleport(master.getLocation());
                }
                catch (Exception remainder) {
                    // empty catch block
                }
                slave.remove();
                this.updateDisplayName(master, combinedStackSize2);
                return true;
            }
            int combinedStackSize = masterStackSize + slaveStackSize;
            int n = maxStackSize = master instanceof Item ? this.maxItemStackSize : this.maxMobStackSize;
            if (combinedStackSize <= maxStackSize) {
                this.setStackSize(master, combinedStackSize);
                try {
                    slave.teleport(master.getLocation());
                }
                catch (Exception combinedStackSize2) {
                    // empty catch block
                }
                slave.remove();
                if (this.debugMode) {
                    this.plugin.getLogger().info("Stacked " + String.valueOf(slave.getType()) + " (" + slaveStackSize + ") into master stack (" + masterStackSize + ") = " + combinedStackSize);
                }
                return true;
            }
            Chunk chunk = master.getLocation().getChunk();
            int currentStacks = this.countStacksInChunk(chunk, master.getType());
            if (currentStacks >= this.maxStacksPerChunk) {
                if (this.debugMode) {
                    this.plugin.getLogger().info("Cannot stack: chunk at max stacks (" + this.maxStacksPerChunk + ") for " + String.valueOf(master.getType()));
                }
                return false;
            }
            int remainder = combinedStackSize - maxStackSize;
            this.setStackSize(master, maxStackSize);
            this.setStackSize(slave, remainder);
            try {
                slave.teleport(master.getLocation());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setStackMaster(slave);
            if (this.debugMode) {
                this.plugin.getLogger().info("Split stacking: filled master " + String.valueOf(master.getType()) + " to max (" + maxStackSize + "), remainder " + remainder + " stays separate");
            }
            return true;
        }
        return false;
    }

    private int countStacksInChunk(Chunk chunk, EntityType entityType) {
        int stackCount = 0;
        for (Entity entity : chunk.getEntities()) {
            if (entity.getType() != entityType || !this.isStackable(entity)) continue;
            ++stackCount;
        }
        if (this.debugMode) {
            this.plugin.getLogger().info("Found " + stackCount + " actual stacks of " + String.valueOf(entityType) + " in chunk");
        }
        return stackCount;
    }

    private int getStackSize(Entity entity) {
        if (entity == null) {
            return 0;
        }
        try {
            PersistentDataContainer container = entity.getPersistentDataContainer();
            if (container.has(this.stackSizeKey, PersistentDataType.INTEGER)) {
                int size = (Integer)container.get(this.stackSizeKey, PersistentDataType.INTEGER);
                if (size >= 0 && size <= 1000000) {
                    return size;
                }
                if (this.debugMode) {
                    this.plugin.getLogger().warning("Invalid stack size detected: " + size + " for " + String.valueOf(entity.getType()) + ", resetting to 1");
                }
                this.setStackSize(entity, 1);
                return 1;
            }
        }
        catch (Exception var5) {
            if (this.debugMode) {
                this.plugin.getLogger().warning("Error getting stack size: " + var5.getMessage());
            }
            try {
                this.setStackSize(entity, 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 1;
    }

    private void setStackSize(Entity entity, int size) {
        block3: {
            if (entity != null) {
                size = size <= 0 ? 1 : (entity instanceof Item ? Math.min(size, this.maxItemStackSize) : Math.min(size, this.maxMobStackSize));
                try {
                    entity.getPersistentDataContainer().set(this.stackSizeKey, PersistentDataType.INTEGER, (Object)size);
                    this.updateDisplayName(entity, size);
                }
                catch (Exception var4) {
                    if (!this.debugMode) break block3;
                    this.plugin.getLogger().warning("Error setting stack size: " + var4.getMessage());
                }
            }
        }
    }

    private long getEntitySpawnTime(Entity entity) {
        if (entity == null) {
            return Long.MAX_VALUE;
        }
        PersistentDataContainer pdc = entity.getPersistentDataContainer();
        return !pdc.has(this.spawnTimeKey, PersistentDataType.LONG) ? 0L : (Long)pdc.get(this.spawnTimeKey, PersistentDataType.LONG);
    }

    private void setEntitySpawnTime(Entity entity, long spawnTime) {
        if (entity != null) {
            entity.getPersistentDataContainer().set(this.spawnTimeKey, PersistentDataType.LONG, (Object)spawnTime);
        }
    }

    private void setStackMaster(Entity entity) {
        if (entity != null) {
            entity.getPersistentDataContainer().set(this.masterKey, PersistentDataType.BYTE, (Object)1);
        }
    }

    private boolean isStackMaster(Entity entity) {
        return entity == null ? false : entity.getPersistentDataContainer().has(this.masterKey, PersistentDataType.BYTE);
    }

    private void updateDisplayName(Entity entity, int size) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            Object displayName = entity.getType().toString().toLowerCase().replace("_", " ");
            displayName = ((String)displayName).substring(0, 1).toUpperCase() + ((String)displayName).substring(1);
            if (size > 1) {
                String formatted = this.displayFormat.replace("%amount%", String.valueOf(size)) + (String)displayName;
                String miniMessage = formatted.replace("\u00a70", "<black>").replace("\u00a71", "<dark_blue>").replace("\u00a72", "<dark_green>").replace("\u00a73", "<dark_aqua>").replace("\u00a74", "<dark_red>").replace("\u00a75", "<dark_purple>").replace("\u00a76", "<gold>").replace("\u00a77", "<gray>").replace("\u00a78", "<dark_gray>").replace("\u00a79", "<blue>").replace("\u00a7a", "<green>").replace("\u00a7b", "<aqua>").replace("\u00a7c", "<red>").replace("\u00a7d", "<light_purple>").replace("\u00a7e", "<yellow>").replace("\u00a7f", "<white>").replace("\u00a7l", "<bold>").replace("\u00a7m", "<strikethrough>").replace("\u00a7n", "<underline>").replace("\u00a7o", "<italic>").replace("\u00a7r", "<reset>").replace("&0", "<black>").replace("&1", "<dark_blue>").replace("&2", "<dark_green>").replace("&3", "<dark_aqua>").replace("&4", "<dark_red>").replace("&5", "<dark_purple>").replace("&6", "<gold>").replace("&7", "<gray>").replace("&8", "<dark_gray>").replace("&9", "<blue>").replace("&a", "<green>").replace("&b", "<aqua>").replace("&c", "<red>").replace("&d", "<light_purple>").replace("&e", "<yellow>").replace("&f", "<white>").replace("&l", "<bold>").replace("&m", "<strikethrough>").replace("&n", "<underline>").replace("&o", "<italic>").replace("&r", "<reset>");
                Component nameComponent = MiniMessage.miniMessage().deserialize((Object)miniMessage);
                entity.customName(nameComponent);
                livingEntity.setCustomNameVisible(true);
            } else {
                entity.customName(null);
                livingEntity.setCustomNameVisible(false);
            }
        } else if (entity instanceof Item) {
            Item item = (Item)entity;
            if (size > 1) {
                int totalItems = size * item.getItemStack().getAmount();
                Object itemName = item.getItemStack().getType().toString().toLowerCase().replace("_", " ");
                itemName = ((String)itemName).substring(0, 1).toUpperCase() + ((String)itemName).substring(1);
                String formatted = this.displayFormat.replace("%amount%", String.valueOf(totalItems)) + " " + (String)itemName;
                String miniMessage = formatted.replace("\u00a70", "<black>").replace("\u00a71", "<dark_blue>").replace("\u00a72", "<dark_green>").replace("\u00a73", "<dark_aqua>").replace("\u00a74", "<dark_red>").replace("\u00a75", "<dark_purple>").replace("\u00a76", "<gold>").replace("\u00a77", "<gray>").replace("\u00a78", "<dark_gray>").replace("\u00a79", "<blue>").replace("\u00a7a", "<green>").replace("\u00a7b", "<aqua>").replace("\u00a7c", "<red>").replace("\u00a7d", "<light_purple>").replace("\u00a7e", "<yellow>").replace("\u00a7f", "<white>").replace("\u00a7l", "<bold>").replace("\u00a7m", "<strikethrough>").replace("\u00a7n", "<underline>").replace("\u00a7o", "<italic>").replace("\u00a7r", "<reset>").replace("&0", "<black>").replace("&1", "<dark_blue>").replace("&2", "<dark_green>").replace("&3", "<dark_aqua>").replace("&4", "<dark_red>").replace("&5", "<dark_purple>").replace("&6", "<gold>").replace("&7", "<gray>").replace("&8", "<dark_gray>").replace("&9", "<blue>").replace("&a", "<green>").replace("&b", "<aqua>").replace("&c", "<red>").replace("&d", "<light_purple>").replace("&e", "<yellow>").replace("&f", "<white>").replace("&l", "<bold>").replace("&m", "<strikethrough>").replace("&n", "<underline>").replace("&o", "<italic>").replace("&r", "<reset>");
                Component nameComponent = MiniMessage.miniMessage().deserialize((Object)miniMessage);
                item.customName(nameComponent);
                item.setCustomNameVisible(true);
            } else {
                item.customName(null);
                item.setCustomNameVisible(false);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onItemSpawn(ItemSpawnEvent event) {
        Item newItem;
        if (this.enabled && this.stackableItems.contains((newItem = event.getEntity()).getItemStack().getType())) {
            this.setStackSize((Entity)newItem, 1);
            this.setEntitySpawnTime((Entity)newItem, System.currentTimeMillis());
            if (this.debugMode) {
                this.plugin.getLogger().info("New item spawned: " + String.valueOf(newItem.getItemStack().getType()) + " x" + newItem.getItemStack().getAmount() + ", initialized stack size to 1");
            }
            Location location = newItem.getLocation();
            Bukkit.getRegionScheduler().runDelayed((Plugin)this.plugin, location.getWorld(), location.getBlockX() >> 4, location.getBlockZ() >> 4, task -> {
                if (newItem.isValid()) {
                    Item targetStack = null;
                    long oldestSpawnTime = Long.MAX_VALUE;
                    for (Entity entity : newItem.getNearbyEntities(this.stackingRange, this.stackingRange, this.stackingRange)) {
                        long otherSpawnTime;
                        int otherStackSize;
                        Item otherItem;
                        if (!(entity instanceof Item) || entity == newItem || entity.isDead() || !(otherItem = (Item)entity).getItemStack().isSimilar(newItem.getItemStack()) || (otherStackSize = this.getStackSize((Entity)otherItem)) >= this.maxItemStackSize || (otherSpawnTime = this.getEntitySpawnTime((Entity)otherItem)) >= oldestSpawnTime) continue;
                        targetStack = otherItem;
                        oldestSpawnTime = otherSpawnTime;
                    }
                    if (targetStack != null && this.stack((Entity)targetStack, (Entity)newItem) && this.debugMode) {
                        this.plugin.getLogger().info(() -> "EntityStacker: Successfully stacked new item " + String.valueOf(newItem.getItemStack().getType()) + " into oldest existing stack");
                    }
                }
            }, 5L);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntitySpawn(CreatureSpawnEvent event) {
        if (this.enabled) {
            LivingEntity entity = event.getEntity();
            if (this.debugMode) {
                this.plugin.getLogger().info(() -> this.lambda$onEntitySpawn$6((Entity)entity));
            }
            if (this.stackableEntities.contains(entity.getType())) {
                this.setStackSize((Entity)entity, 1);
                this.setEntitySpawnTime((Entity)entity, System.currentTimeMillis());
                if (this.debugMode) {
                    this.plugin.getLogger().info(() -> EntityStacker.lambda$onEntitySpawn$7((Entity)entity));
                }
                Location location = entity.getLocation();
                Bukkit.getRegionScheduler().runDelayed((Plugin)this.plugin, location.getWorld(), location.getBlockX() >> 4, location.getBlockZ() >> 4, arg_0 -> this.lambda$onEntitySpawn$14((Entity)entity, event, arg_0), 10L);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDeath(EntityDeathEvent event) {
        if (this.enabled) {
            LivingEntity entity = event.getEntity();
            int stackSize = this.getStackSize((Entity)entity);
            long now = System.currentTimeMillis();
            Long last = this.recentDeaths.get(entity.getUniqueId());
            if (last != null && now - last < 250L) {
                if (this.debugMode) {
                    this.plugin.getLogger().info(() -> "EntityStacker: Skipping duplicate death event for " + String.valueOf(entity.getType()));
                }
            } else {
                this.recentDeaths.put(entity.getUniqueId(), now);
                if (this.debugMode) {
                    this.plugin.getLogger().info(() -> "EntityStacker: Death event for master " + String.valueOf(entity.getType()) + " with stack size " + stackSize + ", single kill: " + this.singleKill);
                }
                if (stackSize > 1) {
                    if (this.singleKill) {
                        int newStackSize = stackSize - 1;
                        event.setCancelled(true);
                        this.setStackSize((Entity)entity, newStackSize);
                        this.updateDisplayName((Entity)entity, newStackSize);
                        entity.setHealth(entity.getMaxHealth());
                        entity.setNoDamageTicks(10);
                        entity.setFireTicks(0);
                        List drops = event.getDrops();
                        for (ItemStack drop : drops) {
                            entity.getWorld().dropItemNaturally(entity.getLocation(), drop.clone());
                        }
                        int xpToDrop = event.getDroppedExp();
                        if (xpToDrop > 0 && entity.getKiller() != null) {
                            entity.getWorld().spawn(entity.getLocation(), ExperienceOrb.class, orb -> orb.setExperience(xpToDrop));
                        }
                        if (this.debugMode) {
                            this.plugin.getLogger().info(() -> "EntityStacker: Single kill - reduced " + String.valueOf(entity.getType()) + " stack from " + stackSize + " to " + newStackSize);
                        }
                        return;
                    }
                    List drops = event.getDrops();
                    ArrayList originalDrops = new ArrayList(drops);
                    drops.clear();
                    for (int i = 0; i < stackSize - 1; ++i) {
                        for (ItemStack drop : originalDrops) {
                            ItemStack dropCopy = drop.clone();
                            entity.getWorld().dropItemNaturally(entity.getLocation(), dropCopy);
                        }
                    }
                    drops.addAll(originalDrops);
                    event.setDroppedExp(event.getDroppedExp() * stackSize);
                    if (this.debugMode) {
                        this.plugin.getLogger().info(() -> "EntityStacker: Full stack kill - killed entire stack of " + stackSize + " " + String.valueOf(entity.getType()) + " entities");
                    }
                }
            }
        }
    }

    public int getStackedItemsCount() {
        int count = 0;
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (!(entity instanceof Item) || this.getStackSize(entity) <= 1) continue;
                ++count;
            }
        }
        return count;
    }

    public int getStackedEntitiesCount() {
        int count = 0;
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (!(entity instanceof LivingEntity) || entity instanceof Player || this.getStackSize(entity) <= 1) continue;
                ++count;
            }
        }
        return count;
    }

    public int stackEntitiesInRadius(Location location, int radius) {
        if (!this.enabled) {
            return 0;
        }
        int[] stacksCreated = new int[]{0};
        World world = location.getWorld();
        Collection nearbyEntities = world.getNearbyEntities(location, (double)radius, (double)radius, (double)radius);
        HashMap<EntityType, List> entityGroups = new HashMap<EntityType, List>();
        for (Entity entity : nearbyEntities) {
            if (!this.isStackable(entity)) continue;
            entityGroups.computeIfAbsent(entity.getType(), k -> new ArrayList()).add(entity);
        }
        for (List entities : entityGroups.values()) {
            if (entities.size() < 2) continue;
            entities.sort((e1, e2) -> Integer.compare(this.getStackSize((Entity)e2), this.getStackSize((Entity)e1)));
            Entity baseEntity = (Entity)entities.get(0);
            for (int i = 1; i < entities.size(); ++i) {
                if (!this.stack(baseEntity, (Entity)entities.get(i))) continue;
                stacksCreated[0] = stacksCreated[0] + 1;
            }
        }
        return stacksCreated[0];
    }

    public int getMaxStacksPerChunk() {
        return this.maxStacksPerChunk;
    }

    public String getDebugInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("\u00a76Entity Stacker Debug Information:\n");
        sb.append("\u00a7eEnabled: ").append(this.enabled).append("\n");
        sb.append("\u00a7eStacking Range: ").append(this.stackingRange).append(" blocks\n");
        sb.append("\u00a7eStackable Entities (").append(this.stackableEntities.size()).append("): ");
        if (this.stackableEntities.isEmpty()) {
            sb.append("\u00a7cNONE - This is why nothing stacks!");
        } else {
            sb.append("\u00a7a").append(this.stackableEntities.toString());
        }
        sb.append("\n\u00a7eStackable Items (").append(this.stackableItems.size()).append("): ");
        if (this.stackableItems.isEmpty()) {
            sb.append("\u00a77None");
        } else {
            sb.append("\u00a7a").append(this.stackableItems.toString());
        }
        sb.append("\n\u00a7eMax Stack Sizes: Items=").append(this.maxItemStackSize).append(", Mobs=").append(this.maxMobStackSize).append(", Spawners=").append(this.maxSpawnerStackSize);
        return sb.toString();
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        if (this.enabled) {
            Item item = event.getItem();
            int stackSize = this.getStackSize((Entity)item);
            if (stackSize <= 0) {
                stackSize = 1;
            }
            if (stackSize > 1) {
                event.setCancelled(true);
                Player player = event.getPlayer();
                ItemStack pickedItem = item.getItemStack().clone();
                int itemAmount = pickedItem.getAmount();
                int totalItems = stackSize * itemAmount;
                int maxSingleStackSize = pickedItem.getMaxStackSize();
                int fullStacks = totalItems / maxSingleStackSize;
                int remainder = totalItems % maxSingleStackSize;
                if (this.debugMode) {
                    this.plugin.getLogger().info("Player " + player.getName() + " picking up stacked item: " + stackSize + " entities with " + itemAmount + " items each = " + totalItems + " total items (" + fullStacks + " full stacks + " + remainder + " remainder)");
                }
                for (int i = 0; i < fullStacks; ++i) {
                    ItemStack stack = pickedItem.clone();
                    stack.setAmount(maxSingleStackSize);
                    HashMap leftover = player.getInventory().addItem(new ItemStack[]{stack});
                    if (leftover.isEmpty()) continue;
                    for (ItemStack left : leftover.values()) {
                        Item droppedItem = player.getWorld().dropItem(player.getLocation(), left);
                        this.setStackSize((Entity)droppedItem, 1);
                        droppedItem.setPickupDelay(0);
                    }
                }
                if (remainder > 0) {
                    ItemStack stack = pickedItem.clone();
                    stack.setAmount(remainder);
                    HashMap leftover = player.getInventory().addItem(new ItemStack[]{stack});
                    if (!leftover.isEmpty()) {
                        for (ItemStack left : leftover.values()) {
                            Item droppedItem = player.getWorld().dropItem(player.getLocation(), left);
                            this.setStackSize((Entity)droppedItem, 1);
                            droppedItem.setPickupDelay(0);
                        }
                    }
                }
                player.playSound(player.getLocation(), Sound.ENTITY_ITEM_PICKUP, 0.2f, 1.0f);
                item.remove();
            }
        }
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public double getStackRadius() {
        return this.stackingRange;
    }

    public int getMaxStackSize() {
        return Math.max(this.maxItemStackSize, this.maxMobStackSize);
    }

    public boolean isAutoStackEnabled() {
        return this.enabled;
    }

    public int stackEntitiesInWorld(World world) {
        if (!this.enabled || world == null) {
            return 0;
        }
        int totalStacked = 0;
        for (Chunk chunk : world.getLoadedChunks()) {
            totalStacked += this.stackEntitiesInChunk(chunk);
        }
        return totalStacked;
    }

    public int unstackEntitiesInWorld(World world) {
        if (!this.enabled || world == null) {
            return 0;
        }
        int totalUnstacked = 0;
        for (Chunk chunk : world.getLoadedChunks()) {
            for (Entity entity : chunk.getEntities()) {
                if (!this.isStackable(entity) || this.getStackSize(entity) <= 1) continue;
                int stackSize = this.getStackSize(entity);
                this.unstackEntity(entity);
                totalUnstacked += stackSize;
            }
        }
        return totalUnstacked;
    }

    public int getTotalStacks() {
        int totalStacks = 0;
        for (World world : Bukkit.getWorlds()) {
            for (Chunk chunk : world.getLoadedChunks()) {
                for (Entity entity : chunk.getEntities()) {
                    if (!this.isStackable(entity) || this.getStackSize(entity) <= 1) continue;
                    ++totalStacks;
                }
            }
        }
        return totalStacks;
    }

    private int stackEntitiesInChunk(Chunk chunk) {
        int stacked = 0;
        for (Entity entity : chunk.getEntities()) {
            if (!this.isStackable(entity)) continue;
            stacked += this.tryStackEntity(entity);
        }
        return stacked;
    }

    private int tryStackEntity(Entity entity) {
        if (!this.isStackable(entity)) {
            return 0;
        }
        Collection nearby = entity.getLocation().getWorld().getNearbyEntities(entity.getLocation(), this.stackingRange, this.stackingRange, this.stackingRange);
        for (Entity nearbyEntity : nearby) {
            int maxStack;
            int nearbyStack;
            int entityStack;
            if (nearbyEntity == entity || !this.canStackTogether(entity, nearbyEntity) || (entityStack = this.getStackSize(entity)) + (nearbyStack = this.getStackSize(nearbyEntity)) > (maxStack = entity instanceof Item ? this.maxItemStackSize : this.maxMobStackSize)) continue;
            this.setStackSize(entity, entityStack + nearbyStack);
            nearbyEntity.remove();
            return nearbyStack;
        }
        return 0;
    }

    private void unstackEntity(Entity entity) {
        if (!this.isStackable(entity)) {
            return;
        }
        int stackSize = this.getStackSize(entity);
        if (stackSize <= 1) {
            return;
        }
        Location loc = entity.getLocation();
        for (int i = 1; i < stackSize; ++i) {
            Entity newEntity = loc.getWorld().spawnEntity(loc, entity.getType());
            this.setStackSize(newEntity, 1);
        }
        this.setStackSize(entity, 1);
    }

    private boolean canStackTogether(Entity entity1, Entity entity2) {
        if (!this.isStackable(entity1) || !this.isStackable(entity2)) {
            return false;
        }
        if (entity1.getType() != entity2.getType()) {
            return false;
        }
        if (entity1 instanceof Item && entity2 instanceof Item) {
            Item item1 = (Item)entity1;
            Item item2 = (Item)entity2;
            return item1.getItemStack().isSimilar(item2.getItemStack());
        }
        return entity1 instanceof LivingEntity && entity2 instanceof LivingEntity;
    }

    private /* synthetic */ void lambda$onEntitySpawn$14(Entity entity, CreatureSpawnEvent event, ScheduledTask task) {
        if (entity.isValid()) {
            if (this.debugMode) {
                this.plugin.getLogger().info(() -> "EntityStacker: Attempting to stack " + String.valueOf(entity.getType()) + " (spawn reason: " + String.valueOf(event.getSpawnReason()) + ") with nearby entities");
            }
            Entity targetStack = null;
            long oldestSpawnTime = Long.MAX_VALUE;
            for (Entity nearby : entity.getNearbyEntities(this.stackingRange, this.stackingRange, this.stackingRange)) {
                int maxStackSize;
                int nearbyStackSize;
                if (nearby.getType() != entity.getType() || nearby == entity || nearby.isDead() || (nearbyStackSize = this.getStackSize(nearby)) >= (maxStackSize = nearby instanceof Item ? this.maxItemStackSize : this.maxMobStackSize)) continue;
                long nearbySpawnTime = this.getEntitySpawnTime(nearby);
                boolean nearbyIsMaster = this.isStackMaster(nearby);
                boolean targetIsMaster = targetStack != null ? this.isStackMaster(targetStack) : false;
                boolean shouldReplace = false;
                if (nearbyIsMaster && !targetIsMaster) {
                    shouldReplace = true;
                } else if (nearbyIsMaster == targetIsMaster) {
                    boolean bl = shouldReplace = nearbySpawnTime < oldestSpawnTime;
                }
                if (!shouldReplace) continue;
                targetStack = nearby;
                oldestSpawnTime = nearbySpawnTime;
            }
            if (targetStack != null) {
                if (this.stack(targetStack, entity)) {
                    if (this.debugMode) {
                        this.plugin.getLogger().info(() -> "EntityStacker: Successfully stacked new " + String.valueOf(entity.getType()) + " into existing stack");
                    }
                } else {
                    chunk = entity.getLocation().getChunk();
                    int currentStacks = this.countStacksInChunk(chunk, entity.getType());
                    if (currentStacks >= this.maxStacksPerChunk) {
                        if (this.debugMode) {
                            this.plugin.getLogger().info(() -> "EntityStacker: Removing " + String.valueOf(entity.getType()) + " - chunk at max stacks (" + this.maxStacksPerChunk + ")");
                        }
                        entity.remove();
                    } else if (this.debugMode) {
                        this.plugin.getLogger().info(() -> "EntityStacker: Keeping " + String.valueOf(entity.getType()) + " as new stack (" + currentStacks + "/" + this.maxStacksPerChunk + " stacks in chunk)");
                    }
                }
            } else {
                chunk = entity.getLocation().getChunk();
                int currentStacks = this.countStacksInChunk(chunk, entity.getType());
                if (currentStacks > this.maxStacksPerChunk) {
                    if (this.debugMode) {
                        this.plugin.getLogger().info(() -> "EntityStacker: Removing " + String.valueOf(entity.getType()) + " - chunk at max stacks (" + this.maxStacksPerChunk + ")");
                    }
                    entity.remove();
                } else if (this.debugMode) {
                    this.plugin.getLogger().info(() -> "EntityStacker: No nearby entities to stack with for " + String.valueOf(entity.getType()) + " - keeping as new stack");
                }
            }
        }
    }

    private static /* synthetic */ String lambda$onEntitySpawn$7(Entity entity) {
        return "EntityStacker: Set initial stack size for " + String.valueOf(entity.getType()) + " at " + String.valueOf(entity.getLocation());
    }

    private /* synthetic */ String lambda$onEntitySpawn$6(Entity entity) {
        return "EntityStacker: Entity spawn event - " + String.valueOf(entity.getType()) + ", stackable: " + this.stackableEntities.contains(entity.getType());
    }
}

