/*
 * Decompiled with CFR 0.152.
 */
package com.seristic.lagx.utils;

import com.seristic.lagx.main.LagX;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;

public class MapArtManager {
    private final LagX plugin;
    private final File configFile;
    private FileConfiguration config;
    private final Map<Integer, String> protectedMaps = new HashMap<Integer, String>();
    private ScheduledTask autoProtectionTask;
    private boolean autoProtectionEnabled = true;
    private int scanIntervalMinutes = 5;
    private boolean protectAllMaps = false;
    private boolean requirePlayerPermission = true;

    public MapArtManager(LagX plugin) {
        this.plugin = plugin;
        this.configFile = new File(plugin.getDataFolder(), "protected-maps.yml");
        this.loadConfig();
        this.startAutoProtectionTask();
    }

    private void loadConfig() {
        if (!this.configFile.exists()) {
            this.plugin.getDataFolder().mkdirs();
            try {
                this.configFile.createNewFile();
                this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
                this.setDefaultConfig();
                this.saveConfig();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create protected-maps.yml: " + e.getMessage());
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.loadSettings();
        this.loadProtectedMaps();
    }

    private void setDefaultConfig() {
        this.config.addDefault("auto-protection.enabled", (Object)this.autoProtectionEnabled);
        this.config.addDefault("auto-protection.scan-interval-minutes", (Object)this.scanIntervalMinutes);
        this.config.addDefault("auto-protection.protect-all-maps", (Object)this.protectAllMaps);
        this.config.addDefault("auto-protection.require-player-permission", (Object)this.requirePlayerPermission);
        this.config.options().copyDefaults(true);
    }

    private void loadSettings() {
        this.autoProtectionEnabled = this.config.getBoolean("auto-protection.enabled", true);
        this.scanIntervalMinutes = this.config.getInt("auto-protection.scan-interval-minutes", 5);
        this.protectAllMaps = this.config.getBoolean("auto-protection.protect-all-maps", false);
        this.requirePlayerPermission = this.config.getBoolean("auto-protection.require-player-permission", true);
    }

    private void loadProtectedMaps() {
        this.protectedMaps.clear();
        if (this.config.contains("protected-maps")) {
            for (String mapIdStr : this.config.getConfigurationSection("protected-maps").getKeys(false)) {
                try {
                    int mapId = Integer.parseInt(mapIdStr);
                    String owner = this.config.getString("protected-maps." + mapIdStr + ".owner", "Unknown");
                    this.protectedMaps.put(mapId, owner);
                }
                catch (NumberFormatException e) {
                    this.plugin.getLogger().warning("Invalid map ID in config: " + mapIdStr);
                }
            }
        }
        this.plugin.getLogger().info("Loaded " + this.protectedMaps.size() + " protected maps");
    }

    private void saveConfig() {
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save protected-maps.yml: " + e.getMessage());
        }
    }

    public void protectMap(int mapId, String owner) {
        this.protectedMaps.put(mapId, owner);
        this.config.set("protected-maps." + mapId + ".owner", (Object)owner);
        this.config.set("protected-maps." + mapId + ".protected-at", (Object)System.currentTimeMillis());
        this.saveConfig();
    }

    public void unprotectMap(int mapId) {
        this.protectedMaps.remove(mapId);
        this.config.set("protected-maps." + mapId, null);
        this.saveConfig();
    }

    public boolean isMapProtected(int mapId) {
        return this.protectedMaps.containsKey(mapId);
    }

    public String getMapOwner(int mapId) {
        return this.protectedMaps.get(mapId);
    }

    public Map<Integer, String> getProtectedMaps() {
        return new HashMap<Integer, String>(this.protectedMaps);
    }

    public Set<Integer> getProtectedMapIds() {
        return this.protectedMaps.keySet();
    }

    public void reload() {
        this.loadConfig();
        this.restartAutoProtectionTask();
    }

    private void startAutoProtectionTask() {
        if (this.autoProtectionTask != null) {
            this.autoProtectionTask.cancel();
        }
        if (this.autoProtectionEnabled && this.scanIntervalMinutes > 0) {
            long intervalSeconds = (long)this.scanIntervalMinutes * 60L;
            this.autoProtectionTask = Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)this.plugin, task -> this.scanAndProtectMaps(), intervalSeconds * 20L, intervalSeconds * 20L);
            this.plugin.getLogger().info("Started automatic map protection task (interval: " + this.scanIntervalMinutes + " minutes)");
        }
    }

    public void stopAutoProtectionTask() {
        if (this.autoProtectionTask != null) {
            this.autoProtectionTask.cancel();
            this.autoProtectionTask = null;
            this.plugin.getLogger().info("Stopped automatic map protection task");
        }
    }

    private void restartAutoProtectionTask() {
        this.stopAutoProtectionTask();
        this.startAutoProtectionTask();
    }

    private void scanAndProtectMaps() {
        if (!this.autoProtectionEnabled) {
            return;
        }
        int newlyProtected = 0;
        for (World world : Bukkit.getWorlds()) {
            for (Player player : world.getPlayers()) {
                if (this.requirePlayerPermission && !player.hasPermission("lagx.mapart.autoprotect")) continue;
                for (ItemStack item : player.getInventory().getContents()) {
                    int mapId;
                    MapMeta mapMeta;
                    MapView mapView;
                    if (item == null || !item.hasItemMeta() || !(item.getItemMeta() instanceof MapMeta) || (mapView = (mapMeta = (MapMeta)item.getItemMeta()).getMapView()) == null || this.isMapProtected(mapId = mapView.getId()) || !this.protectAllMaps && !this.shouldAutoProtectMap(mapView)) continue;
                    this.protectMap(mapId, player.getName());
                    ++newlyProtected;
                    if (!player.hasPermission("lagx.mapart.notify")) continue;
                    player.sendMessage("\u00a7aYour map art (ID: " + mapId + ") has been automatically protected!");
                }
            }
        }
        if (newlyProtected > 0) {
            this.plugin.getLogger().info("Auto-protected " + newlyProtected + " new maps");
        }
    }

    private boolean shouldAutoProtectMap(MapView mapView) {
        return mapView != null;
    }

    public void setAutoProtectionEnabled(boolean enabled) {
        this.autoProtectionEnabled = enabled;
        this.config.set("auto-protection.enabled", (Object)enabled);
        this.saveConfig();
        if (enabled) {
            this.startAutoProtectionTask();
            this.plugin.getLogger().info("Automatic map protection enabled");
        } else {
            this.stopAutoProtectionTask();
            this.plugin.getLogger().info("Automatic map protection disabled");
        }
    }

    public boolean isAutoProtectionEnabled() {
        return this.autoProtectionEnabled;
    }

    public void setScanInterval(int minutes) {
        if (minutes < 1) {
            throw new IllegalArgumentException("Scan interval must be at least 1 minute");
        }
        this.scanIntervalMinutes = minutes;
        this.config.set("auto-protection.scan-interval-minutes", (Object)minutes);
        this.saveConfig();
        this.restartAutoProtectionTask();
        this.plugin.getLogger().info("Map protection scan interval set to " + minutes + " minutes");
    }

    public int getScanInterval() {
        return this.scanIntervalMinutes;
    }

    public void setProtectAllMaps(boolean protectAll) {
        this.protectAllMaps = protectAll;
        this.config.set("auto-protection.protect-all-maps", (Object)protectAll);
        this.saveConfig();
    }

    public boolean isProtectingAllMaps() {
        return this.protectAllMaps;
    }

    public void reloadConfig() {
        this.loadConfig();
        this.plugin.getLogger().info("Map art manager configuration reloaded");
    }

    public void shutdown() {
        this.stopAutoProtectionTask();
    }
}

