/*
 * Decompiled with CFR 0.152.
 */
package com.seristic.lagx.commands;

import com.seristic.lagx.api.proto.LRProtocolResult;
import com.seristic.lagx.api.proto.Protocol;
import com.seristic.lagx.commands.LagXCommand;
import com.seristic.lagx.inf.Help;
import com.seristic.lagx.main.LagX;
import com.seristic.lagx.proto.bin.CCEntities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class ClearCommand
extends LagXCommand {
    public ClearCommand(LagX plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        if (args.length < 2) {
            Help.sendMsg(sender, "\u00a7cUsage: " + this.getUsage(), true);
            return true;
        }
        String target = args[1].toLowerCase();
        try {
            if (target.equals("items") || target.equals("i")) {
                this.clearItems(sender, args);
            } else if (target.equals("entities") || target.equals("e")) {
                this.clearEntities(sender, args);
            } else if (target.equals("all")) {
                this.clearAll(sender, args);
            } else if (target.equals("area") || target.equals("a")) {
                this.clearArea(sender, args);
            } else {
                EntityType entityType = this.parseEntityType(target);
                if (entityType != null) {
                    this.clearEntityType(sender, entityType, args);
                } else {
                    Help.sendMsg(sender, "\u00a7cUsage: " + this.getUsage(), true);
                }
            }
        }
        catch (Exception e) {
            Help.sendMsg(sender, "\u00a7cError executing clear command: " + e.getMessage(), true);
            this.plugin.getLogger().warning("Clear command error: " + e.getMessage());
        }
        return true;
    }

    private void clearItems(CommandSender sender, String[] args) {
        World targetWorld = null;
        if (args.length > 2) {
            targetWorld = Bukkit.getWorld((String)args[2]);
            if (targetWorld == null) {
                Help.sendMsg(sender, "\u00a7cWorld '" + args[2] + "' not found!", true);
                return;
            }
        } else if (sender instanceof Player) {
            targetWorld = ((Player)sender).getWorld();
        }
        try {
            LRProtocolResult result = targetWorld != null ? Protocol.run("cc_items", new Object[]{false, targetWorld}) : Protocol.run("cc_items", new Object[]{false});
            if (result != null && result.getData().length > 0) {
                int cleared = (Integer)result.getData()[0];
                String worldMsg = targetWorld != null ? " in world " + targetWorld.getName() : " across all worlds";
                Help.sendMsg(sender, "\u00a7aCleared " + cleared + " items" + worldMsg + "!", true);
            } else {
                Help.sendMsg(sender, "\u00a7eNo items found to clear.", true);
            }
        }
        catch (Exception e) {
            Help.sendMsg(sender, "\u00a7cError clearing items: " + e.getMessage(), true);
        }
    }

    private void clearEntities(CommandSender sender, String[] args) {
        World targetWorld = null;
        EntityType[] entityTypes = null;
        if (args.length > 2) {
            String arg = args[2];
            if (arg.equalsIgnoreCase("hostile")) {
                entityTypes = CCEntities.hostile;
            } else if (arg.equalsIgnoreCase("peaceful")) {
                entityTypes = CCEntities.peaceful;
            } else {
                targetWorld = Bukkit.getWorld((String)arg);
                if (targetWorld == null) {
                    Help.sendMsg(sender, "\u00a7cWorld '" + arg + "' not found!", true);
                    return;
                }
            }
        }
        if (targetWorld == null && sender instanceof Player) {
            targetWorld = ((Player)sender).getWorld();
        }
        try {
            LRProtocolResult result = targetWorld != null ? Protocol.run("cc_entities", new Object[]{false, entityTypes, targetWorld}) : Protocol.run("cc_entities", new Object[]{false, entityTypes});
            if (result != null && result.getData().length > 0) {
                int cleared = (Integer)result.getData()[0];
                String typeMsg = entityTypes == CCEntities.hostile ? " hostile" : (entityTypes == CCEntities.peaceful ? " peaceful" : "");
                String worldMsg = targetWorld != null ? " in world " + targetWorld.getName() : " across all worlds";
                Help.sendMsg(sender, "\u00a7aCleared " + cleared + typeMsg + " entities" + worldMsg + "!", true);
            } else {
                Help.sendMsg(sender, "\u00a7eNo entities found to clear.", true);
            }
        }
        catch (Exception e) {
            Help.sendMsg(sender, "\u00a7cError clearing entities: " + e.getMessage(), true);
        }
    }

    private void clearEntityType(CommandSender sender, EntityType entityType, String[] args) {
        World targetWorld = null;
        if (args.length > 2 && (targetWorld = Bukkit.getWorld((String)args[2])) == null) {
            Help.sendMsg(sender, "\u00a7cWorld '" + args[2] + "' not found!", true);
            return;
        }
        try {
            EntityType[] types = new EntityType[]{entityType};
            LRProtocolResult result = targetWorld != null ? Protocol.run("cc_entities", new Object[]{false, types, targetWorld}) : Protocol.run("cc_entities", new Object[]{false, types, true});
            if (result != null && result.getData().length > 0) {
                int cleared = (Integer)result.getData()[0];
                String worldMsg = targetWorld != null ? " in world " + targetWorld.getName() : " across all worlds";
                Help.sendMsg(sender, "\u00a7aCleared " + cleared + " " + entityType.name().toLowerCase() + " entities" + worldMsg + "!", true);
            } else {
                Help.sendMsg(sender, "\u00a7eNo " + entityType.name().toLowerCase() + " entities found to clear.", true);
            }
        }
        catch (Exception e) {
            Help.sendMsg(sender, "\u00a7cError clearing " + entityType.name().toLowerCase() + " entities: " + e.getMessage(), true);
        }
    }

    private void clearAll(CommandSender sender, String[] args) {
        World targetWorld = null;
        if (args.length > 2 && (targetWorld = Bukkit.getWorld((String)args[2])) == null) {
            Help.sendMsg(sender, "\u00a7cWorld '" + args[2] + "' not found!", true);
            return;
        }
        try {
            LRProtocolResult itemResult = targetWorld != null ? Protocol.run("cc_items", new Object[]{false, targetWorld}) : Protocol.run("cc_items", new Object[]{false});
            LRProtocolResult entityResult = targetWorld != null ? Protocol.run("cc_entities", new Object[]{false, null, targetWorld}) : Protocol.run("cc_entities", new Object[]{false, null, true});
            int clearedItems = itemResult != null && itemResult.getData().length > 0 ? (Integer)itemResult.getData()[0] : 0;
            int clearedEntities = entityResult != null && entityResult.getData().length > 0 ? (Integer)entityResult.getData()[0] : 0;
            String worldMsg = targetWorld != null ? " in world " + targetWorld.getName() : " across all worlds";
            Help.sendMsg(sender, "\u00a7aCleared " + clearedItems + " items and " + clearedEntities + " entities" + worldMsg + "!", true);
        }
        catch (Exception e) {
            Help.sendMsg(sender, "\u00a7cError clearing all: " + e.getMessage(), true);
        }
    }

    private void clearArea(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            Help.sendMsg(sender, "\u00a7cOnly players can use area clearing!", true);
            return;
        }
        Player player = (Player)sender;
        Chunk chunk = player.getLocation().getChunk();
        try {
            LRProtocolResult itemResult = Protocol.run("cc_items", new Object[]{false, chunk});
            LRProtocolResult entityResult = Protocol.run("cc_entities", new Object[]{false, null, chunk});
            int clearedItems = itemResult != null && itemResult.getData().length > 0 ? (Integer)itemResult.getData()[0] : 0;
            int clearedEntities = entityResult != null && entityResult.getData().length > 0 ? (Integer)entityResult.getData()[0] : 0;
            Help.sendMsg(sender, "\u00a7aCleared " + clearedItems + " items and " + clearedEntities + " entities from your current chunk!", true);
        }
        catch (Exception e) {
            Help.sendMsg(sender, "\u00a7cError clearing area: " + e.getMessage(), true);
        }
    }

    private EntityType parseEntityType(String name) {
        try {
            return EntityType.valueOf((String)name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            switch (name.toLowerCase()) {
                case "zombie": 
                case "zombies": {
                    return EntityType.ZOMBIE;
                }
                case "skeleton": 
                case "skeletons": {
                    return EntityType.SKELETON;
                }
                case "creeper": 
                case "creepers": {
                    return EntityType.CREEPER;
                }
                case "spider": 
                case "spiders": {
                    return EntityType.SPIDER;
                }
                case "cow": 
                case "cows": {
                    return EntityType.COW;
                }
                case "pig": 
                case "pigs": {
                    return EntityType.PIG;
                }
                case "chicken": 
                case "chickens": {
                    return EntityType.CHICKEN;
                }
                case "sheep": {
                    return EntityType.SHEEP;
                }
                case "villager": 
                case "villagers": {
                    return EntityType.VILLAGER;
                }
            }
            return null;
        }
    }

    @Override
    public String getPermission() {
        return "lagx.clear";
    }

    @Override
    public String getUsage() {
        return "/lagx clear <items(i)|entities(e)|all|area(a)|<entity_type>> [world]";
    }

    @Override
    public String getDescription() {
        return "Clear items, entities, or both from worlds/areas";
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 2) {
            String partial = args[1].toLowerCase();
            List<String> options = Arrays.asList("items", "i", "entities", "e", "all", "area", "a");
            for (String option : options) {
                if (!option.startsWith(partial)) continue;
                completions.add(option);
            }
            List<String> entityTypes = Arrays.asList("zombie", "skeleton", "creeper", "spider", "enderman", "cow", "pig", "sheep", "chicken", "villager", "item_frame", "armor_stand");
            for (String type : entityTypes) {
                if (!type.startsWith(partial)) continue;
                completions.add(type);
            }
        } else if (args.length == 3) {
            String subCmd = args[1].toLowerCase();
            String partial = args[2].toLowerCase();
            switch (subCmd) {
                case "items": 
                case "i": 
                case "all": {
                    for (World world : Bukkit.getWorlds()) {
                        if (!world.getName().toLowerCase().startsWith(partial)) continue;
                        completions.add(world.getName());
                    }
                    break;
                }
                case "entities": 
                case "e": {
                    if ("hostile".startsWith(partial)) {
                        completions.add("hostile");
                    }
                    if ("peaceful".startsWith(partial)) {
                        completions.add("peaceful");
                    }
                    for (World world : Bukkit.getWorlds()) {
                        if (!world.getName().toLowerCase().startsWith(partial)) continue;
                        completions.add(world.getName());
                    }
                    break;
                }
                case "area": 
                case "a": {
                    break;
                }
                default: {
                    if (this.parseEntityType(subCmd) != null) {
                        for (World world : Bukkit.getWorlds()) {
                            if (!world.getName().toLowerCase().startsWith(partial)) continue;
                            completions.add(world.getName());
                        }
                    }
                    break;
                }
            }
        }
        return completions;
    }
}

