/*
 * Decompiled with CFR 0.152.
 */
package com.seristic.lagx.commands;

import com.seristic.lagx.commands.LagXCommand;
import com.seristic.lagx.inf.Help;
import com.seristic.lagx.main.LagX;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.CommandSender;

public class PresetCommand
extends LagXCommand {
    public PresetCommand(LagX plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        String subCommand;
        if (this.plugin.getEntityLimiter() == null) {
            Help.sendMsg(sender, "\u00a7cEntity Limiter is not enabled on this server.", true);
            return true;
        }
        if (args.length < 2) {
            Help.sendMsg(sender, "\u00a7cUsage: /lagx preset [info|set]", true);
            return true;
        }
        switch (subCommand = args[1].toLowerCase()) {
            case "info": 
            case "i": {
                Help.sendMsg(sender, "\u00a76Entity Limiter Preset Information:", true);
                Help.sendMsg(sender, this.plugin.getEntityLimiter().getStatus(), false);
                return true;
            }
            case "set": 
            case "s": {
                if (args.length < 3) {
                    Help.sendMsg(sender, "\u00a7cUsage: /lagx preset set <basic|advanced|custom>", true);
                    return true;
                }
                String presetType = args[2].toLowerCase();
                if (!(presetType.equals("basic") || presetType.equals("advanced") || presetType.equals("custom"))) {
                    Help.sendMsg(sender, "\u00a7cInvalid preset type. Use 'basic', 'advanced', or 'custom'.", true);
                    return true;
                }
                this.plugin.getConfig().set("entity_limiter.preset_mode", (Object)presetType);
                this.plugin.saveConfig();
                this.plugin.getEntityLimiter().reload();
                Help.sendMsg(sender, "\u00a7aEntity Limiter preset changed to \u00a7b" + presetType + "\u00a7a and configuration reloaded.", true);
                return true;
            }
        }
        Help.sendMsg(sender, "\u00a7cUnknown subcommand. Available options: info, set", true);
        return true;
    }

    @Override
    public String getPermission() {
        return "lagx.preset";
    }

    @Override
    public String getUsage() {
        return "/lagx preset [info|set]";
    }

    @Override
    public String getDescription() {
        return "Switch entity limiter presets";
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        if (args.length == 2) {
            return Arrays.asList("info", "set");
        }
        if (args.length == 3 && args[1].equalsIgnoreCase("set")) {
            return Arrays.asList("basic", "advanced", "custom");
        }
        return new ArrayList<String>();
    }
}

