/*
 * Decompiled with CFR 0.152.
 */
package com.seristic.lagx.commands;

import com.seristic.lagx.commands.LagXCommand;
import com.seristic.lagx.inf.Help;
import com.seristic.lagx.main.LagX;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.generator.WorldInfo;

public class UnloadCommand
extends LagXCommand {
    public UnloadCommand(LagX plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        String action;
        if (args.length < 2) {
            Help.sendMsg(sender, "\u00a7cUsage: " + this.getUsage(), true);
            return true;
        }
        switch (action = args[1].toLowerCase()) {
            case "chunks": {
                if (args.length >= 3) {
                    this.unloadChunksInWorld(sender, args[2]);
                    break;
                }
                this.unloadChunksInAllWorlds(sender);
                break;
            }
            case "unused": {
                this.unloadUnusedChunks(sender);
                break;
            }
            case "world": {
                if (args.length < 3) {
                    Help.sendMsg(sender, "\u00a7cUsage: /lagx unload world <world>", true);
                    return true;
                }
                this.unloadWorld(sender, args[2]);
                break;
            }
            default: {
                Help.sendMsg(sender, "\u00a7cUsage: " + this.getUsage(), true);
            }
        }
        return true;
    }

    private void unloadChunksInAllWorlds(CommandSender sender) {
        int totalUnloaded = 0;
        StringBuilder msg = new StringBuilder("\u00a76Unloading chunks in all worlds...\n");
        for (World world : Bukkit.getWorlds()) {
            int unloaded = this.unloadChunksInWorldInternal(world);
            totalUnloaded += unloaded;
            msg.append("\u00a77- \u00a7e").append(world.getName()).append("\u00a77: \u00a7f").append(unloaded).append(" chunks unloaded\n");
        }
        msg.append("\u00a76Total: \u00a7f").append(totalUnloaded).append(" chunks unloaded");
        Help.sendMsg(sender, msg.toString(), true);
    }

    private void unloadChunksInWorld(CommandSender sender, String worldName) {
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            Help.sendMsg(sender, "\u00a7cWorld '" + worldName + "' not found!", true);
            return;
        }
        int unloaded = this.unloadChunksInWorldInternal(world);
        Help.sendMsg(sender, "\u00a76Unloaded \u00a7f" + unloaded + " \u00a76chunks in world \u00a7e" + world.getName(), true);
    }

    private int unloadChunksInWorldInternal(World world) {
        Chunk[] loadedChunks = world.getLoadedChunks();
        int unloaded = 0;
        for (Chunk chunk : loadedChunks) {
            boolean hasNearbyPlayers = world.getPlayers().stream().anyMatch(player -> {
                Chunk playerChunk = player.getLocation().getChunk();
                int chunkX = chunk.getX();
                int chunkZ = chunk.getZ();
                int playerX = playerChunk.getX();
                int playerZ = playerChunk.getZ();
                return Math.abs(chunkX - playerX) <= 3 && Math.abs(chunkZ - playerZ) <= 3;
            });
            if (hasNearbyPlayers || !chunk.unload(true)) continue;
            ++unloaded;
        }
        return unloaded;
    }

    private void unloadUnusedChunks(CommandSender sender) {
        int totalUnloaded = 0;
        StringBuilder msg = new StringBuilder("\u00a76Unloading unused chunks...\n");
        for (World world : Bukkit.getWorlds()) {
            Chunk[] loadedChunks = world.getLoadedChunks();
            int worldUnloaded = 0;
            for (Chunk chunk : loadedChunks) {
                boolean isUnused = world.getPlayers().stream().noneMatch(player -> {
                    Chunk playerChunk = player.getLocation().getChunk();
                    return Math.abs(chunk.getX() - playerChunk.getX()) <= 5 && Math.abs(chunk.getZ() - playerChunk.getZ()) <= 5;
                });
                if (!isUnused || chunk.getEntities().length != 0 || !chunk.unload(true)) continue;
                ++worldUnloaded;
            }
            totalUnloaded += worldUnloaded;
            if (worldUnloaded <= 0) continue;
            msg.append("\u00a77- \u00a7e").append(world.getName()).append("\u00a77: \u00a7f").append(worldUnloaded).append(" unused chunks unloaded\n");
        }
        msg.append("\u00a76Total: \u00a7f").append(totalUnloaded).append(" unused chunks unloaded");
        Help.sendMsg(sender, msg.toString(), true);
    }

    private void unloadWorld(CommandSender sender, String worldName) {
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            Help.sendMsg(sender, "\u00a7cWorld '" + worldName + "' not found!", true);
            return;
        }
        if (world.getPlayers().size() > 0) {
            Help.sendMsg(sender, "\u00a7cCannot unload world '" + worldName + "' - players are still in it!", true);
            return;
        }
        if (Bukkit.unloadWorld((World)world, (boolean)true)) {
            Help.sendMsg(sender, "\u00a76Successfully unloaded world: \u00a7e" + worldName, true);
        } else {
            Help.sendMsg(sender, "\u00a7cFailed to unload world: \u00a7e" + worldName, true);
        }
    }

    @Override
    public String getPermission() {
        return "lagx.unload";
    }

    @Override
    public String getUsage() {
        return "/lagx unload <chunks|unused|world> [world]";
    }

    @Override
    public String getDescription() {
        return "Unload chunks or worlds to free memory";
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 2) {
            completions.addAll(Arrays.asList("chunks", "unused", "world"));
        } else if (args.length == 3 && (args[1].equalsIgnoreCase("chunks") || args[1].equalsIgnoreCase("world"))) {
            completions.addAll(Bukkit.getWorlds().stream().map(WorldInfo::getName).collect(Collectors.toList()));
        }
        return completions;
    }
}

