/*
 * Decompiled with CFR 0.152.
 */
package com.seristic.lagx.commands;

import com.seristic.lagx.commands.LagXCommand;
import com.seristic.lagx.inf.Help;
import com.seristic.lagx.main.LagX;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.generator.WorldInfo;

public class VillagersCommand
extends LagXCommand {
    public VillagersCommand(LagX plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        String subCommand;
        if (this.plugin.getVillagerOptimizer() == null) {
            Help.sendMsg(sender, "\u00a7cVillager Optimizer is not enabled on this server.", true);
            return true;
        }
        if (args.length < 2) {
            Help.sendMsg(sender, "\u00a7cUsage: " + this.getUsage(), true);
            return true;
        }
        switch (subCommand = args[1].toLowerCase()) {
            case "status": 
            case "s": {
                this.showStatus(sender);
                break;
            }
            case "reload": 
            case "r": {
                this.reloadOptimizer(sender);
                break;
            }
            case "enable": 
            case "e": {
                this.enableOptimizer(sender);
                break;
            }
            case "disable": 
            case "d": {
                this.disableOptimizer(sender);
                break;
            }
            case "optimize": 
            case "o": {
                this.optimizeVillagers(sender, args);
                break;
            }
            case "stats": {
                this.showStats(sender);
                break;
            }
            default: {
                Help.sendMsg(sender, "\u00a7cUnknown subcommand. Available options: status, reload, enable, disable, optimize, stats", true);
            }
        }
        return true;
    }

    private void showStatus(CommandSender sender) {
        Help.sendMsg(sender, "\u00a76Villager Optimizer Status:", true);
        Help.sendMsg(sender, this.plugin.getVillagerOptimizer().getStatus(), false);
    }

    private void reloadOptimizer(CommandSender sender) {
        this.plugin.getVillagerOptimizer().reload();
        Help.sendMsg(sender, "\u00a7aVillager Optimizer configuration reloaded!", true);
    }

    private void enableOptimizer(CommandSender sender) {
        if (this.plugin.getVillagerOptimizer().isEnabled()) {
            Help.sendMsg(sender, "\u00a7eVillager Optimizer is already enabled.", true);
            return;
        }
        this.plugin.getConfig().set("villager_optimization.enabled", (Object)true);
        this.plugin.saveConfig();
        this.plugin.getVillagerOptimizer().reload();
        Help.sendMsg(sender, "\u00a7aVillager Optimizer has been enabled.", true);
    }

    private void disableOptimizer(CommandSender sender) {
        if (!this.plugin.getVillagerOptimizer().isEnabled()) {
            Help.sendMsg(sender, "\u00a7eVillager Optimizer is already disabled.", true);
            return;
        }
        this.plugin.getConfig().set("villager_optimization.enabled", (Object)false);
        this.plugin.saveConfig();
        this.plugin.getVillagerOptimizer().reload();
        Help.sendMsg(sender, "\u00a7cVillager Optimizer has been disabled.", true);
    }

    private void optimizeVillagers(CommandSender sender, String[] args) {
        World targetWorld = null;
        if (args.length >= 3) {
            targetWorld = Bukkit.getWorld((String)args[2]);
            if (targetWorld == null) {
                Help.sendMsg(sender, "\u00a7cWorld not found: " + args[2], true);
                return;
            }
        } else {
            if (!(sender instanceof Player)) {
                Help.sendMsg(sender, "\u00a7cPlease specify a world name when running from console.", true);
                return;
            }
            targetWorld = ((Player)sender).getWorld();
        }
        this.plugin.optimizeVillagersInWorld(targetWorld, sender);
    }

    private void showStats(CommandSender sender) {
        Help.sendMsg(sender, "\u00a76Villager Statistics by World:", true);
        int totalVillagers = 0;
        for (World world : Bukkit.getWorlds()) {
            int villagerCount = 0;
            int chunkCount = 0;
            HashMap<Chunk, Integer> villagersPerChunk = new HashMap<Chunk, Integer>();
            for (Entity entity : world.getEntities()) {
                if (!(entity instanceof Villager)) continue;
                ++villagerCount;
                ++totalVillagers;
                Chunk chunk = entity.getLocation().getChunk();
                villagersPerChunk.put(chunk, villagersPerChunk.getOrDefault(chunk, 0) + 1);
            }
            chunkCount = villagersPerChunk.size();
            int maxInChunk = 0;
            Iterator iterator = villagersPerChunk.values().iterator();
            while (iterator.hasNext()) {
                int count = (Integer)iterator.next();
                maxInChunk = Math.max(maxInChunk, count);
            }
            if (villagerCount <= 0) continue;
            Help.sendMsg(sender, "\u00a7e" + world.getName() + ": \u00a7b" + villagerCount + " \u00a7evillagers in \u00a7b" + chunkCount + " \u00a7echunks (max \u00a7b" + maxInChunk + " \u00a7eper chunk)", false);
        }
        Help.sendMsg(sender, "\u00a7eTotal villagers across all worlds: \u00a7b" + totalVillagers, false);
    }

    @Override
    public String getPermission() {
        return "lagx.villagers";
    }

    @Override
    public String getUsage() {
        return "/lagx villagers [status|reload|enable|disable|optimize|stats]";
    }

    @Override
    public String getDescription() {
        return "Villager optimizer controls";
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 2) {
            completions.addAll(Arrays.asList("status", "reload", "enable", "disable", "optimize", "stats"));
        } else if (args.length == 3 && args[1].equalsIgnoreCase("optimize")) {
            completions.addAll(Bukkit.getWorlds().stream().map(WorldInfo::getName).collect(Collectors.toList()));
        }
        return completions;
    }
}

