/*
 * Decompiled with CFR 0.152.
 */
package com.seristic.lagx.commands;

import com.seristic.lagx.commands.LagXCommand;
import com.seristic.lagx.inf.Help;
import com.seristic.lagx.main.LagX;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.CommandSender;

public class WarningsCommand
extends LagXCommand {
    public WarningsCommand(LagX plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        String action;
        if (args.length < 2) {
            this.showWarningStatus(sender);
            return true;
        }
        switch (action = args[1].toLowerCase()) {
            case "enable": {
                Help.sendMsg(sender, "\u00a7aPerformance warnings enabled!", true);
                break;
            }
            case "disable": {
                Help.sendMsg(sender, "\u00a7cPerformance warnings disabled!", true);
                break;
            }
            case "status": {
                this.showWarningStatus(sender);
                break;
            }
            default: {
                Help.sendMsg(sender, "\u00a7cUsage: " + this.getUsage(), true);
            }
        }
        return true;
    }

    private void showWarningStatus(CommandSender sender) {
        Help.sendMsg(sender, "\u00a76Performance Warnings: \u00a7aEnabled\n\u00a77TPS Warning: \u00a7f< 18.0\n\u00a77Memory Warning: \u00a7f> 80%", true);
    }

    @Override
    public String getPermission() {
        return "lagx.warnings";
    }

    @Override
    public String getUsage() {
        return "/lagx warnings [enable|disable|status]";
    }

    @Override
    public String getDescription() {
        return "Manage performance warnings";
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        if (args.length == 2) {
            return Arrays.asList("enable", "disable", "status");
        }
        return new ArrayList<String>();
    }
}

