/*
 * Decompiled with CFR 0.152.
 */
package com.seristic.lagx.managers;

import com.seristic.lagx.main.LagX;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigurationManager {
    private final LagX plugin;
    private FileConfiguration config;
    private File configFile;
    public static final String CONFIG_VERSION = "0.2.0";

    public ConfigurationManager(LagX plugin) {
        this.plugin = plugin;
        this.configFile = new File(plugin.getDataFolder(), "config.yml");
    }

    public void initialize() {
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdirs();
        }
        if (!this.configFile.exists()) {
            this.plugin.saveDefaultConfig();
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.updateConfigDefaults();
        this.plugin.getLogger().info("Configuration loaded successfully");
    }

    private void updateConfigDefaults() {
        boolean needsSave = false;
        if (!CONFIG_VERSION.equals(this.config.getString("config-version"))) {
            this.config.set("config-version", (Object)CONFIG_VERSION);
            needsSave = true;
        }
        needsSave |= this.addDefaultIfMissing("features.entity-limiter.enabled", true);
        needsSave |= this.addDefaultIfMissing("features.villager-optimizer.enabled", true);
        needsSave |= this.addDefaultIfMissing("features.entity-stacker.enabled", true);
        needsSave |= this.addDefaultIfMissing("features.itemframe-optimizer.enabled", true);
        needsSave |= this.addDefaultIfMissing("features.death-tracker.enabled", true);
        needsSave |= this.addDefaultIfMissing("features.map-protection.enabled", true);
        needsSave |= this.addDefaultIfMissing("tasks.chunk-unload.enabled", true);
        needsSave |= this.addDefaultIfMissing("tasks.chunk-unload.interval", 10);
        needsSave |= this.addDefaultIfMissing("tasks.lag-removal.enabled", true);
        needsSave |= this.addDefaultIfMissing("tasks.lag-removal.interval", 5);
        needsSave |= this.addDefaultIfMissing("tasks.entity-cleanup.enabled", true);
        needsSave |= this.addDefaultIfMissing("tasks.entity-cleanup.interval", 15);
        needsSave |= this.addDefaultIfMissing("map-protection.auto-scan.enabled", true);
        needsSave |= this.addDefaultIfMissing("map-protection.auto-scan.interval", 5);
        needsSave |= this.addDefaultIfMissing("map-protection.require-permission", true);
        needsSave |= this.addDefaultIfMissing("integrations.towny.enabled", true);
        needsSave |= this.addDefaultIfMissing("integrations.copyright-plugin.enabled", true);
        needsSave |= this.addDefaultIfMissing("integrations.copyright-plugin.override-protection", false);
        needsSave |= this.addDefaultIfMissing("commands.require-permission", true);
        needsSave |= this.addDefaultIfMissing("commands.tab-completion", true);
        needsSave |= this.addDefaultIfMissing("warnings.enabled", true);
        needsSave |= this.addDefaultIfMissing("warnings.tps-threshold", 18.0);
        if (needsSave |= this.addDefaultIfMissing("warnings.memory-threshold", 80)) {
            this.saveConfig();
            this.plugin.getLogger().info("Configuration updated with new defaults");
        }
    }

    private boolean addDefaultIfMissing(String path, Object defaultValue) {
        if (!this.config.contains(path)) {
            this.config.set(path, defaultValue);
            return true;
        }
        return false;
    }

    public void reload() {
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.plugin.getLogger().info("Configuration reloaded");
    }

    public void saveConfig() {
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save configuration: " + e.getMessage());
        }
    }

    public void shutdown() {
        this.saveConfig();
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public boolean isFeatureEnabled(String featureName) {
        return this.config.getBoolean("features." + featureName + ".enabled", false);
    }

    public void setFeatureEnabled(String featureName, boolean enabled) {
        this.config.set("features." + featureName + ".enabled", (Object)enabled);
        this.saveConfig();
    }

    public boolean isTaskEnabled(String taskName) {
        return this.config.getBoolean("tasks." + taskName + ".enabled", false);
    }

    public int getTaskInterval(String taskName) {
        return this.config.getInt("tasks." + taskName + ".interval", 10);
    }

    public boolean isIntegrationEnabled(String integrationName) {
        return this.config.getBoolean("integrations." + integrationName + ".enabled", false);
    }

    public boolean isMapProtectionAutoScanEnabled() {
        return this.config.getBoolean("map-protection.auto-scan.enabled", true);
    }

    public int getMapProtectionScanInterval() {
        return this.config.getInt("map-protection.auto-scan.interval", 5);
    }

    public boolean requiresMapProtectionPermission() {
        return this.config.getBoolean("map-protection.require-permission", true);
    }

    public boolean isCopyrightPluginOverrideEnabled() {
        return this.config.getBoolean("integrations.copyright-plugin.override-protection", false);
    }

    public boolean requiresCommandPermission() {
        return this.config.getBoolean("commands.require-permission", true);
    }

    public boolean isTabCompletionEnabled() {
        return this.config.getBoolean("commands.tab-completion", true);
    }

    public boolean areWarningsEnabled() {
        return this.config.getBoolean("warnings.enabled", true);
    }

    public void setWarningsEnabled(boolean enabled) {
        this.config.set("warnings.enabled", (Object)enabled);
        this.saveConfig();
    }

    public double getTpsWarningThreshold() {
        return this.config.getDouble("warnings.tps-threshold", 18.0);
    }

    public int getMemoryWarningThreshold() {
        return this.config.getInt("warnings.memory-threshold", 80);
    }

    public String getString(String path, String defaultValue) {
        return this.config.getString(path, defaultValue);
    }

    public int getInt(String path, int defaultValue) {
        return this.config.getInt(path, defaultValue);
    }

    public boolean getBoolean(String path, boolean defaultValue) {
        return this.config.getBoolean(path, defaultValue);
    }

    public List<String> getStringList(String path) {
        return this.config.getStringList(path);
    }
}

