/*
 * Decompiled with CFR 0.152.
 */
package com.seristic.lagx.managers;

import com.seristic.lagx.main.LagX;
import com.seristic.lagx.managers.ConfigurationManager;
import com.seristic.lagx.managers.CopyrightOverrideListener;
import com.seristic.lagx.util.TownyIntegration;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class IntegrationManager {
    private final LagX plugin;
    private final ConfigurationManager configManager;
    private TownyIntegration townyIntegration;
    private CopyrightPluginIntegration copyrightIntegration;
    private final Map<String, Object> integrations = new HashMap<String, Object>();

    public IntegrationManager(LagX plugin, ConfigurationManager configManager) {
        this.plugin = plugin;
        this.configManager = configManager;
    }

    public void initialize() {
        this.plugin.getLogger().info("Initializing plugin integrations...");
        this.initializeTownyIntegration();
        this.initializeCopyrightIntegration();
        this.plugin.getLogger().info("Initialized " + this.integrations.size() + " plugin integrations");
    }

    private void initializeTownyIntegration() {
        if (!this.configManager.isIntegrationEnabled("towny")) {
            return;
        }
        Plugin towny = Bukkit.getPluginManager().getPlugin("Towny");
        if (towny != null && towny.isEnabled()) {
            try {
                this.townyIntegration = new TownyIntegration(this.plugin);
                this.integrations.put("towny", this.townyIntegration);
                this.plugin.getLogger().info("Towny integration enabled");
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to initialize Towny integration: " + e.getMessage());
            }
        } else {
            this.plugin.getLogger().info("Towny not found, integration disabled");
        }
    }

    private void initializeCopyrightIntegration() {
        if (!this.configManager.isIntegrationEnabled("copyright-plugin")) {
            return;
        }
        String[] copyrightPluginNames = new String[]{"CopyrightPlugin", "MapCopyright", "MapProtection", "AntiMapCopy", "MapSecurity", "MapGuard"};
        Plugin copyrightPlugin = null;
        String pluginName = null;
        for (String name : copyrightPluginNames) {
            Plugin plugin = Bukkit.getPluginManager().getPlugin(name);
            if (plugin == null || !plugin.isEnabled()) continue;
            copyrightPlugin = plugin;
            pluginName = name;
            break;
        }
        if (copyrightPlugin != null) {
            try {
                this.copyrightIntegration = new CopyrightPluginIntegration(this.plugin, copyrightPlugin, this.configManager);
                this.integrations.put("copyright-plugin", this.copyrightIntegration);
                this.plugin.getLogger().info("Copyright plugin integration enabled (" + pluginName + ")");
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to initialize copyright plugin integration: " + e.getMessage());
            }
        } else {
            this.plugin.getLogger().info("No compatible copyright plugin found");
        }
    }

    public void reload() {
        this.shutdown();
        this.initialize();
    }

    public void shutdown() {
        if (this.copyrightIntegration != null) {
            this.copyrightIntegration.shutdown();
        }
        this.integrations.clear();
        this.townyIntegration = null;
        this.copyrightIntegration = null;
    }

    public TownyIntegration getTownyIntegration() {
        return this.townyIntegration;
    }

    public CopyrightPluginIntegration getCopyrightIntegration() {
        return this.copyrightIntegration;
    }

    public boolean isTownyAvailable() {
        return this.townyIntegration != null;
    }

    public boolean isCopyrightPluginAvailable() {
        return this.copyrightIntegration != null;
    }

    public <T> T getIntegration(String name, Class<T> type) {
        Object integration = this.integrations.get(name);
        if (type.isInstance(integration)) {
            return (T)integration;
        }
        return null;
    }

    public static class CopyrightPluginIntegration {
        private final LagX plugin;
        private final Plugin copyrightPlugin;
        private final ConfigurationManager configManager;

        public CopyrightPluginIntegration(LagX plugin, Plugin copyrightPlugin, ConfigurationManager configManager) {
            this.plugin = plugin;
            this.copyrightPlugin = copyrightPlugin;
            this.configManager = configManager;
            this.setupHooks();
        }

        private void setupHooks() {
            if (this.configManager.isCopyrightPluginOverrideEnabled()) {
                Bukkit.getPluginManager().registerEvents((Listener)new CopyrightOverrideListener(this.plugin, this), (Plugin)this.plugin);
                this.plugin.getLogger().info("Copyright plugin override hooks registered");
            }
        }

        public boolean shouldOverrideProtection(int mapId) {
            return this.configManager.isCopyrightPluginOverrideEnabled();
        }

        public boolean forceMapUpdate(int mapId) {
            if (!this.shouldOverrideProtection(mapId)) {
                return false;
            }
            try {
                this.plugin.getLogger().info("Forcing map update for ID " + mapId + " (overriding copyright protection)");
                return true;
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to override copyright protection for map " + mapId + ": " + e.getMessage());
                return false;
            }
        }

        public String getCopyrightPluginInfo() {
            return this.copyrightPlugin.getName() + " v" + this.copyrightPlugin.getDescription().getVersion();
        }

        public void shutdown() {
        }
    }
}

