/*
 * Decompiled with CFR 0.152.
 */
package com.seristic.lagx.util;

import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;

public class FormatUtil {
    private static final DecimalFormat df = new DecimalFormat("#,##0.00");
    private static final DecimalFormat intFormat = new DecimalFormat("#,##0");

    public static String formatDuration(long millis) {
        long days = TimeUnit.MILLISECONDS.toDays(millis);
        long hours = TimeUnit.MILLISECONDS.toHours(millis -= TimeUnit.DAYS.toMillis(days));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis -= TimeUnit.HOURS.toMillis(hours));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis -= TimeUnit.MINUTES.toMillis(minutes));
        StringBuilder sb = new StringBuilder();
        if (days > 0L) {
            sb.append(days).append("d ");
        }
        if (hours > 0L || days > 0L) {
            sb.append(hours).append("h ");
        }
        if (minutes > 0L || hours > 0L || days > 0L) {
            sb.append(minutes).append("m ");
        }
        sb.append(seconds).append("s");
        return sb.toString();
    }

    public static String formatDecimal(double number) {
        return df.format(number);
    }

    public static String formatInteger(int number) {
        return intFormat.format(number);
    }

    public static String formatBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return FormatUtil.formatDecimal((double)bytes / 1024.0) + " KB";
        }
        return bytes < 0x40000000L ? FormatUtil.formatDecimal((double)bytes / 1048576.0) + " MB" : FormatUtil.formatDecimal((double)bytes / 1.073741824E9) + " GB";
    }

    public static String formatBoolean(boolean value) {
        return value ? "\u00a7aYes" : "\u00a7cNo";
    }

    public static String formatPercentage(long value, long total) {
        return total == 0L ? "0%" : FormatUtil.formatDecimal((double)value / (double)total * 100.0) + "%";
    }
}

