/*
 * Decompiled with CFR 0.152.
 */
package com.seristic.lagx.util;

import com.seristic.lagx.main.LagX;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TownyIntegration {
    private final LagX plugin;
    private boolean townyEnabled = false;
    private Class<?> townyAPIClass;
    private Object townyAPIInstance;
    private Method isWildernessMethod;
    private Method getTownMethod;
    private Method getResidentMethod;
    private Method hasTownMethod;
    private Method getTownByResidentMethod;
    private Method isMayorMethod;
    private Method getNameMethod;
    private Method getTownBlockMethod;
    private Method hasResidentMethod;
    private Method getResidentFromTownBlockMethod;
    private static final Set<Material> ALLOWED_JUNK_MATERIALS = new HashSet<Material>(Arrays.asList(Material.COBBLESTONE, Material.DEEPSLATE, Material.DIORITE, Material.ANDESITE, Material.GRANITE, Material.STONE, Material.DIRT, Material.GRAVEL, Material.SAND, Material.RED_SAND, Material.NETHERRACK, Material.BLACKSTONE, Material.BASALT, Material.TUFF, Material.CALCITE, Material.COBBLED_DEEPSLATE, Material.POLISHED_BLACKSTONE, Material.SMOOTH_BASALT, Material.ROTTEN_FLESH, Material.BONE, Material.STRING, Material.SPIDER_EYE, Material.GUNPOWDER, Material.POISONOUS_POTATO, Material.KELP, Material.SEAGRASS, Material.BAMBOO, Material.WHEAT_SEEDS, Material.BEETROOT_SEEDS, Material.MELON_SEEDS, Material.PUMPKIN_SEEDS, Material.LEATHER, Material.FEATHER, Material.EGG, Material.MUTTON, Material.BEEF, Material.PORKCHOP, Material.CHICKEN, Material.RABBIT, Material.COD, Material.SALMON, Material.TROPICAL_FISH, Material.PUFFERFISH));

    public TownyIntegration(LagX plugin) {
        this.plugin = plugin;
        try {
            this.initTownyReflection();
        }
        catch (Throwable var3) {
            this.townyEnabled = false;
            plugin.getLogger().warning("Failed to initialize Towny integration: " + var3.getMessage());
        }
    }

    private void initTownyReflection() {
        Plugin townyPlugin = this.plugin.getServer().getPluginManager().getPlugin("Towny");
        if (townyPlugin != null && townyPlugin.isEnabled()) {
            try {
                this.townyAPIClass = Class.forName("com.palmergames.bukkit.towny.TownyAPI");
                Method getInstance = this.townyAPIClass.getMethod("getInstance", new Class[0]);
                this.townyAPIInstance = getInstance.invoke(null, new Object[0]);
                this.isWildernessMethod = this.townyAPIClass.getMethod("isWilderness", Location.class);
                this.getTownMethod = this.townyAPIClass.getMethod("getTown", Location.class);
                this.getResidentMethod = this.townyAPIClass.getMethod("getResident", Player.class);
                Class<?> residentClass = Class.forName("com.palmergames.bukkit.towny.object.Resident");
                this.hasTownMethod = residentClass.getMethod("hasTown", new Class[0]);
                this.getTownByResidentMethod = residentClass.getMethod("getTown", new Class[0]);
                Class<?> townClass = Class.forName("com.palmergames.bukkit.towny.object.Town");
                this.isMayorMethod = townClass.getMethod("isMayor", residentClass);
                this.getNameMethod = townClass.getMethod("getName", new Class[0]);
                this.getTownBlockMethod = this.townyAPIClass.getMethod("getTownBlock", Location.class);
                Class<?> townBlockClass = Class.forName("com.palmergames.bukkit.towny.object.TownBlock");
                this.hasResidentMethod = townBlockClass.getMethod("hasResident", new Class[0]);
                this.getResidentFromTownBlockMethod = townBlockClass.getMethod("getResident", new Class[0]);
                this.townyEnabled = true;
                this.plugin.getLogger().info("Towny integration enabled - using reflection for compatibility");
            }
            catch (Exception var6) {
                this.townyEnabled = false;
                this.plugin.getLogger().warning("Failed to initialize Towny integration: " + var6.getMessage());
                this.plugin.getLogger().warning("Town protection features will be disabled");
            }
        } else {
            this.townyEnabled = false;
            this.plugin.getLogger().info("Towny not found - town protection features disabled");
        }
    }

    public boolean isTownyEnabled() {
        return this.townyEnabled;
    }

    private boolean isWilderness(Location location) {
        if (!this.townyEnabled) {
            return true;
        }
        try {
            return (Boolean)this.isWildernessMethod.invoke(this.townyAPIInstance, location);
        }
        catch (Exception var3) {
            return true;
        }
    }

    public boolean isEntityProtected(Entity entity) {
        if (this.townyEnabled && !(entity instanceof Player)) {
            Location loc = entity.getLocation();
            try {
                if (this.isWilderness(loc)) {
                    return false;
                }
                if (entity instanceof Item) {
                    Item item = (Item)entity;
                    Material itemMaterial = item.getItemStack().getType();
                    return !ALLOWED_JUNK_MATERIALS.contains(itemMaterial);
                }
                return !(entity instanceof Monster);
            }
            catch (Exception var5) {
                this.plugin.getLogger().warning("Error checking Towny protection for entity: " + var5.getMessage());
                return true;
            }
        }
        return false;
    }

    public boolean isInTown(Location location) {
        return !this.townyEnabled ? false : !this.isWilderness(location);
    }

    public String getTownName(Location location) {
        if (!this.townyEnabled) {
            return null;
        }
        try {
            Object town;
            if (!this.isWilderness(location) && (town = this.getTownMethod.invoke(this.townyAPIInstance, location)) != null) {
                return (String)this.getNameMethod.invoke(town, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public boolean canPlayerClearInTown(Player player, Location location) {
        if (!this.townyEnabled) {
            return true;
        }
        try {
            if (this.isWilderness(location)) {
                return true;
            }
            if (LagX.hasPermission(player, "lagx.towny.bypass")) {
                return true;
            }
            Object town = this.getTownMethod.invoke(this.townyAPIInstance, location);
            if (town == null) {
                return true;
            }
            Object resident = this.getResidentMethod.invoke(this.townyAPIInstance, player);
            if (resident != null && ((Boolean)this.hasTownMethod.invoke(resident, new Object[0])).booleanValue()) {
                try {
                    Object residentTown = this.getTownByResidentMethod.invoke(resident, new Object[0]);
                    if (residentTown.equals(town)) {
                        return true;
                    }
                    if (((Boolean)this.isMayorMethod.invoke(town, resident)).booleanValue()) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
        catch (Exception var7) {
            this.plugin.getLogger().warning("Error checking Towny permissions: " + var7.getMessage());
            return false;
        }
    }

    public String getProtectionInfo(Location location) {
        if (!this.townyEnabled) {
            return "\u00a77No town protection (Towny not enabled)";
        }
        try {
            if (this.isWilderness(location)) {
                return "\u00a77Wilderness - no protection";
            }
            Object town = this.getTownMethod.invoke(this.townyAPIInstance, location);
            if (town == null) {
                return "\u00a77Unknown area";
            }
            StringBuilder info = new StringBuilder();
            info.append("\u00a76Town: \u00a7e").append(this.getNameMethod.invoke(town, new Object[0]));
            Object townBlock = this.getTownBlockMethod.invoke(this.townyAPIInstance, location);
            if (townBlock != null && ((Boolean)this.hasResidentMethod.invoke(townBlock, new Object[0])).booleanValue()) {
                try {
                    Object blockResident = this.getResidentFromTownBlockMethod.invoke(townBlock, new Object[0]);
                    info.append(" \u00a77(Plot: \u00a7e").append(this.getNameMethod.invoke(blockResident, new Object[0])).append("\u00a77)");
                }
                catch (Exception var6) {
                    info.append(" \u00a77(Claimed plot)");
                }
            }
            return info.toString();
        }
        catch (Exception var7) {
            return "\u00a7cError checking town info: " + var7.getMessage();
        }
    }

    public boolean isEnabled() {
        return this.townyEnabled;
    }

    public String getVersion() {
        if (!this.townyEnabled) {
            return "Not installed";
        }
        Plugin townyPlugin = this.plugin.getServer().getPluginManager().getPlugin("Towny");
        return townyPlugin == null ? "Not installed" : townyPlugin.getDescription().getVersion();
    }

    public String getTownAtLocation(Location location) {
        if (!this.townyEnabled) {
            return null;
        }
        try {
            Object townObj = this.getTownMethod.invoke(this.townyAPIInstance, location);
            return townObj == null ? null : (String)this.getNameMethod.invoke(townObj, new Object[0]);
        }
        catch (Exception var3) {
            return null;
        }
    }

    public boolean isLocationProtected(Location location) {
        if (!this.townyEnabled) {
            return false;
        }
        try {
            Boolean isWild = (Boolean)this.isWildernessMethod.invoke(this.townyAPIInstance, location);
            return isWild == false;
        }
        catch (Exception var3) {
            return false;
        }
    }

    public boolean isEntityProtectionEnabled() {
        return this.townyEnabled && this.plugin.getConfig().getBoolean("towny.entity-protection", true);
    }

    public boolean isChunkProtectionEnabled() {
        return this.townyEnabled && this.plugin.getConfig().getBoolean("towny.chunk-protection", true);
    }

    public void enable() {
        if (!this.townyEnabled) {
            try {
                this.initTownyReflection();
                this.plugin.getLogger().info("Towny integration enabled");
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to enable Towny integration: " + e.getMessage());
            }
        }
    }

    public void disable() {
        this.townyEnabled = false;
        this.plugin.getLogger().info("Towny integration disabled");
    }

    public String getTownyVersion() {
        return this.getVersion();
    }

    public int getTownCount() {
        if (!this.townyEnabled) {
            return 0;
        }
        try {
            Class<?> townyUniverseClass = Class.forName("com.palmergames.bukkit.towny.TownyUniverse");
            Method getInstanceMethod = townyUniverseClass.getMethod("getInstance", new Class[0]);
            Object townyUniverse = getInstanceMethod.invoke(null, new Object[0]);
            Method getTownsMethod = townyUniverseClass.getMethod("getTowns", new Class[0]);
            Object towns = getTownsMethod.invoke(townyUniverse, new Object[0]);
            if (towns instanceof Collection) {
                return ((Collection)towns).size();
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to get town count: " + e.getMessage());
        }
        return 0;
    }

    public int getNationCount() {
        if (!this.townyEnabled) {
            return 0;
        }
        try {
            Class<?> townyUniverseClass = Class.forName("com.palmergames.bukkit.towny.TownyUniverse");
            Method getInstanceMethod = townyUniverseClass.getMethod("getInstance", new Class[0]);
            Object townyUniverse = getInstanceMethod.invoke(null, new Object[0]);
            Method getNationsMethod = townyUniverseClass.getMethod("getNations", new Class[0]);
            Object nations = getNationsMethod.invoke(townyUniverse, new Object[0]);
            if (nations instanceof Collection) {
                return ((Collection)nations).size();
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to get nation count: " + e.getMessage());
        }
        return 0;
    }

    public int getProtectedChunkCount() {
        if (!this.townyEnabled) {
            return 0;
        }
        try {
            Class<?> townyUniverseClass = Class.forName("com.palmergames.bukkit.towny.TownyUniverse");
            Method getInstanceMethod = townyUniverseClass.getMethod("getInstance", new Class[0]);
            Object townyUniverse = getInstanceMethod.invoke(null, new Object[0]);
            Method getTownsMethod = townyUniverseClass.getMethod("getTowns", new Class[0]);
            Object towns = getTownsMethod.invoke(townyUniverse, new Object[0]);
            int totalChunks = 0;
            if (towns instanceof Collection) {
                for (Object town : (Collection)towns) {
                    try {
                        Method getTownBlocksMethod = town.getClass().getMethod("getTownBlocks", new Class[0]);
                        Object townBlocks = getTownBlocksMethod.invoke(town, new Object[0]);
                        if (!(townBlocks instanceof Collection)) continue;
                        totalChunks += ((Collection)townBlocks).size();
                    }
                    catch (Exception exception) {}
                }
            }
            return totalChunks;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to get protected chunk count: " + e.getMessage());
            return 0;
        }
    }
}

