/*
 * Decompiled with CFR 0.152.
 */
package com.seristic.lagx.api.proto.help;

import com.seristic.lagx.api.aparser.ProtoParse;
import com.seristic.lagx.util.DoubleVar;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class HelpFormatter {
    private HashMap<HelpFormatterType, String> parts = new HashMap();

    public HelpFormatter set(HelpFormatterType type, String var) {
        if (!type.equals((Object)HelpFormatterType.RETURNS)) {
            var = (String)var + "\n";
        }
        this.parts.put(type, (String)var);
        return this;
    }

    @NotNull
    public String make0() throws HelpFormatException {
        if (this.parts.size() != 4) {
            throw new HelpFormatException("You must set all help fields in order to compile help information.");
        }
        return "\u00a7aDescription: " + this.parts.get((Object)HelpFormatterType.DESCRIPTION) + "\u00a7aCategory(s): " + this.parts.get((Object)HelpFormatterType.CATEGORIES) + "\u00a7aArgument(s): " + this.parts.get((Object)HelpFormatterType.ARGUMENTS) + "\u00a7aReturn(s): " + this.parts.get((Object)HelpFormatterType.RETURNS);
    }

    public String make() {
        try {
            return this.make0();
        }
        catch (HelpFormatException var2) {
            return null;
        }
    }

    public String getInfo(HelpFormatterType type) {
        return this.parts.get((Object)type);
    }

    @NotNull
    public static String generateArgs(ProtoParse protoParse) {
        HashMap<String, ProtoParse.ProtoParseData> var = protoParse.getKeysToClass();
        StringBuilder sb = new StringBuilder();
        HashMap var1 = new HashMap();
        for (String s : var.keySet()) {
            ProtoParse.ProtoParseData protoParseData = var.get(s);
            ArrayList<DoubleVar<String, ProtoParse.ProtoParseData>> list = var1.containsKey(protoParseData.getIndex()) ? (List)var1.get(protoParseData.getIndex()) : new ArrayList<DoubleVar<String, ProtoParse.ProtoParseData>>();
            list.add(new DoubleVar<String, ProtoParse.ProtoParseData>(s, protoParseData));
            var1.put(protoParseData.getIndex(), list);
        }
        sb.append("\u00a7e{");
        int v1length = var1.size();
        for (Integer num : var1.keySet()) {
            int i = num;
            sb.append(i).append(": ");
            List list = (List)var1.get(i);
            int size = list.size();
            for (int j = 0; j < size; ++j) {
                DoubleVar vag = (DoubleVar)list.get(j);
                sb.append(((ProtoParse.ProtoParseData)vag.getVar2()).getClazz().getProperName()).append("(").append((String)vag.getVar1()).append(")");
                if (j + 1 >= size) continue;
                sb.append(" | ");
            }
            if (i + 1 == v1length) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public static enum HelpFormatterType {
        DESCRIPTION,
        CATEGORIES,
        ARGUMENTS,
        RETURNS;

    }

    public static class HelpFormatException
    extends Exception {
        private final String message;

        HelpFormatException(String message) {
            this.message = message;
        }

        @Override
        public String toString() {
            return this.message;
        }
    }
}

