/*
 * Decompiled with CFR 0.152.
 */
package com.seristic.lagx.commands;

import com.seristic.lagx.inf.Help;
import com.seristic.lagx.main.LagX;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandHandler {
    private final LagX plugin;
    private final Map<String, CommandInfo> commands = new HashMap<String, CommandInfo>();

    public CommandHandler(LagX plugin) {
        this.plugin = plugin;
    }

    public void registerCommand(String name, String permission, BiFunction<CommandSender, String[], Boolean> handler, String ... aliases) {
        CommandInfo info = new CommandInfo(name, permission, handler);
        this.commands.put(name.toLowerCase(), info);
        for (String alias : aliases) {
            this.commands.put(alias.toLowerCase(), info);
        }
    }

    public boolean handleCommand(CommandSender sender, String[] args) {
        if (args.length == 0) {
            if (this.hasPermission(sender, "lagx.help")) {
                Help.send(sender instanceof Player ? (Player)sender : null, 1);
                return true;
            }
            Help.sendMsg(sender, "\u00a7cYou don't have permission to use this command.", true);
            return true;
        }
        String subCommand = args[0].toLowerCase();
        CommandInfo info = this.commands.get(subCommand);
        if (info != null) {
            if (this.hasPermission(sender, info.permission)) {
                return info.handler.apply(sender, args);
            }
            Help.sendMsg(sender, "\u00a7cYou don't have permission to use this command.", true);
            return true;
        }
        Help.sendMsg(sender, "\u00a7cCommand not found! Use /lagx help for a list of commands.", true);
        return true;
    }

    private boolean hasPermission(CommandSender sender, String permission) {
        return !(sender instanceof Player) || sender.hasPermission(permission) || sender.hasPermission("lagx.*") || sender.isOp();
    }

    private static class CommandInfo {
        final String name;
        final String permission;
        final BiFunction<CommandSender, String[], Boolean> handler;

        CommandInfo(String name, String permission, BiFunction<CommandSender, String[], Boolean> handler) {
            this.name = name;
            this.permission = permission;
            this.handler = handler;
        }
    }
}

