/*
 * Decompiled with CFR 0.152.
 */
package com.seristic.lagx.commands;

import com.seristic.lagx.commands.ClearCommand;
import com.seristic.lagx.commands.CountCommand;
import com.seristic.lagx.commands.EntitiesCommand;
import com.seristic.lagx.commands.GcCommand;
import com.seristic.lagx.commands.HelpCommand;
import com.seristic.lagx.commands.InfoCommand;
import com.seristic.lagx.commands.LagXCommand;
import com.seristic.lagx.commands.LimiterCommand;
import com.seristic.lagx.commands.PingCommand;
import com.seristic.lagx.commands.PresetCommand;
import com.seristic.lagx.commands.ProtocolCommand;
import com.seristic.lagx.commands.RamCommand;
import com.seristic.lagx.commands.ReloadCommand;
import com.seristic.lagx.commands.StackerCommand;
import com.seristic.lagx.commands.StatusCommand;
import com.seristic.lagx.commands.TownyCommand;
import com.seristic.lagx.commands.TpsCommand;
import com.seristic.lagx.commands.UnloadCommand;
import com.seristic.lagx.commands.VillagersCommand;
import com.seristic.lagx.commands.WarningsCommand;
import com.seristic.lagx.commands.WorldCommand;
import com.seristic.lagx.inf.Help;
import com.seristic.lagx.main.LagX;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class CommandManager
implements TabCompleter {
    private final LagX plugin;
    private final Map<String, LagXCommand> commands = new HashMap<String, LagXCommand>();
    private final Map<String, String> aliases = new HashMap<String, String>();

    public CommandManager(LagX plugin) {
        this.plugin = plugin;
        this.registerCommands();
        Objects.requireNonNull(plugin.getCommand("lagx")).setTabCompleter((TabCompleter)this);
    }

    private void registerCommands() {
        this.registerCommand(new HelpCommand(this.plugin), "help", "h");
        this.registerCommand(new PingCommand(this.plugin), "ping", "p");
        this.registerCommand(new TpsCommand(this.plugin), "tps", new String[0]);
        this.registerCommand(new RamCommand(this.plugin), "ram", new String[0]);
        this.registerCommand(new GcCommand(this.plugin), "gc", new String[0]);
        this.registerCommand(new InfoCommand(this.plugin), "info", "i");
        this.registerCommand(new StatusCommand(this.plugin), "status", "master", "m");
        this.registerCommand(new ProtocolCommand(this.plugin), "protocol", "pr");
        this.registerCommand(new ClearCommand(this.plugin), "clear", "c");
        this.registerCommand(new CountCommand(this.plugin), "count", "ct");
        this.registerCommand(new WorldCommand(this.plugin), "world", "w");
        this.registerCommand(new UnloadCommand(this.plugin), "unload", "u");
        this.registerCommand(new StackerCommand(this.plugin), "stacker", "stack");
        this.registerCommand(new EntitiesCommand(this.plugin), "entities", "ent");
        this.registerCommand(new LimiterCommand(this.plugin), "limiter", "lim");
        this.registerCommand(new TownyCommand(this.plugin), "towny", "town");
        this.registerCommand(new PresetCommand(this.plugin), "preset", new String[0]);
        this.registerCommand(new VillagersCommand(this.plugin), "villagers", "optimize");
        this.registerCommand(new ReloadCommand(this.plugin), "reload", "rl");
        this.registerCommand(new WarningsCommand(this.plugin), "warnings", "warn");
    }

    private void registerCommand(LagXCommand command, String name, String ... aliases) {
        this.commands.put(name.toLowerCase(), command);
        for (String alias : aliases) {
            this.aliases.put(alias.toLowerCase(), name.toLowerCase());
        }
    }

    public boolean handleCommand(CommandSender sender, String[] args) {
        try {
            LagXCommand command;
            if (args.length == 0) {
                if (this.hasPermission(sender, "lagx.help")) {
                    Help.send(sender instanceof Player ? (Player)sender : null, 1);
                    return true;
                }
                Help.sendMsg(sender, "\u00a7cYou don't have permission to use this command.", true);
                return true;
            }
            String commandName = args[0].toLowerCase();
            if (this.aliases.containsKey(commandName)) {
                commandName = this.aliases.get(commandName);
            }
            if ((command = this.commands.get(commandName)) != null) {
                String permission = command.getPermission();
                if (permission != null && !this.hasPermission(sender, permission)) {
                    Help.sendMsg(sender, "\u00a7cYou don't have permission to use this command.", true);
                    return true;
                }
                return command.execute(sender, args);
            }
            Help.sendMsg(sender, "\u00a7cUnknown command. Use \u00a7e/lagx help \u00a7cfor a list of commands.", true);
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error executing command: " + e.getMessage());
            e.printStackTrace();
            Help.sendMsg(sender, "\u00a7cAn error occurred while executing the command.", true);
            return true;
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        try {
            if (args.length == 1) {
                String partial = args[0].toLowerCase();
                for (Map.Entry<String, LagXCommand> entry : this.commands.entrySet()) {
                    String cmdName = entry.getKey();
                    LagXCommand cmd = entry.getValue();
                    String permission = cmd.getPermission();
                    if (permission != null && !this.hasPermission(sender, permission) || !cmdName.startsWith(partial)) continue;
                    completions.add(cmdName);
                }
                for (Map.Entry<String, Object> entry : this.aliases.entrySet()) {
                    String permission;
                    String aliasName = entry.getKey();
                    String realCommand = (String)entry.getValue();
                    LagXCommand cmd = this.commands.get(realCommand);
                    if (cmd == null || (permission = cmd.getPermission()) != null && !this.hasPermission(sender, permission) || !aliasName.startsWith(partial)) continue;
                    completions.add(aliasName);
                }
            } else if (args.length > 1) {
                List<String> subCompletions;
                String string;
                LagXCommand cmd;
                String commandName = args[0].toLowerCase();
                if (this.aliases.containsKey(commandName)) {
                    commandName = this.aliases.get(commandName);
                }
                if ((cmd = this.commands.get(commandName)) != null && ((string = cmd.getPermission()) == null || this.hasPermission(sender, string)) && (subCompletions = cmd.getTabCompletions(sender, args)) != null) {
                    completions.addAll(subCompletions);
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error in tab completion: " + e.getMessage());
        }
        Collections.sort(completions);
        return completions;
    }

    public Set<String> getCommandNames() {
        return new HashSet<String>(this.commands.keySet());
    }

    public Set<String> getAliases() {
        return new HashSet<String>(this.aliases.keySet());
    }

    public List<String> getAvailableCommands(CommandSender sender) {
        ArrayList<String> available = new ArrayList<String>();
        for (Map.Entry<String, LagXCommand> entry : this.commands.entrySet()) {
            String permission = entry.getValue().getPermission();
            if (permission != null && !this.hasPermission(sender, permission)) continue;
            available.add(entry.getKey());
        }
        return available;
    }

    public boolean hasPermission(CommandSender sender, String permission) {
        return LagX.hasPermission(sender, permission);
    }

    public LagX getPlugin() {
        return this.plugin;
    }

    public LagXCommand getCommand(String name) {
        String commandName = name.toLowerCase();
        if (this.aliases.containsKey(commandName)) {
            commandName = this.aliases.get(commandName);
        }
        return this.commands.get(commandName);
    }
}

