/*
 * Decompiled with CFR 0.152.
 */
package com.seristic.lagx.commands;

import com.seristic.lagx.commands.LagXCommand;
import com.seristic.lagx.inf.Help;
import com.seristic.lagx.main.LagX;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public class CountCommand
extends LagXCommand {
    public CountCommand(LagX plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        if (args.length < 2) {
            Help.sendMsg(sender, "\u00a7cUsage: " + this.getUsage(), true);
            return true;
        }
        String target = args[1].toLowerCase();
        if (target.equals("entities")) {
            this.countEntities(sender, args);
        } else if (target.equals("chunks")) {
            this.countChunks(sender);
        } else if (target.equals("worlds")) {
            this.countWorlds(sender);
        } else {
            Help.sendMsg(sender, "\u00a7cUsage: " + this.getUsage(), true);
        }
        return true;
    }

    private void countEntities(CommandSender sender, String[] args) {
        int totalEntities = 0;
        StringBuilder msg = new StringBuilder("\u00a76Entity Count Summary:\n");
        for (World world : Bukkit.getWorlds()) {
            int worldEntities = world.getEntities().size();
            totalEntities += worldEntities;
            msg.append("\u00a77- \u00a7e").append(world.getName()).append("\u00a77: \u00a7f").append(worldEntities).append(" entities\n");
        }
        msg.append("\u00a76Total: \u00a7f").append(totalEntities).append(" entities");
        Help.sendMsg(sender, msg.toString(), true);
    }

    private void countChunks(CommandSender sender) {
        int totalChunks = 0;
        StringBuilder msg = new StringBuilder("\u00a76Chunk Count Summary:\n");
        for (World world : Bukkit.getWorlds()) {
            int worldChunks = world.getLoadedChunks().length;
            totalChunks += worldChunks;
            msg.append("\u00a77- \u00a7e").append(world.getName()).append("\u00a77: \u00a7f").append(worldChunks).append(" chunks\n");
        }
        msg.append("\u00a76Total: \u00a7f").append(totalChunks).append(" loaded chunks");
        Help.sendMsg(sender, msg.toString(), true);
    }

    private void countWorlds(CommandSender sender) {
        List worlds = Bukkit.getWorlds();
        StringBuilder msg = new StringBuilder("\u00a76World Count Summary:\n");
        msg.append("\u00a77Total worlds: \u00a7f").append(worlds.size()).append("\n");
        for (World world : worlds) {
            msg.append("\u00a77- \u00a7e").append(world.getName()).append(" \u00a77(").append(world.getEnvironment().toString().toLowerCase()).append(")\n");
        }
        Help.sendMsg(sender, msg.toString(), true);
    }

    @Override
    public String getPermission() {
        return "lagx.count";
    }

    @Override
    public String getUsage() {
        return "/lagx count <entities|chunks|worlds>";
    }

    @Override
    public String getDescription() {
        return "Count entities, chunks, or worlds";
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        if (args.length == 2) {
            return Arrays.asList("entities", "chunks", "worlds");
        }
        return new ArrayList<String>();
    }
}

