/*
 * Decompiled with CFR 0.152.
 */
package com.seristic.lagx.commands;

import com.seristic.lagx.commands.LagXCommand;
import com.seristic.lagx.inf.Help;
import com.seristic.lagx.main.LagX;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.CommandSender;

public class LimiterCommand
extends LagXCommand {
    public LimiterCommand(LagX plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        String sub;
        if (this.plugin.getEntityLimiter() == null) {
            Help.sendMsg(sender, "\u00a7cEntity Limiter is not enabled on this server.", true);
            return true;
        }
        if (args.length < 2) {
            Help.sendMsg(sender, "\u00a7cUsage: " + this.getUsage(), true);
            return true;
        }
        switch (sub = args[1].toLowerCase()) {
            case "status": 
            case "s": {
                this.showStatus(sender);
                break;
            }
            case "reload": 
            case "r": {
                this.reloadLimiter(sender);
                break;
            }
            case "enable": 
            case "e": {
                this.enableLimiter(sender);
                break;
            }
            case "disable": 
            case "d": {
                this.disableLimiter(sender);
                break;
            }
            default: {
                Help.sendMsg(sender, "\u00a7cUnknown subcommand. Available: status, reload, enable, disable", true);
            }
        }
        return true;
    }

    private void showStatus(CommandSender sender) {
        Help.sendMsg(sender, "\u00a76Entity Limiter Status:", true);
        Help.sendMsg(sender, this.plugin.getEntityLimiter().getStatus(), false);
    }

    private void reloadLimiter(CommandSender sender) {
        this.plugin.getEntityLimiter().reload();
        Help.sendMsg(sender, "\u00a7aEntity Limiter configuration reloaded!", true);
    }

    private void enableLimiter(CommandSender sender) {
        this.plugin.getConfig().set("entity_limiter.enabled", (Object)true);
        this.plugin.saveConfig();
        this.plugin.getEntityLimiter().reload();
        Help.sendMsg(sender, "\u00a7aEntity Limiter has been enabled.", true);
    }

    private void disableLimiter(CommandSender sender) {
        this.plugin.getConfig().set("entity_limiter.enabled", (Object)false);
        this.plugin.saveConfig();
        this.plugin.getEntityLimiter().reload();
        Help.sendMsg(sender, "\u00a7cEntity Limiter has been disabled.", true);
    }

    @Override
    public String getPermission() {
        return "lagx.limiter";
    }

    @Override
    public String getUsage() {
        return "/lagx limiter [status|reload|enable|disable]";
    }

    @Override
    public String getDescription() {
        return "Entity limiter control";
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        if (args.length == 2) {
            return Arrays.asList("info", "status", "reload", "enable", "disable");
        }
        return new ArrayList<String>();
    }
}

