/*
 * Decompiled with CFR 0.152.
 */
package com.seristic.lagx.commands;

import com.seristic.lagx.commands.LagXCommand;
import com.seristic.lagx.inf.Help;
import com.seristic.lagx.main.LagX;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PingCommand
extends LagXCommand {
    public PingCommand(LagX plugin) {
        super(plugin);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean execute(CommandSender sender, String[] args) {
        if (!this.hasPermission(sender)) {
            Help.sendMsg(sender, "\u00a7cYou don't have permission to use this command.", true);
            return true;
        }
        Player target = (Player)sender;
        if (args.length >= 2) {
            if (!(sender instanceof Player) && !sender.hasPermission("lagx.ping.others")) {
                Help.sendMsg(sender, "\u00a7cYou don't have permission to check other players' ping.", true);
                return true;
            }
            target = Bukkit.getPlayerExact((String)args[1]);
            if (target == null) {
                Help.sendMsg(sender, "\u00a7cPlayer not found.", true);
                return true;
            }
        } else if (!(sender instanceof Player)) {
            Help.sendMsg(sender, "\u00a7cUsage: /lagx ping <player>", true);
            return true;
        }
        int ping = 0;
        try {
            ping = target.getPing();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Help.sendMsg(sender, "\u00a7ePing for \u00a7b" + target.getName() + "\u00a7e: \u00a7b" + ping + "ms", true);
        return true;
    }

    @Override
    public String getPermission() {
        return "lagx.ping";
    }

    @Override
    public String getUsage() {
        return "/lagx ping [player]";
    }

    @Override
    public String getDescription() {
        return "Shows ping of yourself or another player";
    }
}

