/*
 * Decompiled with CFR 0.152.
 */
package com.seristic.lagx.commands;

import com.seristic.lagx.commands.LagXCommand;
import com.seristic.lagx.inf.Help;
import com.seristic.lagx.main.LagX;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;

public class ReloadCommand
extends LagXCommand {
    public ReloadCommand(LagX plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        try {
            long startTime = System.currentTimeMillis();
            Help.sendMsg(sender, "\u00a76Reloading LagX configuration...", true);
            this.plugin.reloadConfig();
            FileConfiguration config = this.plugin.getConfig();
            if (this.plugin.getPluginManager() != null && this.plugin.getPluginManager().getConfigManager() != null) {
                this.plugin.getPluginManager().getConfigManager().initialize();
                Help.sendMsg(sender, "\u00a77- Configuration manager reloaded", true);
            }
            if (this.plugin.getPluginManager() != null && this.plugin.getPluginManager().getTaskManager() != null) {
                this.plugin.getPluginManager().getTaskManager().reload();
                Help.sendMsg(sender, "\u00a77- Task manager reloaded (tasks restarted)", true);
            }
            if (this.plugin.getEntityLimiter() != null) {
                this.plugin.getEntityLimiter().reloadConfig();
                Help.sendMsg(sender, "\u00a77- Entity limiter reloaded", true);
            }
            if (this.plugin.getVillagerOptimizer() != null) {
                this.plugin.getVillagerOptimizer().reloadConfig();
                Help.sendMsg(sender, "\u00a77- Villager optimizer reloaded", true);
            }
            if (this.plugin.getEntityStacker() != null) {
                this.plugin.getEntityStacker().reloadConfig();
                Help.sendMsg(sender, "\u00a77- Entity stacker reloaded", true);
            }
            if (this.plugin.getItemFrameOptimizer() != null) {
                this.plugin.getItemFrameOptimizer().reloadConfig();
                Help.sendMsg(sender, "\u00a77- Item frame optimizer reloaded", true);
            }
            long endTime = System.currentTimeMillis();
            long duration = endTime - startTime;
            Help.sendMsg(sender, "\u00a7aLagX configuration reloaded successfully! \u00a77(" + duration + "ms)", true);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error reloading configuration: " + e.getMessage());
            e.printStackTrace();
            Help.sendMsg(sender, "\u00a7cError reloading configuration! Check console for details.", true);
        }
        return true;
    }

    @Override
    public String getPermission() {
        return "lagx.reload";
    }

    @Override
    public String getUsage() {
        return "/lagx reload";
    }

    @Override
    public String getDescription() {
        return "Reload plugin configuration and features";
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        return new ArrayList<String>();
    }
}

