/*
 * Decompiled with CFR 0.152.
 */
package com.seristic.lagx.commands;

import com.seristic.lagx.commands.LagXCommand;
import com.seristic.lagx.inf.Help;
import com.seristic.lagx.main.LagX;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class StackerCommand
extends LagXCommand {
    public StackerCommand(LagX plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        if (args.length < 2) {
            Help.sendMsg(sender, "\u00a7cUsage: " + this.getUsage(), true);
            return true;
        }
        String subCommand = args[1].toLowerCase();
        if (this.plugin.getEntityStacker() == null) {
            Help.sendMsg(sender, "\u00a7cEntity Stacker is not enabled on this server.", true);
            return true;
        }
        switch (subCommand) {
            case "info": {
                this.showInfo(sender);
                break;
            }
            case "debug": {
                this.showDebug(sender);
                break;
            }
            case "reload": {
                this.reloadStacker(sender);
                break;
            }
            case "stack": {
                this.stackEntities(sender, args);
                break;
            }
            default: {
                Help.sendMsg(sender, "\u00a7cUnknown subcommand. Available options: info, debug, reload, stack", true);
            }
        }
        return true;
    }

    private void showInfo(CommandSender sender) {
        Help.sendMsg(sender, "\u00a76Entity Stacker Statistics:", true);
        Help.sendMsg(sender, "\u00a7eEnabled: \u00a7a" + this.plugin.getEntityStacker().isEnabled(), false);
        Help.sendMsg(sender, "\u00a7eSingle Kill Mode: \u00a7a" + this.plugin.getEntityStacker().isSingleKillEnabled(), false);
        Help.sendMsg(sender, "\u00a7eStacked Items: \u00a7a" + this.plugin.getEntityStacker().getStackedItemsCount(), false);
        Help.sendMsg(sender, "\u00a7eStacked Entities: \u00a7a" + this.plugin.getEntityStacker().getStackedEntitiesCount(), false);
    }

    private void showDebug(CommandSender sender) {
        Help.sendMsg(sender, this.plugin.getEntityStacker().getDebugInfo(), true);
    }

    private void reloadStacker(CommandSender sender) {
        this.plugin.getEntityStacker().reloadConfig();
        Help.sendMsg(sender, "\u00a7aEntity Stacker configuration reloaded!", true);
    }

    private void stackEntities(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            Help.sendMsg(sender, "\u00a7cThis command can only be used by players.", true);
            return;
        }
        Player player = (Player)sender;
        int radius = 50;
        if (args.length >= 3) {
            try {
                radius = Integer.parseInt(args[2]);
                if (radius < 1 || radius > 200) {
                    Help.sendMsg(sender, "\u00a7cRadius must be between 1 and 200 blocks.", true);
                    return;
                }
            }
            catch (NumberFormatException e) {
                Help.sendMsg(sender, "\u00a7cInvalid radius. Please use a number between 1 and 200.", true);
                return;
            }
        }
        int stacksCreated = this.plugin.getEntityStacker().stackEntitiesInRadius(player.getLocation(), radius);
        Help.sendMsg(sender, "\u00a7aSuccessfully stacked entities in a " + radius + " block radius. Created " + stacksCreated + " stacks.", true);
    }

    @Override
    public String getPermission() {
        return "lagx.stacker";
    }

    @Override
    public String getUsage() {
        return "/lagx stacker [info|debug|reload|stack <radius>]";
    }

    @Override
    public String getDescription() {
        return "Entity stacker management";
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 2) {
            completions.addAll(Arrays.asList("info", "debug", "reload", "stack"));
        } else if (args.length == 3 && args[1].equalsIgnoreCase("stack")) {
            completions.addAll(Arrays.asList("10", "25", "50", "100", "200"));
        }
        return completions;
    }
}

