/*
 * Decompiled with CFR 0.152.
 */
package com.seristic.lagx.commands;

import com.seristic.lagx.commands.LagXCommand;
import com.seristic.lagx.inf.Help;
import com.seristic.lagx.main.LagX;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.CommandSender;

public class WarningsCommand
extends LagXCommand {
    public WarningsCommand(LagX plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        String action;
        if (args.length < 2) {
            this.showWarningStatus(sender);
            return true;
        }
        switch (action = args[1].toLowerCase()) {
            case "enable": 
            case "on": {
                this.plugin.getPluginManager().getConfigManager().setWarningsEnabled(true);
                Help.sendMsg(sender, "\u00a7aGround item clearing warnings enabled!", true);
                Help.sendMsg(sender, "\u00a77Players will now see warnings before items are cleared.", true);
                break;
            }
            case "disable": 
            case "off": {
                this.plugin.getPluginManager().getConfigManager().setWarningsEnabled(false);
                Help.sendMsg(sender, "\u00a7cGround item clearing warnings disabled!", true);
                Help.sendMsg(sender, "\u00a77Only players with \u00a7elagx.warnings.receive \u00a77will see warnings.", true);
                break;
            }
            case "status": {
                this.showWarningStatus(sender);
                break;
            }
            default: {
                Help.sendMsg(sender, "\u00a7cUsage: " + this.getUsage(), true);
            }
        }
        return true;
    }

    private void showWarningStatus(CommandSender sender) {
        boolean enabled = this.plugin.getPluginManager().getConfigManager().areWarningsEnabled();
        boolean debugMode = this.plugin.getPluginManager().getConfigManager().isDebugMode();
        if (enabled) {
            Help.sendMsg(sender, "\u00a76Ground Item Clearing Warnings: \u00a7aEnabled", true);
            Help.sendMsg(sender, "\u00a77All players will receive warnings before items are cleared.", true);
        } else {
            Help.sendMsg(sender, "\u00a76Ground Item Clearing Warnings: \u00a7cDisabled", true);
            Help.sendMsg(sender, "\u00a77Only players with \u00a7elagx.warnings.receive \u00a77will see warnings.", true);
        }
        if (debugMode) {
            Help.sendMsg(sender, "\u00a7c\u00a7lDEBUG MODE ACTIVE: \u00a7eClearing every 1 minute with 5 second warnings", true);
        }
    }

    @Override
    public String getPermission() {
        return "lagx.warnings";
    }

    @Override
    public String getUsage() {
        return "/lagx warnings [enable|disable|status]";
    }

    @Override
    public String getDescription() {
        return "Toggle ground item clearing warnings";
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        if (args.length == 2) {
            return Arrays.asList("enable", "disable", "status", "on", "off");
        }
        return new ArrayList<String>();
    }
}

