/*
 * Decompiled with CFR 0.152.
 */
package com.seristic.lagx.inf;

import com.seristic.lagx.api.proto.LRProtocolResult;
import com.seristic.lagx.main.LagX;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Help {
    private static final List<HoverCommand> commandsHelp = new ArrayList<HoverCommand>();
    private static final int COMMANDS_PER_PAGE = 8;

    public static void init() {
        commandsHelp.clear();
        commandsHelp.add(new HoverCommand("/lagx help(h) <num>", "Lists all available commands.", "lagx.help", true));
        commandsHelp.add(new HoverCommand("/lagx status(st)", "Quick server health overview with key metrics.", "lagx.status", true));
        commandsHelp.add(new HoverCommand("/lagx master(m)", "Displays comprehensive server performance overview.", "lagx.master", true));
        commandsHelp.add(new HoverCommand("/lagx tps", "Shows current server TPS with health status.", "lagx.tps", true));
        commandsHelp.add(new HoverCommand("/lagx gc", "Runs garbage collection and shows memory improvement.", "lagx.gc", true));
        commandsHelp.add(new HoverCommand("/lagx ram", "Displays detailed memory usage statistics.", "lagx.ram", true));
        commandsHelp.add(new HoverCommand("/lagx protocol(pr) <options>", "Advanced protocol management and execution.", "lagx.protocol", true));
        commandsHelp.add(new HoverCommand("/lagx clear(c)", "Removes various entities/items from worlds.", "lagx.clear", true));
        commandsHelp.add(new HoverCommand("/lagx count(ct)", "Counts various entities/items in worlds.", "lagx.clear", true));
        commandsHelp.add(new HoverCommand("/lagx clear area <c:chunks|b:blocks> [type]", "Clear entities in area around you.", "lagx.clear", true));
        commandsHelp.add(new HoverCommand("/lagx world(w) <world>", "Shows detailed statistics for a specific world.", "lagx.world", true));
        commandsHelp.add(new HoverCommand("/lagx unload(u) <world>", "Unloads all chunks in the specified world.", "lagx.unload", true));
        commandsHelp.add(new HoverCommand("/lagx modules(mo)", "Lists all loaded modules.", "lagx.modules", true));
        commandsHelp.add(new HoverCommand("/lagx info(i)", "Shows LagX version and information.", "lagx.help", true));
        commandsHelp.add(new HoverCommand("/lagx ping(p) <player:none>", "Displays player connection latency.", "lagx.ping", true));
        commandsHelp.add(new HoverCommand("/lagx preset [basic|advanced|custom]", "Switch entity limiter presets.", "lagx.entities", true));
        commandsHelp.add(new HoverCommand("/lagx entities [status|reload|stats]", "Manage entity limiting system.", "lagx.entities", true));
        commandsHelp.add(new HoverCommand("/lagx villagers [status|reload|optimize|stats]", "Optimize villager AI performance.", "lagx.villagers", true));
        commandsHelp.add(new HoverCommand("/lagx stacker(stack) [info|reload|stack <radius>]", "Manage entity stacking system to reduce entity count.", "lagx.stacker", true));
        commandsHelp.add(new HoverCommand("/lagx reload(rl)", "Reload plugin configuration without restarting the server.", "lagx.reload", true));
        commandsHelp.add(new HoverCommand("/lagx warnings(warn) [status|on|off|toggle]", "Toggle or view protocol warnings.", "lagx.warn", true));
    }

    public static void send(Player p, int pageNum) {
        List<List<HoverCommand>> pages = Help.getPages();
        int maxPages = pages.size();
        if (pageNum > maxPages) {
            Help.sendMsg(p, "\u00a7cHelp page #" + pageNum + " does not exist.", true);
        } else {
            Component header = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"\u2726 LagX Help ", (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.BOLD, true)).append((Component)Component.text((String)"(Page ", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((int)pageNum, (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)"/", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((int)maxPages, (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)") ", (TextColor)NamedTextColor.GRAY))).append(Component.text((String)"\u2726", (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.BOLD, true));
            if (p != null) {
                p.sendMessage(header);
            } else {
                Help.sendMsg(p, "\u00a76\u00a7l\u2726 LagX Help \u00a77(Page \u00a7b" + pageNum + "\u00a77/\u00a7b" + maxPages + "\u00a77) \u00a76\u00a7l\u2726", false);
            }
            for (HoverCommand cmd : pages.get(pageNum - 1)) {
                if (p != null) {
                    p.sendMessage(cmd.toComponent());
                    continue;
                }
                Help.sendMsg(p, "\u00a7e" + cmd.command + " \u00a77- " + cmd.description, false);
            }
            if (maxPages > 1 && p != null) {
                Help.sendPaginationButtons(p, pageNum, maxPages);
            }
        }
    }

    private static void sendPaginationButtons(Player p, int currentPage, int maxPages) {
        TextComponent pagination = Component.empty();
        if (currentPage > 1) {
            Component prevButton = ((TextComponent)Component.text((String)"\u00ab Previous", (TextColor)NamedTextColor.GREEN).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)("Go to page " + (currentPage - 1)), (TextColor)NamedTextColor.GRAY)))).clickEvent(ClickEvent.runCommand((String)("/lagx help " + (currentPage - 1))));
            pagination = pagination.append(prevButton);
        } else {
            pagination = pagination.append((Component)Component.text((String)"\u00ab Previous", (TextColor)NamedTextColor.DARK_GRAY));
        }
        pagination = pagination.append((Component)Component.text((String)(" \u00a78[\u00a77" + currentPage + "\u00a78/\u00a77" + maxPages + "\u00a78] "), (TextColor)NamedTextColor.GRAY));
        if (currentPage < maxPages) {
            Component nextButton = ((TextComponent)Component.text((String)"Next \u00bb", (TextColor)NamedTextColor.GREEN).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)("Go to page " + (currentPage + 1)), (TextColor)NamedTextColor.GRAY)))).clickEvent(ClickEvent.runCommand((String)("/lagx help " + (currentPage + 1))));
            pagination = pagination.append(nextButton);
        } else {
            pagination = pagination.append((Component)Component.text((String)"Next \u00bb", (TextColor)NamedTextColor.DARK_GRAY));
        }
        p.sendMessage((Component)pagination);
        if (maxPages > 2) {
            Component footer = ((TextComponent)Component.text((String)"\u00a77Tip: Use ", (TextColor)NamedTextColor.GRAY).append(Component.text((String)"/lagx help <page>", (TextColor)NamedTextColor.YELLOW).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Jump to specific page", (TextColor)NamedTextColor.GRAY))))).append((Component)Component.text((String)" to jump to any page", (TextColor)NamedTextColor.GRAY));
            p.sendMessage(footer);
        }
    }

    public static void send(Player p) {
        Help.send(p, 1);
    }

    public static int getTotalPages() {
        return Help.getPages().size();
    }

    public static boolean isValidPage(int pageNum) {
        return pageNum >= 1 && pageNum <= Help.getTotalPages();
    }

    public static int getTotalCommands() {
        return commandsHelp.size();
    }

    public static void sendMsg(Player p, String msg, boolean pre) {
        if (p == null) {
            LagX.instance.getLogger().info(((String)msg).replaceAll("\u00a7[0-9a-fk-or]", ""));
        } else {
            if (pre) {
                msg = LagX.prefix + (String)msg;
            }
            p.sendMessage((String)msg);
        }
    }

    public static void sendMsg(CommandSender sender, String msg, boolean pre) {
        if (sender == null) {
            LagX.instance.getLogger().info(((String)msg).replaceAll("\u00a7[0-9a-fk-or]", ""));
        } else {
            if (pre) {
                msg = LagX.prefix + (String)msg;
            }
            sender.sendMessage((String)msg);
        }
    }

    public static void addCommandH(HoverCommand cmd) {
        commandsHelp.add(cmd);
    }

    public static List<List<HoverCommand>> getPages() {
        ArrayList<List<HoverCommand>> h = new ArrayList<List<HoverCommand>>();
        ArrayList<HoverCommand> c = new ArrayList<HoverCommand>();
        for (HoverCommand s : commandsHelp) {
            if (c.size() == 8) {
                h.add(c);
                c = new ArrayList();
            }
            c.add(s);
        }
        if (!c.isEmpty()) {
            h.add(c);
        }
        return h;
    }

    public static void sendProtocolResultInfo(Player p, LRProtocolResult r) {
        StringBuilder s = new StringBuilder();
        s.append("{");
        int i = 0;
        for (Object o : r.getData()) {
            s.append(i).append(": ").append(o).append(", ");
            ++i;
        }
        String fin = s.toString();
        Help.sendMsg(p, "\u00a7eProtocol: " + r.getSuper().id() + " | \u00a77" + s.substring(0, fin.length() - 2) + "}", true);
    }

    public static class HoverCommand {
        public final String command;
        public final String description;
        public final String permission;
        public final boolean adminOnly;

        public HoverCommand(String command, String description, String permission, boolean adminOnly) {
            this.command = command;
            this.description = description;
            this.permission = permission;
            this.adminOnly = adminOnly;
        }

        public Component toComponent() {
            Component hoverText = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"Description: ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)this.description, (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)"\nPermission: ", (TextColor)NamedTextColor.GOLD))).append((Component)Component.text((String)this.permission, (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)"\n"))).append((Component)(this.adminOnly ? Component.text((String)"ADMIN ONLY", (TextColor)NamedTextColor.RED) : Component.text((String)"All players", (TextColor)NamedTextColor.GREEN)));
            return Component.text((String)this.command, (TextColor)NamedTextColor.YELLOW).hoverEvent((HoverEventSource)HoverEvent.showText((Component)hoverText));
        }
    }
}

