/*
 * Decompiled with CFR 0.152.
 */
package com.seristic.lagx.main;

import com.seristic.lagx.api.Module;
import com.seristic.lagx.api.proto.Protocol;
import com.seristic.lagx.commands.CommandManager;
import com.seristic.lagx.commands.PerformanceCommand;
import com.seristic.lagx.inf.Help;
import com.seristic.lagx.managers.LagXPluginManager;
import com.seristic.lagx.util.EntityLimiter;
import com.seristic.lagx.util.EntityStacker;
import com.seristic.lagx.util.HBZTabCompleter;
import com.seristic.lagx.util.ItemFrameOptimizer;
import com.seristic.lagx.util.LagXUtils;
import com.seristic.lagx.util.PlayerDeathTracker;
import com.seristic.lagx.util.TownyIntegration;
import com.seristic.lagx.util.VillagerOptimizer;
import java.io.File;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class LagX
extends JavaPlugin
implements Listener {
    public static final String CONFIG_VERSION = "0.2.0";
    public static final long MEMORY_MBYTE_SIZE = 1024L;
    private LagXPluginManager pluginManager;
    private CommandManager commandManager;
    private PerformanceCommand performanceCommand;
    public static LagX instance;
    private long startTime;
    public static File modDir;
    public static String prefix;

    public void onEnable() {
        this.startTime = System.currentTimeMillis();
        instance = this;
        this.pluginManager = new LagXPluginManager(this);
        try {
            this.pluginManager.initialize();
            Help.init();
            Protocol.init();
            this.commandManager = new CommandManager(this);
            this.getLogger().info("Command Manager initialized with " + this.commandManager.getCommandNames().size() + " commands");
            this.performanceCommand = new PerformanceCommand(this);
            this.registerCommands();
            Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
            this.getLogger().info("\u00a76LagX has been enabled!");
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to enable LagX: " + e.getMessage());
            e.printStackTrace();
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public void onDisable() {
        try {
            Bukkit.getAsyncScheduler().cancelTasks((Plugin)this);
            Bukkit.getGlobalRegionScheduler().cancelTasks((Plugin)this);
            if (this.pluginManager != null) {
                this.pluginManager.shutdown();
            }
            this.commandManager = null;
            this.performanceCommand = null;
            this.pluginManager = null;
            this.getLogger().info("LagX has been disabled!");
        }
        catch (Exception e) {
            this.getLogger().severe("Error during LagX shutdown: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void registerCommands() {
        PluginCommand lagxCmd = this.getCommand("lagx");
        if (lagxCmd != null) {
            lagxCmd.setExecutor((CommandExecutor)this);
            lagxCmd.setTabCompleter((TabCompleter)new HBZTabCompleter());
        } else {
            this.getLogger().severe("Command 'lagx' not found in plugin.yml");
        }
        PluginCommand perfCmd = this.getCommand("lagxperf");
        if (perfCmd != null) {
            perfCmd.setExecutor((CommandExecutor)this.performanceCommand);
            perfCmd.setTabCompleter((TabCompleter)this.performanceCommand);
        } else {
            this.getLogger().severe("Command 'lagxperf' not found in plugin.yml");
        }
        this.getLogger().info("Commands registered successfully");
    }

    public boolean onCommand(@NotNull CommandSender sender, Command cmd, @NotNull String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("lagx")) {
            String cmd0;
            Player player;
            Player player2 = player = sender instanceof Player ? (Player)sender : null;
            if (args.length == 0) {
                if (LagX.hasPermission(player, "lagx.help")) {
                    return this.commandManager != null ? this.commandManager.handleCommand(sender, args) : false;
                }
                sender.sendMessage("\u00a7cYou don't have permission to use this command.");
                return true;
            }
            switch (cmd0 = args[0].toLowerCase()) {
                case "clear": 
                case "c": {
                    return this.commandManager != null ? this.commandManager.handleCommand(sender, args) : false;
                }
                case "tps": {
                    if (LagX.hasPermission(player, "lagx.tps")) {
                        return this.commandManager != null ? this.commandManager.handleCommand(sender, args) : false;
                    }
                    sender.sendMessage("\u00a7cYou don't have permission to use this command.");
                    return true;
                }
                case "help": 
                case "h": {
                    return this.commandManager != null ? this.commandManager.handleCommand(sender, args) : false;
                }
            }
            return this.commandManager != null ? this.commandManager.handleCommand(sender, args) : false;
        }
        return false;
    }

    @EventHandler
    public void onSpawn(EntitySpawnEvent e) {
        EntityLimiter limiter;
        if (this.pluginManager == null || this.pluginManager.getFeatureManager() == null || this.pluginManager.getFeatureManager().getEntityLimiter() == null || (limiter = this.pluginManager.getFeatureManager().getEntityLimiter()).isEnabled()) {
            // empty if block
        }
    }

    public static LagX getInstance() {
        return instance;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public LagXPluginManager getPluginManager() {
        return this.pluginManager;
    }

    public EntityLimiter getEntityLimiter() {
        return this.pluginManager != null && this.pluginManager.getFeatureManager() != null ? this.pluginManager.getFeatureManager().getEntityLimiter() : null;
    }

    public VillagerOptimizer getVillagerOptimizer() {
        return this.pluginManager != null && this.pluginManager.getFeatureManager() != null ? this.pluginManager.getFeatureManager().getVillagerOptimizer() : null;
    }

    public EntityStacker getEntityStacker() {
        return this.pluginManager != null && this.pluginManager.getFeatureManager() != null ? this.pluginManager.getFeatureManager().getEntityStacker() : null;
    }

    public ItemFrameOptimizer getItemFrameOptimizer() {
        return this.pluginManager != null && this.pluginManager.getFeatureManager() != null ? this.pluginManager.getFeatureManager().getItemFrameOptimizer() : null;
    }

    public PlayerDeathTracker getPlayerDeathTracker() {
        return this.pluginManager != null && this.pluginManager.getFeatureManager() != null ? this.pluginManager.getFeatureManager().getPlayerDeathTracker() : null;
    }

    public static TownyIntegration getTownyIntegration() {
        if (instance != null && LagX.instance.pluginManager != null && LagX.instance.pluginManager.getIntegrationManager() != null) {
            return LagX.instance.pluginManager.getIntegrationManager().getTownyIntegration();
        }
        return null;
    }

    public void optimizeVillagersInWorld(World world, CommandSender sender) {
        if (world != null && this.getVillagerOptimizer() != null) {
            Help.sendMsg(sender, "\u00a7eStarting villager optimization in world \u00a7b" + world.getName() + "\u00a7e...", true);
            int totalVillagers = 0;
            for (Entity entity : world.getEntities()) {
                if (!(entity instanceof Villager)) continue;
                ++totalVillagers;
            }
            int optimized = 0;
            for (Entity entity : world.getEntities()) {
                if (!(entity instanceof Villager)) continue;
                ++optimized;
            }
            Help.sendMsg(sender, "\u00a7aManually optimized \u00a7b" + optimized + "\u00a7a villagers in world \u00a7e" + world.getName(), true);
        } else if (sender != null) {
            Help.sendMsg(sender, "\u00a7cCannot optimize villagers: world is null or villager optimizer is not available", true);
        }
    }

    public static boolean hasPermission(Player player, String permission) {
        return LagXUtils.hasPermission(player, permission);
    }

    public static boolean hasPermission(CommandSender sender, String permission) {
        return LagXUtils.hasPermission(sender, permission);
    }

    public static void broadcast(String message) {
        LagXUtils.broadcast(message);
    }

    public static void broadcastWarn(String message) {
        LagXUtils.broadcastWarn(message);
    }

    public static String[] getModulesList() {
        if (instance != null && LagX.instance.pluginManager != null && LagX.instance.pluginManager.getModuleLoader() != null) {
            return LagX.instance.pluginManager.getModuleLoader().getModulesList();
        }
        return new String[0];
    }

    public static boolean areWarningsEnabled() {
        if (instance != null && LagX.instance.pluginManager != null && LagX.instance.pluginManager.getConfigManager() != null) {
            return LagX.instance.pluginManager.getConfigManager().areWarningsEnabled();
        }
        return true;
    }

    public static void setWarningsEnabled(boolean enabled) {
        if (instance != null && LagX.instance.pluginManager != null && LagX.instance.pluginManager.getConfigManager() != null) {
            LagX.instance.pluginManager.getConfigManager().setWarningsEnabled(enabled);
        }
    }

    public static String[] getData(Module module) {
        if (instance != null && LagX.instance.pluginManager != null && LagX.instance.pluginManager.getModuleLoader() != null) {
            return LagX.instance.pluginManager.getModuleLoader().getData(module);
        }
        return new String[]{"Unknown", "0.0.0", "Unknown"};
    }

    public static String[] getProtocolList() {
        return new String[0];
    }

    static {
        prefix = "\u00a76\u00a7lLagX \u00a77\u00a7l>>\u00a7r ";
    }
}

