/*
 * Decompiled with CFR 0.152.
 */
package com.seristic.lagx.managers;

import com.seristic.lagx.main.LagX;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigurationManager {
    private final LagX plugin;
    private FileConfiguration config;
    private File configFile;
    public static final String CONFIG_VERSION = "0.2.0";

    public ConfigurationManager(LagX plugin) {
        this.plugin = plugin;
        this.configFile = new File(plugin.getDataFolder(), "config.yml");
    }

    public void initialize() {
        YamlConfiguration existingConfig;
        String existingVersion;
        boolean configExists;
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdirs();
        }
        if ((configExists = this.configFile.exists()) && !CONFIG_VERSION.equals(existingVersion = (existingConfig = YamlConfiguration.loadConfiguration((File)this.configFile)).getString("version", "0.0.0"))) {
            this.plugin.getLogger().warning("Config version mismatch! Found: " + existingVersion + ", Expected: 0.2.0");
            this.plugin.getLogger().warning("Backing up old config and generating new one...");
            File backup = new File(this.plugin.getDataFolder(), "config.yml.backup-" + existingVersion);
            try {
                if (this.configFile.renameTo(backup)) {
                    this.plugin.getLogger().info("Old config backed up to: " + backup.getName());
                    configExists = false;
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to backup old config: " + e.getMessage());
            }
        }
        if (!configExists) {
            this.plugin.saveDefaultConfig();
            this.plugin.getLogger().info("Generated new config file with version 0.2.0");
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.updateConfigDefaults();
        this.plugin.getLogger().info("Configuration loaded successfully");
    }

    private void updateConfigDefaults() {
    }

    public void reload() {
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.plugin.getLogger().info("Configuration reloaded");
    }

    public void saveConfig() {
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save configuration: " + e.getMessage());
        }
    }

    public void shutdown() {
        this.saveConfig();
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public boolean isFeatureEnabled(String featureName) {
        return this.config.getBoolean("features." + featureName + ".enabled", false);
    }

    public void setFeatureEnabled(String featureName, boolean enabled) {
        this.config.set("features." + featureName + ".enabled", (Object)enabled);
        this.saveConfig();
    }

    public boolean isTaskEnabled(String taskName) {
        if ("lag-removal".equals(taskName)) {
            return this.config.getBoolean("auto-lag-removal.run", true);
        }
        return this.config.getBoolean("tasks." + taskName + ".enabled", false);
    }

    public int getTaskInterval(String taskName) {
        if ("lag-removal".equals(taskName)) {
            if (this.config.getBoolean("auto-lag-removal.debug", false)) {
                return 1;
            }
            return this.config.getInt("auto-lag-removal.every", 10);
        }
        return this.config.getInt("tasks." + taskName + ".interval", 10);
    }

    public boolean isDebugMode() {
        return this.config.getBoolean("auto-lag-removal.debug", false);
    }

    public boolean isIntegrationEnabled(String integrationName) {
        boolean defaultValue = "towny".equalsIgnoreCase(integrationName);
        return this.config.getBoolean("integrations." + integrationName + ".enabled", defaultValue);
    }

    public boolean isCopyrightPluginOverrideEnabled() {
        return this.config.getBoolean("integrations.copyright-plugin.override-protection", false);
    }

    public boolean requiresCommandPermission() {
        return this.config.getBoolean("commands.require-permission", true);
    }

    public boolean isTabCompletionEnabled() {
        return this.config.getBoolean("commands.tab-completion", true);
    }

    public boolean areWarningsEnabled() {
        return this.config.getBoolean("protocol_warnings.enabled", true);
    }

    public void setWarningsEnabled(boolean enabled) {
        this.config.set("protocol_warnings.enabled", (Object)enabled);
        this.saveConfig();
    }

    public double getTpsWarningThreshold() {
        return this.config.getDouble("warnings.tps-threshold", 18.0);
    }

    public int getMemoryWarningThreshold() {
        return this.config.getInt("warnings.memory-threshold", 80);
    }

    public String getString(String path, String defaultValue) {
        return this.config.getString(path, defaultValue);
    }

    public int getInt(String path, int defaultValue) {
        return this.config.getInt(path, defaultValue);
    }

    public boolean getBoolean(String path, boolean defaultValue) {
        return this.config.getBoolean(path, defaultValue);
    }

    public List<String> getStringList(String path) {
        return this.config.getStringList(path);
    }
}

