/*
 * Decompiled with CFR 0.152.
 */
package com.seristic.lagx.managers;

import com.seristic.lagx.main.LagX;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class EventManager {
    private final LagX plugin;
    private final List<Listener> registeredListeners = new ArrayList<Listener>();

    public EventManager(LagX plugin) {
        this.plugin = plugin;
    }

    public void initialize() {
        this.plugin.getLogger().info("Registering event listeners...");
        this.registerListener(this.plugin);
        this.plugin.getLogger().info("Registered " + this.registeredListeners.size() + " event listeners");
    }

    public void registerListener(Listener listener) {
        Bukkit.getPluginManager().registerEvents(listener, (Plugin)this.plugin);
        this.registeredListeners.add(listener);
    }

    public void unregisterListener(Listener listener) {
        HandlerList.unregisterAll((Listener)listener);
        this.registeredListeners.remove(listener);
    }

    public void shutdown() {
        this.plugin.getLogger().info("Unregistering event listeners...");
        for (Listener listener : this.registeredListeners) {
            HandlerList.unregisterAll((Listener)listener);
        }
        this.registeredListeners.clear();
    }

    public List<Listener> getRegisteredListeners() {
        return new ArrayList<Listener>(this.registeredListeners);
    }
}

