/*
 * Decompiled with CFR 0.152.
 */
package com.seristic.lagx.managers;

import com.seristic.lagx.main.LagX;
import com.seristic.lagx.managers.ConfigurationManager;
import com.seristic.lagx.util.EntityLimiter;
import com.seristic.lagx.util.EntityStacker;
import com.seristic.lagx.util.ItemFrameOptimizer;
import com.seristic.lagx.util.PlayerDeathTracker;
import com.seristic.lagx.util.VillagerOptimizer;
import java.util.HashMap;
import java.util.Map;

public class FeatureManager {
    private final LagX plugin;
    private final ConfigurationManager configManager;
    private EntityLimiter entityLimiter;
    private VillagerOptimizer villagerOptimizer;
    private EntityStacker entityStacker;
    private ItemFrameOptimizer itemFrameOptimizer;
    private PlayerDeathTracker playerDeathTracker;
    private final Map<String, Object> features = new HashMap<String, Object>();
    private boolean initialized = false;

    public FeatureManager(LagX plugin, ConfigurationManager configManager) {
        this.plugin = plugin;
        this.configManager = configManager;
    }

    public void initialize() {
        if (this.initialized) {
            this.plugin.getLogger().warning("FeatureManager is already initialized");
            return;
        }
        this.plugin.getLogger().info("Initializing performance features...");
        try {
            this.initializeEntityLimiter();
            this.initializeVillagerOptimizer();
            this.initializeEntityStacker();
            this.initializeItemFrameOptimizer();
            this.initializePlayerDeathTracker();
            this.initialized = true;
            this.plugin.getLogger().info("Initialized " + this.features.size() + " performance features");
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to initialize features: " + e.getMessage());
            throw new RuntimeException("Feature initialization failed", e);
        }
    }

    private void initializeEntityLimiter() {
        if (this.configManager.isFeatureEnabled("entity-limiter")) {
            try {
                this.entityLimiter = new EntityLimiter(this.plugin);
                this.features.put("entity-limiter", this.entityLimiter);
                this.plugin.getLogger().info("Entity Limiter enabled");
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to initialize EntityLimiter: " + e.getMessage());
            }
        }
    }

    private void initializeVillagerOptimizer() {
        if (this.configManager.isFeatureEnabled("villager-optimizer")) {
            try {
                this.villagerOptimizer = new VillagerOptimizer(this.plugin);
                this.features.put("villager-optimizer", this.villagerOptimizer);
                this.plugin.getLogger().info("Villager Optimizer enabled");
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to initialize VillagerOptimizer: " + e.getMessage());
            }
        }
    }

    private void initializeEntityStacker() {
        if (this.configManager.isFeatureEnabled("entity-stacker")) {
            try {
                this.entityStacker = new EntityStacker(this.plugin);
                this.features.put("entity-stacker", this.entityStacker);
                this.plugin.getLogger().info("Entity Stacker enabled");
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to initialize EntityStacker: " + e.getMessage());
            }
        }
    }

    private void initializeItemFrameOptimizer() {
        if (this.configManager.isFeatureEnabled("itemframe-optimizer")) {
            try {
                this.itemFrameOptimizer = new ItemFrameOptimizer(this.plugin);
                this.features.put("itemframe-optimizer", this.itemFrameOptimizer);
                this.plugin.getLogger().info("ItemFrame Optimizer enabled");
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to initialize ItemFrameOptimizer: " + e.getMessage());
            }
        }
    }

    private void initializePlayerDeathTracker() {
        if (this.configManager.isFeatureEnabled("death-tracker")) {
            try {
                this.playerDeathTracker = new PlayerDeathTracker(this.plugin);
                this.features.put("death-tracker", this.playerDeathTracker);
                this.plugin.getLogger().info("Player Death Tracker enabled");
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to initialize PlayerDeathTracker: " + e.getMessage());
            }
        }
    }

    public void shutdown() {
        if (!this.initialized) {
            return;
        }
        this.plugin.getLogger().info("Shutting down performance features...");
        this.entityLimiter = null;
        this.villagerOptimizer = null;
        this.entityStacker = null;
        this.itemFrameOptimizer = null;
        this.playerDeathTracker = null;
        this.features.clear();
        this.initialized = false;
    }

    public void reload() {
        this.shutdown();
        this.initialize();
    }

    public EntityLimiter getEntityLimiter() {
        return this.entityLimiter;
    }

    public VillagerOptimizer getVillagerOptimizer() {
        return this.villagerOptimizer;
    }

    public EntityStacker getEntityStacker() {
        return this.entityStacker;
    }

    public ItemFrameOptimizer getItemFrameOptimizer() {
        return this.itemFrameOptimizer;
    }

    public PlayerDeathTracker getPlayerDeathTracker() {
        return this.playerDeathTracker;
    }

    public <T> T getFeature(String name, Class<T> type) {
        Object feature = this.features.get(name);
        if (type.isInstance(feature)) {
            return (T)feature;
        }
        return null;
    }

    public boolean isFeatureEnabled(String name) {
        return this.features.containsKey(name);
    }

    public Map<String, Object> getAllFeatures() {
        return new HashMap<String, Object>(this.features);
    }
}

