/*
 * Decompiled with CFR 0.152.
 */
package com.seristic.lagx.managers;

import com.seristic.lagx.api.Module;
import com.seristic.lagx.main.LagX;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipFile;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class ModuleLoader {
    private final LagX plugin;
    private final Map<Module, String[]> loadedModules = new HashMap<Module, String[]>();
    private File moduleDirectory;

    public ModuleLoader(LagX plugin) {
        this.plugin = plugin;
        this.moduleDirectory = new File(plugin.getDataFolder(), "modules");
    }

    public void initialize() {
        if (!this.moduleDirectory.exists()) {
            this.moduleDirectory.mkdirs();
        }
        LagX.modDir = this.moduleDirectory;
        this.loadModules();
    }

    public void loadModules() {
        this.loadedModules.clear();
        File[] moduleFiles = this.moduleDirectory.listFiles((dir, name) -> name.endsWith(".jar"));
        if (moduleFiles == null) {
            this.plugin.getLogger().info("No module files found in modules directory");
            return;
        }
        this.plugin.getLogger().info("Loading modules from " + this.moduleDirectory.getPath());
        for (File moduleFile : moduleFiles) {
            try {
                this.loadModule(moduleFile);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to load module " + moduleFile.getName() + ": " + e.getMessage());
            }
        }
        this.plugin.getLogger().info("Loaded " + this.loadedModules.size() + " module(s)");
    }

    private void loadModule(File moduleFile) throws IOException, InvalidConfigurationException, ReflectiveOperationException {
        try (ZipFile zipFile = new ZipFile(moduleFile);){
            if (zipFile.getEntry("module.yml") == null) {
                this.plugin.getLogger().info("LagX located an invalid module named \"" + moduleFile.getName() + "\" - missing module.yml");
                return;
            }
            YamlConfiguration moduleConfig = new YamlConfiguration();
            try (InputStreamReader reader = new InputStreamReader(zipFile.getInputStream(zipFile.getEntry("module.yml")));){
                moduleConfig.load((Reader)reader);
            }
            String name = moduleConfig.getString("name");
            String version = moduleConfig.getString("version");
            String author = moduleConfig.getString("author");
            String mainClass = moduleConfig.getString("main");
            if (name == null || version == null || author == null || mainClass == null) {
                this.plugin.getLogger().info("LagX located an invalid module named \"" + moduleFile.getName() + "\" - incomplete module.yml");
                return;
            }
            try (URLClassLoader classLoader = new URLClassLoader(new URL[]{moduleFile.toURI().toURL()}, ((Object)((Object)this.plugin)).getClass().getClassLoader());){
                Class<?> moduleClass = classLoader.loadClass(mainClass);
                Module module = (Module)moduleClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.loadedModules.put(module, new String[]{name, version, author});
                module.onEnable();
                this.plugin.getLogger().info("Loaded module: " + name + " v" + version + " by " + author);
            }
        }
    }

    public void shutdown() {
        for (Module module : this.loadedModules.keySet()) {
            try {
                module.onDisable();
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error disabling module: " + e.getMessage());
            }
        }
        this.loadedModules.clear();
    }

    public String[] getModulesList() {
        return (String[])this.loadedModules.values().stream().map(info -> info[0] + " v" + info[1] + " by " + info[2]).toArray(String[]::new);
    }

    public String[] getData(Module module) {
        return this.loadedModules.get(module);
    }

    public int getLoadedModuleCount() {
        return this.loadedModules.size();
    }

    public Map<Module, String[]> getLoadedModules() {
        return new HashMap<Module, String[]>(this.loadedModules);
    }
}

