/*
 * Decompiled with CFR 0.152.
 */
package com.seristic.lagx.managers;

import com.seristic.lagx.main.LagX;
import com.seristic.lagx.managers.ConfigurationManager;
import com.seristic.lagx.util.ColorUtil;
import com.seristic.lagx.util.PlayerDeathTracker;
import com.seristic.lagx.util.TownyIntegration;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TaskManager {
    private final LagX plugin;
    private final ConfigurationManager configManager;
    private final Map<String, ScheduledTask> tasks = new HashMap<String, ScheduledTask>();

    public TaskManager(LagX plugin, ConfigurationManager configManager) {
        this.plugin = plugin;
        this.configManager = configManager;
    }

    public void initialize() {
        this.plugin.getLogger().info("Starting scheduled tasks...");
        this.startChunkUnloadTask();
        this.startLagRemovalTask();
        this.startEntityCleanupTask();
        this.plugin.getLogger().info("Started " + this.tasks.size() + " scheduled tasks");
    }

    private void startChunkUnloadTask() {
        if (!this.configManager.isTaskEnabled("chunk-unload")) {
            return;
        }
        int interval = this.configManager.getTaskInterval("chunk-unload");
        long intervalSeconds = (long)interval * 60L;
        ScheduledTask task = Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)this.plugin, scheduledTask -> this.performChunkUnload(), intervalSeconds * 20L, intervalSeconds * 20L);
        this.tasks.put("chunk-unload", task);
        this.plugin.getLogger().info("Chunk unload task started (interval: " + interval + " minutes)");
    }

    private void startLagRemovalTask() {
        if (!this.configManager.isTaskEnabled("lag-removal")) {
            return;
        }
        int interval = this.configManager.getTaskInterval("lag-removal");
        long intervalSeconds = (long)interval * 60L;
        int warningSeconds = this.configManager.isDebugMode() ? 5 : 60;
        ScheduledTask task = Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)this.plugin, scheduledTask -> this.schedulePerWorldLagRemovalWithWarnings(warningSeconds), intervalSeconds * 20L, intervalSeconds * 20L);
        this.tasks.put("lag-removal", task);
        this.plugin.getLogger().info("Lag removal task started (interval: " + interval + " minutes, warnings: " + warningSeconds + "s)");
    }

    private void startEntityCleanupTask() {
        if (!this.configManager.isTaskEnabled("entity-cleanup")) {
            return;
        }
        int interval = this.configManager.getTaskInterval("entity-cleanup");
        long intervalSeconds = (long)interval * 60L;
        ScheduledTask task = Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)this.plugin, scheduledTask -> this.schedulePerWorldEntityCleanup(), intervalSeconds * 20L, intervalSeconds * 20L);
        this.tasks.put("entity-cleanup", task);
        this.plugin.getLogger().info("Entity cleanup task started (interval: " + interval + " minutes)");
    }

    private void performChunkUnload() {
        try {
            for (World world : Bukkit.getWorlds()) {
                Chunk[] chunks;
                for (Chunk chunk : chunks = world.getLoadedChunks()) {
                    if (!chunk.getPluginChunkTickets().isEmpty() || chunk.isForceLoaded()) continue;
                    Bukkit.getRegionScheduler().execute((Plugin)this.plugin, world, chunk.getX(), chunk.getZ(), () -> {
                        try {
                            if (world.unloadChunk(chunk)) {
                                this.plugin.getLogger().fine("Unloaded chunk at " + chunk.getX() + "," + chunk.getZ() + " in " + world.getName());
                            }
                        }
                        catch (Exception e) {
                            this.plugin.getLogger().warning("Error unloading chunk at " + chunk.getX() + "," + chunk.getZ() + " in " + world.getName() + ": " + e.getMessage());
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error during chunk unload task: " + e.getMessage());
        }
    }

    private void schedulePerWorldLagRemovalWithWarnings(int warningSeconds) {
        boolean warningsEnabled = this.configManager.areWarningsEnabled();
        boolean debugMode = this.configManager.isDebugMode();
        if (warningsEnabled || debugMode) {
            String prefix = ColorUtil.color(this.plugin.getConfig().getString("prefix", "\u00a76\u00a7lLagX \u00a77\u00a7l>>\u00a7r "));
            String warningMessage = debugMode ? prefix.replace("%PREFIX%", "") + "\u00a7c\u00a7l[DEBUG] \u00a7eClearing ground items in \u00a7b" + warningSeconds + " \u00a7eseconds" : prefix.replace("%PREFIX%", "") + "\u00a7eClearing ground items in \u00a7b" + warningSeconds + " \u00a7eseconds";
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!warningsEnabled && !player.hasPermission("lagx.warnings.receive")) continue;
                player.sendMessage(warningMessage);
            }
        }
        Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)this.plugin, task -> {
            this.schedulePerWorldLagRemoval();
            if (warningsEnabled || debugMode) {
                String prefix = ColorUtil.color(this.plugin.getConfig().getString("prefix", "\u00a76\u00a7lLagX \u00a77\u00a7l>>\u00a7r "));
                String completeMessage = debugMode ? prefix.replace("%PREFIX%", "") + "\u00a7c\u00a7l[DEBUG] \u00a7eAll items on the ground have been cleared." : prefix.replace("%PREFIX%", "") + "\u00a7eAll items on the ground have been cleared.";
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!warningsEnabled && !player.hasPermission("lagx.warnings.receive")) continue;
                    player.sendMessage(completeMessage);
                }
            }
        }, (long)warningSeconds * 20L);
    }

    private void schedulePerWorldLagRemoval() {
        PlayerDeathTracker deathTracker = null;
        try {
            deathTracker = this.plugin.getPlayerDeathTracker();
        }
        catch (Exception exception) {
            // empty catch block
        }
        TownyIntegration towny = LagX.getTownyIntegration();
        for (World world : Bukkit.getWorlds()) {
            for (Chunk chunk : world.getLoadedChunks()) {
                PlayerDeathTracker finalDeathTracker = deathTracker;
                Bukkit.getRegionScheduler().execute((Plugin)this.plugin, world, chunk.getX(), chunk.getZ(), () -> {
                    try {
                        int removed = 0;
                        int protectedCount = 0;
                        for (Entity entity : chunk.getEntities()) {
                            boolean isProtected;
                            if (!(entity instanceof Item)) continue;
                            Item item = (Item)entity;
                            boolean bl = isProtected = finalDeathTracker != null && finalDeathTracker.isItemProtected(item);
                            if (!isProtected && towny != null && towny.isTownyEnabled()) {
                                isProtected = towny.isEntityProtected((Entity)item);
                            }
                            if (!isProtected) {
                                item.remove();
                                ++removed;
                                continue;
                            }
                            ++protectedCount;
                        }
                        if (removed > 0 || protectedCount > 0) {
                            this.plugin.getLogger().fine("Cleared " + removed + " items (protected " + protectedCount + ") in chunk " + chunk.getX() + "," + chunk.getZ() + " in " + world.getName());
                        }
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().warning("Error during lag removal in chunk " + chunk.getX() + "," + chunk.getZ() + " in " + world.getName() + ": " + e.getMessage());
                    }
                });
            }
        }
    }

    private void schedulePerWorldEntityCleanup() {
        for (World world : Bukkit.getWorlds()) {
            Bukkit.getRegionScheduler().execute((Plugin)this.plugin, world, 0, 0, () -> {
                try {
                    int cleaned = 0;
                    for (Entity entity : world.getEntities()) {
                        if (!this.shouldCleanupEntity(entity)) continue;
                        entity.remove();
                        ++cleaned;
                    }
                    if (cleaned > 0) {
                        this.plugin.getLogger().info("Cleaned up " + cleaned + " entities in " + world.getName());
                    }
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Error during entity cleanup in " + world.getName() + ": " + e.getMessage());
                }
            });
        }
    }

    private boolean shouldCleanupEntity(Entity entity) {
        if (entity instanceof ExperienceOrb) {
            return entity.getTicksLived() > 2400;
        }
        if (entity instanceof Arrow) {
            return entity.getTicksLived() > 1200;
        }
        return false;
    }

    public void shutdown() {
        this.plugin.getLogger().info("Shutting down scheduled tasks...");
        for (Map.Entry<String, ScheduledTask> entry : this.tasks.entrySet()) {
            try {
                entry.getValue().cancel();
                this.plugin.getLogger().info("Cancelled task: " + entry.getKey());
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error cancelling task " + entry.getKey() + ": " + e.getMessage());
            }
        }
        this.tasks.clear();
    }

    public void reload() {
        this.plugin.getLogger().info("Reloading scheduled tasks...");
        this.shutdown();
        this.initialize();
        this.plugin.getLogger().info("Scheduled tasks reloaded successfully");
    }

    public void cancelTask(String taskName) {
        ScheduledTask task = this.tasks.get(taskName);
        if (task != null) {
            task.cancel();
            this.tasks.remove(taskName);
            this.plugin.getLogger().info("Cancelled task: " + taskName);
        }
    }

    public boolean isTaskRunning(String taskName) {
        ScheduledTask task = this.tasks.get(taskName);
        return task != null && !task.isCancelled();
    }

    public Map<String, ScheduledTask> getAllTasks() {
        return new HashMap<String, ScheduledTask>(this.tasks);
    }
}

