/*
 * Decompiled with CFR 0.152.
 */
package com.seristic.lagx.util;

import com.seristic.lagx.api.proto.Protocol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.generator.WorldInfo;

public class HBZTabCompleter
implements TabCompleter {
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            List<String> commands = Arrays.asList("help", "h", "ping", "p", "tps", "ram", "gc", "info", "i", "status", "master", "m", "protocol", "pr", "clear", "c", "count", "ct", "world", "w", "unload", "u", "stacker", "stack", "entities", "ent", "limiter", "lim", "towny", "town", "preset", "presets", "villagers", "optimize", "reload", "rl", "warnings", "warn");
            return this.filterCompletions(commands, args[0]);
        }
        if (args.length >= 2) {
            String mainCommand;
            switch (mainCommand = args[0].toLowerCase()) {
                case "help": 
                case "h": {
                    return this.filterCompletions(Arrays.asList("1", "2", "3", "4", "5"), args[1]);
                }
                case "world": 
                case "w": {
                    return this.getWorldNames(args[1]);
                }
                case "protocol": 
                case "pr": {
                    return this.handleProtocolCompletion(args);
                }
                case "unload": 
                case "u": {
                    return this.getWorldNames(args[1]);
                }
                case "ping": 
                case "p": {
                    return this.getPlayerNames(args[1]);
                }
                case "clear": 
                case "c": 
                case "count": 
                case "ct": {
                    return this.handleClearCompletion(args);
                }
                case "preset": 
                case "presets": {
                    if (args.length == 2) {
                        return this.filterCompletions(Arrays.asList("info", "set"), args[1]);
                    }
                    if (args.length == 3 && args[1].equalsIgnoreCase("set")) {
                        return this.filterCompletions(Arrays.asList("basic", "advanced", "custom"), args[2]);
                    }
                    return new ArrayList<String>();
                }
                case "entities": {
                    return this.handleEntitiesCompletion(args);
                }
                case "limiter": {
                    return this.handleLimiterCompletion(args);
                }
                case "villagers": 
                case "optimize": {
                    return this.handleVillagerCompletion(args);
                }
                case "stacker": 
                case "stack": {
                    return this.filterCompletions(Arrays.asList("info", "debug", "reload", "stack"), args[1]);
                }
                case "test": {
                    return this.handleTestCompletion(args);
                }
                case "warnings": 
                case "warn": {
                    return this.filterCompletions(Arrays.asList("status", "on", "off", "toggle"), args[1]);
                }
            }
        }
        return completions;
    }

    private List<String> handleProtocolCompletion(String[] args) {
        if (args.length == 2) {
            return this.filterCompletions(Arrays.asList("help", "h", "run", "r", "list", "l"), args[1]);
        }
        if (args.length != 3 || !args[1].equalsIgnoreCase("run") && !args[1].equalsIgnoreCase("r")) {
            return args.length != 4 || !args[1].equalsIgnoreCase("run") && !args[1].equalsIgnoreCase("r") ? new ArrayList<String>() : this.filterCompletions(Arrays.asList("true", "false"), args[3]);
        }
        ArrayList<String> protocols = new ArrayList<String>();
        try {
            Protocol.getProtocols().forEach(protocol -> protocols.add(protocol.id()));
        }
        catch (Exception var4) {
            protocols.addAll(Arrays.asList("cc_items", "cc_entities", "lrgc"));
        }
        return this.filterCompletions(protocols, args[2]);
    }

    private List<String> handleClearCompletion(String[] args) {
        if (args.length == 2) {
            return this.filterCompletions(Arrays.asList("items", "i", "entities", "e", "type", "t", "area", "a"), args[1]);
        }
        if (args.length == 3) {
            String subCommand = args[1].toLowerCase();
            if (subCommand.equals("entities") || subCommand.equals("e")) {
                return this.filterCompletions(Arrays.asList("hostile", "h", "peaceful", "p", "all", "a"), args[2]);
            }
            if (subCommand.equals("type") || subCommand.equals("t")) {
                return this.filterCompletions(Arrays.asList("list", "l", "none", "n"), args[2]);
            }
            if (subCommand.equals("area") || subCommand.equals("a")) {
                return this.filterCompletions(Arrays.asList("c:1", "c:3", "c:5", "c:10", "b:50", "b:100", "b:200"), args[2]);
            }
        }
        if (args.length == 4) {
            String subCommandx = args[1].toLowerCase();
            return !subCommandx.equals("area") && !subCommandx.equals("a") ? this.getWorldNames(args[3]) : this.filterCompletions(Arrays.asList("all", "hostile", "peaceful", "items", "animals", "mobs"), args[3]);
        }
        if (args.length < 4 || !args[1].equalsIgnoreCase("type") && !args[1].equalsIgnoreCase("t")) {
            return new ArrayList<String>();
        }
        List<String> entityTypes = Arrays.stream(EntityType.values()).map(Enum::name).map(String::toLowerCase).collect(Collectors.toList());
        return this.filterCompletions(entityTypes, args[args.length - 1]);
    }

    private List<String> handleEntitiesCompletion(String[] args) {
        if (args.length == 2) {
            return this.filterCompletions(Arrays.asList("info", "i", "count", "c", "stats", "s"), args[1]);
        }
        return new ArrayList<String>();
    }

    private List<String> handleLimiterCompletion(String[] args) {
        if (args.length == 2) {
            return this.filterCompletions(Arrays.asList("info", "status", "reload", "enable", "disable"), args[1]);
        }
        return new ArrayList<String>();
    }

    private List<String> handleTestCompletion(String[] args) {
        if (args.length == 2) {
            return this.filterCompletions(Arrays.asList("death", "unprotected", "stack", "clear", "spawn", "protection", "full"), args[1]);
        }
        if (args.length == 3 && args[1].equalsIgnoreCase("spawn")) {
            return this.filterCompletions(Arrays.asList("zombie", "item", "skeleton", "cow", "pig", "chicken"), args[2]);
        }
        return args.length == 4 && args[1].equalsIgnoreCase("spawn") ? this.filterCompletions(Arrays.asList("1", "5", "10", "20", "50"), args[3]) : new ArrayList<String>();
    }

    private List<String> handleVillagerCompletion(String[] args) {
        if (args.length == 2) {
            return this.filterCompletions(Arrays.asList("status", "reload", "enable", "disable", "optimize", "stats"), args[1]);
        }
        return args.length == 3 && args[1].equalsIgnoreCase("optimize") ? this.getWorldNames(args[2]) : new ArrayList<String>();
    }

    private List<String> getWorldNames(String partial) {
        List<String> worldNames = Bukkit.getWorlds().stream().map(WorldInfo::getName).collect(Collectors.toList());
        return this.filterCompletions(worldNames, partial);
    }

    private List<String> getPlayerNames(String partial) {
        List<String> playerNames = Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
        return this.filterCompletions(playerNames, partial);
    }

    private List<String> filterCompletions(List<String> options, String partial) {
        if (partial != null && !partial.isEmpty()) {
            String lowerPartial = partial.toLowerCase();
            return options.stream().filter(option -> option.toLowerCase().startsWith(lowerPartial)).collect(Collectors.toList());
        }
        return options;
    }
}

