/*
 * Decompiled with CFR 0.152.
 */
package com.seristic.lagx.util;

import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LagXUtils {
    public static boolean hasPermission(Player player, String permission) {
        if (player == null) {
            return true;
        }
        if (player.isOp()) {
            return true;
        }
        if (player.hasPermission(permission)) {
            return true;
        }
        return player.hasPermission("lagx.*") || player.hasPermission("lagx.admin");
    }

    public static boolean hasPermission(CommandSender sender, String permission) {
        if (sender == null) {
            return true;
        }
        if (sender instanceof Player) {
            return LagXUtils.hasPermission((Player)sender, permission);
        }
        return true;
    }

    public static void broadcast(String message) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!LagXUtils.hasPermission(player, "lagx.broadcast")) continue;
            player.sendMessage(message);
        }
        Bukkit.getLogger().info(message);
    }

    public static void broadcastWarn(String message) {
        String formattedMessage = "\u00a7c[LagX Warning] " + message;
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!LagXUtils.hasPermission(player, "lagx.warnings")) continue;
            player.sendMessage(formattedMessage);
        }
        Bukkit.getLogger().warning(message);
    }

    public static long bytesToMB(long bytes) {
        return bytes / 0x100000L;
    }

    public static String formatDecimal(double value) {
        return String.format("%.2f", value);
    }

    public static String safeString(Object obj) {
        return obj != null ? obj.toString() : "null";
    }
}

